/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.integer.ConvertIntegerToHexPredicate;
import com.siyeh.ipp.integer.ConvertNumberIntentionBase;
import org.jetbrains.annotations.NotNull;

public class ConvertIntegerToHexIntention
extends ConvertNumberIntentionBase {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ConvertIntegerToHexPredicate convertIntegerToHexPredicate = new ConvertIntegerToHexPredicate();
        if (convertIntegerToHexPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/integer/ConvertIntegerToHexIntention", "getElementPredicate"));
        }
        return convertIntegerToHexPredicate;
    }

    @Override
    protected String convertValue(Number value, PsiType type, boolean negated) {
        if (PsiType.INT.equals((Object)type)) {
            int intValue = negated ? -value.intValue() : value.intValue();
            return "0x" + Integer.toHexString(intValue);
        }
        if (PsiType.LONG.equals((Object)type)) {
            long longValue = negated ? -value.longValue() : value.longValue();
            return "0x" + Long.toHexString(longValue) + "L";
        }
        if (PsiType.FLOAT.equals((Object)type)) {
            float floatValue = negated ? -value.floatValue() : value.floatValue();
            return Float.toHexString(floatValue) + 'f';
        }
        if (PsiType.DOUBLE.equals((Object)type)) {
            double doubleValue = negated ? -value.doubleValue() : value.doubleValue();
            return Double.toHexString(doubleValue);
        }
        return null;
    }
}

