/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.openapi.options.BaseConfigurableWithChangeSupport;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.intellij.images.ImagesBundle;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.impl.ImagesOptionsComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImagesConfigurable
extends BaseConfigurableWithChangeSupport
implements SearchableConfigurable,
PropertyChangeListener {
    private static final String DISPLAY_NAME = ImagesBundle.message("settings.page.name", new Object[0]);
    private ImagesOptionsComponent myComponent;

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return "preferences.images";
    }

    public JComponent createComponent() {
        if (this.myComponent == null) {
            this.myComponent = new ImagesOptionsComponent();
            Options options = OptionsManager.getInstance().getOptions();
            options.addPropertyChangeListener(this);
            this.myComponent.getOptions().inject(options);
            this.myComponent.updateUI();
            this.myComponent.getOptions().addPropertyChangeListener(this);
            this.setModified(false);
        }
        return this.myComponent.getContentPane();
    }

    public void apply() {
        if (this.myComponent != null) {
            Options options = OptionsManager.getInstance().getOptions();
            options.inject(this.myComponent.getOptions());
        }
    }

    public void reset() {
        if (this.myComponent != null) {
            Options options = OptionsManager.getInstance().getOptions();
            this.myComponent.getOptions().inject(options);
            this.myComponent.updateUI();
        }
    }

    public void disposeUIResources() {
        if (this.myComponent != null) {
            Options options = OptionsManager.getInstance().getOptions();
            options.removePropertyChangeListener(this);
            this.myComponent.getOptions().removePropertyChangeListener(this);
            this.myComponent = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Options uiOptions;
        Options options = OptionsManager.getInstance().getOptions();
        this.setModified(!options.equals(uiOptions = this.myComponent.getOptions()));
    }

    public static void show(Project project2) {
        ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)new ImagesConfigurable());
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("Images" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/options/impl/ImagesConfigurable", "getId"));
        }
        return "Images";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }
}

