/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/builtins/CompanionObjectMapping;", "", "()V", "classesFqNames", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "allClassesWithIntrinsicCompanions", "", "isMappedIntrinsicCompanionObject", "", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "descriptors"})
public final class CompanionObjectMapping {
    private static final LinkedHashSet<FqName> classesFqNames;
    public static final CompanionObjectMapping INSTANCE;

    @NotNull
    public final Set<FqName> allClassesWithIntrinsicCompanions() {
        Set<FqName> set = Collections.unmodifiableSet((Set)classesFqNames);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.unmodifiableSet(classesFqNames)");
        return set;
    }

    public final boolean isMappedIntrinsicCompanionObject(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        if (!DescriptorUtils.isCompanionObject(classDescriptor)) {
            return false;
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(classDescriptor.getContainingDeclaration());
        if (!fqName2.isSafe()) {
            return false;
        }
        return classesFqNames.contains(fqName2.toSafe());
    }

    private CompanionObjectMapping() {
        INSTANCE = this;
        classesFqNames = SetsKt.linkedSetOf((Object[])new FqName[0]);
        for (PrimitiveType type2 : PrimitiveType.NUMBER_TYPES) {
            classesFqNames.add(KotlinBuiltIns.getPrimitiveFqName(type2));
        }
        classesFqNames.add(KotlinBuiltIns.FQ_NAMES.string.toSafe());
        classesFqNames.add(KotlinBuiltIns.FQ_NAMES._enum.toSafe());
    }

    static {
        new CompanionObjectMapping();
    }
}

