/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.compiler.options.ComparingUtils;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.PluginStartupComponent;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JsCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerWorkspaceSettings;

public class KotlinCompilerConfigurableTab
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final Map<String, String> moduleKindDescriptions = new LinkedHashMap<String, String>();
    private final CommonCompilerArguments commonCompilerArguments;
    private final K2JSCompilerArguments k2jsCompilerArguments;
    private final CompilerSettings compilerSettings;
    private final KotlinCompilerWorkspaceSettings compilerWorkspaceSettings;
    private final Project project;
    private JPanel contentPane;
    private JCheckBox generateNoWarningsCheckBox;
    private RawCommandLineEditor additionalArgsOptionsField;
    private JLabel additionalArgsLabel;
    private JCheckBox generateSourceMapsCheckBox;
    private TextFieldWithBrowseButton outputPrefixFile;
    private TextFieldWithBrowseButton outputPostfixFile;
    private JLabel labelForOutputPrefixFile;
    private JLabel labelForOutputPostfixFile;
    private JLabel labelForOutputDirectory;
    private JTextField outputDirectory;
    private JCheckBox copyRuntimeFilesCheckBox;
    private JCheckBox keepAliveCheckBox;
    private JCheckBox enablePreciseIncrementalCheckBox;
    private JComboBox moduleKindComboBox;

    public KotlinCompilerConfigurableTab(Project project) {
        this.$$$setupUI$$$();
        this.commonCompilerArguments = (CommonCompilerArguments)KotlinCommonCompilerArgumentsHolder.getInstance(project).getSettings();
        this.k2jsCompilerArguments = (K2JSCompilerArguments)Kotlin2JsCompilerArgumentsHolder.getInstance(project).getSettings();
        this.compilerSettings = (CompilerSettings)KotlinCompilerSettings.getInstance(project).getSettings();
        this.compilerWorkspaceSettings = (KotlinCompilerWorkspaceSettings)ServiceManager.getService((Project)project, KotlinCompilerWorkspaceSettings.class);
        this.project = project;
        this.additionalArgsOptionsField.attachLabel(this.additionalArgsLabel);
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputPrefixFile, this.outputPrefixFile, KotlinBundle.message("kotlin.compiler.js.option.output.prefix.browse.title", new Object[0]));
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputPostfixFile, this.outputPostfixFile, KotlinBundle.message("kotlin.compiler.js.option.output.postfix.browse.title", new Object[0]));
        this.labelForOutputDirectory.setLabelFor(this.outputDirectory);
        this.copyRuntimeFilesCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab$1", "stateChanged"));
                }
                KotlinCompilerConfigurableTab.this.outputDirectory.setEnabled(KotlinCompilerConfigurableTab.this.copyRuntimeFilesCheckBox.isSelected());
                KotlinCompilerConfigurableTab.this.labelForOutputDirectory.setEnabled(KotlinCompilerConfigurableTab.this.copyRuntimeFilesCheckBox.isSelected());
            }
        });
        this.fillModuleKindList();
    }

    private void fillModuleKindList() {
        for (String moduleKind : moduleKindDescriptions.keySet()) {
            this.moduleKindComboBox.addItem(moduleKind);
        }
        this.moduleKindComboBox.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list2, String value2, int index2, boolean selected, boolean hasFocus) {
                this.setText(KotlinCompilerConfigurableTab.getModuleKindDescription(value2));
            }
        });
    }

    @NotNull
    private static String getModuleKindDescription(@NotNull String moduleKind) {
        if (moduleKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleKind", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getModuleKindDescription"));
        }
        String result2 = moduleKindDescriptions.get(moduleKind);
        assert (result2 != null) : "Module kind " + moduleKind + " was not added to combobox, therefore it should not be here";
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getModuleKindDescription"));
        }
        return string;
    }

    @NotNull
    public String getId() {
        if ("project.kotlinCompiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getId"));
        }
        return "project.kotlinCompiler";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.contentPane;
    }

    public boolean isModified() {
        return ComparingUtils.isModified((JCheckBox)this.generateNoWarningsCheckBox, (boolean)this.commonCompilerArguments.suppressWarnings) || ComparingUtils.isModified((RawCommandLineEditor)this.additionalArgsOptionsField, (String)this.compilerSettings.getAdditionalArguments()) || ComparingUtils.isModified((JCheckBox)this.copyRuntimeFilesCheckBox, (boolean)this.compilerSettings.getCopyJsLibraryFiles()) || ComparingUtils.isModified((JTextField)this.outputDirectory, (String)this.compilerSettings.getOutputDirectoryForJsLibraryFiles()) || ComparingUtils.isModified((JCheckBox)this.enablePreciseIncrementalCheckBox, (boolean)this.compilerWorkspaceSettings.getPreciseIncrementalEnabled()) || ComparingUtils.isModified((JCheckBox)this.keepAliveCheckBox, (boolean)this.compilerWorkspaceSettings.getEnableDaemon()) || ComparingUtils.isModified((JCheckBox)this.generateSourceMapsCheckBox, (boolean)this.k2jsCompilerArguments.sourceMap) || KotlinCompilerConfigurableTab.isModified(this.outputPrefixFile, this.k2jsCompilerArguments.outputPrefix) || KotlinCompilerConfigurableTab.isModified(this.outputPostfixFile, this.k2jsCompilerArguments.outputPostfix) || !this.getSelectedModuleKind().equals(KotlinCompilerConfigurableTab.getModuleKindOrDefault(this.k2jsCompilerArguments.moduleKind));
    }

    @NotNull
    private String getSelectedModuleKind() {
        String string = KotlinCompilerConfigurableTab.getModuleKindOrDefault((String)this.moduleKindComboBox.getSelectedItem());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getSelectedModuleKind"));
        }
        return string;
    }

    public void apply() throws ConfigurationException {
        this.commonCompilerArguments.suppressWarnings = this.generateNoWarningsCheckBox.isSelected();
        this.compilerSettings.setAdditionalArguments(this.additionalArgsOptionsField.getText());
        this.compilerSettings.setCopyJsLibraryFiles(this.copyRuntimeFilesCheckBox.isSelected());
        this.compilerSettings.setOutputDirectoryForJsLibraryFiles(this.outputDirectory.getText());
        this.compilerWorkspaceSettings.setPreciseIncrementalEnabled(this.enablePreciseIncrementalCheckBox.isSelected());
        boolean oldEnableDaemon = this.compilerWorkspaceSettings.getEnableDaemon();
        this.compilerWorkspaceSettings.setEnableDaemon(this.keepAliveCheckBox.isSelected());
        if (this.keepAliveCheckBox.isSelected() != oldEnableDaemon) {
            PluginStartupComponent.getInstance().resetAliveFlag();
        }
        this.k2jsCompilerArguments.sourceMap = this.generateSourceMapsCheckBox.isSelected();
        this.k2jsCompilerArguments.outputPrefix = StringUtil.nullize((String)this.outputPrefixFile.getText(), (boolean)true);
        this.k2jsCompilerArguments.outputPostfix = StringUtil.nullize((String)this.outputPostfixFile.getText(), (boolean)true);
        this.k2jsCompilerArguments.moduleKind = this.getSelectedModuleKind();
        BuildManager.getInstance().clearState(this.project);
    }

    @NotNull
    private static String getModuleKindOrDefault(@Nullable String moduleKindId) {
        if (moduleKindId == null) {
            moduleKindId = "plain";
        }
        String string = moduleKindId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getModuleKindOrDefault"));
        }
        return string;
    }

    public void reset() {
        this.generateNoWarningsCheckBox.setSelected(this.commonCompilerArguments.suppressWarnings);
        this.additionalArgsOptionsField.setText(this.compilerSettings.getAdditionalArguments());
        this.copyRuntimeFilesCheckBox.setSelected(this.compilerSettings.getCopyJsLibraryFiles());
        this.outputDirectory.setText(this.compilerSettings.getOutputDirectoryForJsLibraryFiles());
        this.enablePreciseIncrementalCheckBox.setSelected(this.compilerWorkspaceSettings.getPreciseIncrementalEnabled());
        this.keepAliveCheckBox.setSelected(this.compilerWorkspaceSettings.getEnableDaemon());
        this.generateSourceMapsCheckBox.setSelected(this.k2jsCompilerArguments.sourceMap);
        this.outputPrefixFile.setText(this.k2jsCompilerArguments.outputPrefix);
        this.outputPostfixFile.setText(this.k2jsCompilerArguments.outputPostfix);
        this.moduleKindComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getModuleKindOrDefault(this.k2jsCompilerArguments.moduleKind));
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return "Kotlin Compiler";
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.compiler.kotlin";
    }

    private static void setupFileChooser(@NotNull JLabel label, @NotNull TextFieldWithBrowseButton fileChooser, @NotNull String title) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "setupFileChooser"));
        }
        if (fileChooser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileChooser", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "setupFileChooser"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "setupFileChooser"));
        }
        label.setLabelFor((Component)fileChooser);
        fileChooser.addBrowseFolderListener(title, null, null, new FileChooserDescriptor(true, false, false, false, false, false), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT, false);
    }

    private static boolean isModified(@NotNull TextFieldWithBrowseButton chooser2, @Nullable String currentValue) {
        if (chooser2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooser", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "isModified"));
        }
        return !StringUtil.equals((CharSequence)StringUtil.nullize((String)chooser2.getText(), (boolean)true), (CharSequence)currentValue);
    }

    static {
        moduleKindDescriptions.put("plain", "Plain (put to global scope)");
        moduleKindDescriptions.put("amd", "AMD");
        moduleKindDescriptions.put("commonjs", "CommonJS");
        moduleKindDescriptions.put("umd", "UMD (detect AMD or CommonJS if available, fallback to plain)");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel3;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        RawCommandLineEditor rawCommandLineEditor;
        JLabel jLabel4;
        JCheckBox jCheckBox5;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.generateNoWarningsCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.option.generate.no.warnings"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.additionalArgsLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.option.additional.command.line.parameters"));
        jPanel2.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.additionalArgsOptionsField = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.option.additional.command.line.parameters.dialog.title"));
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.keepAliveCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Keep compiler process alive between invocations");
        jPanel2.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setVisible(true);
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.jvm.option.panel.title"), (int)0, (int)0, null, null));
        this.enablePreciseIncrementalCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Enable precise incremental compilation");
        jPanel3.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setVisible(true);
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.panel.title"), (int)0, (int)0, null, null));
        this.generateSourceMapsCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.generate.sourcemaps"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.labelForOutputPrefixFile = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.prefix"));
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(256, 18), null));
        this.outputPrefixFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.labelForOutputPostfixFile = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.postfix"));
        jPanel4.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(256, 18), null));
        this.outputPostfixFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.labelForOutputDirectory = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.copy.dir"));
        jPanel4.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputDirectory = jTextField = new JTextField();
        jTextField.setText("lib");
        jPanel4.add((Component)jTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.copyRuntimeFilesCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.copy.files"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Module kind:");
        jLabel5.setDisplayedMnemonic('K');
        jLabel5.setDisplayedMnemonicIndex(7);
        jPanel4.add((Component)jLabel5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.moduleKindComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel4.add(jComboBox, new GridConstraints(5, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel5.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

