/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.SmapData;
import org.jetbrains.kotlin.idea.debugger.SmapUtilKt;
import org.jetbrains.kotlin.idea.debugger.SmapUtilKt$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.SourceLineKind;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.load.kotlin.JvmVirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a<\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001aL\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\u00062\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u001d2\u0014\b\u0002\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u001d\u001a\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u0010 \u001a\u00020\u0019\u001a\u0016\u0010!\u001a\u0004\u0018\u00010\"*\u00020#2\u0006\u0010$\u001a\u00020\u000bH\u0002\u00a8\u0006%"}, d2={"findClassFileByPath", "Ljava/io/File;", "packageName", "", "className", "outputDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInlineFunctionLineNumber", "", "file", "lineNumber", "", "project", "Lcom/intellij/openapi/project/Project;", "mapStacktraceLineToSource", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtFile;", "smapData", "Lorg/jetbrains/kotlin/idea/debugger/SmapData;", "line", "lineKind", "Lorg/jetbrains/kotlin/idea/debugger/SourceLineKind;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "readClassFile", "", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "sourceFileFilter", "Lkotlin/Function1;", "libFileFilter", "readDebugInfo", "bytes", "getIntervalIfContains", "Lorg/jetbrains/kotlin/codegen/inline/RangeMapping;", "Lorg/jetbrains/kotlin/codegen/inline/FileMapping;", "destLine", "idea"})
public final class SmapUtilKt {
    public static final boolean isInlineFunctionLineNumber(@NotNull VirtualFile file2, int lineNumber, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiFile psiFile = KotlinRefactoringUtilKt.toPsiFile(file2, project);
        if (psiFile == null) {
            return false;
        }
        int linesInFile = KotlinRefactoringUtilKt.getLineCount((PsiElement)psiFile);
        return lineNumber > linesInFile;
    }

    @Nullable
    public static final byte[] readClassFile(@NotNull Project project, @NotNull JvmClassName jvmName, @NotNull VirtualFile file2, @NotNull Function1<? super VirtualFile, Boolean> sourceFileFilter, @NotNull Function1<? super VirtualFile, Boolean> libFileFilter) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)jvmName, (String)"jvmName");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull(sourceFileFilter, (String)"sourceFileFilter");
        Intrinsics.checkParameterIsNotNull(libFileFilter, (String)"libFileFilter");
        FqName fqName2 = jvmName.getFqNameForClassNameWithoutDollars();
        FqName fqName3 = jvmName.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"jvmName.packageFqName");
        FqName fqNameWithInners = FqNamesUtilKt.tail(fqName2, fqName3);
        if (ProjectRootsUtil.isLibrarySourceFile(project, file2) && ((Boolean)libFileFilter.invoke((Object)file2)).booleanValue()) {
            ClassId classId = new ClassId(jvmName.getPackageFqName(), Name.identifier(fqNameWithInners.asString()));
            JvmVirtualFileFinder fileFinder = JvmVirtualFileFinder.SERVICE.getInstance(project);
            VirtualFile virtualFile2 = fileFinder.findVirtualFileWithHeader(classId);
            if (virtualFile2 == null) {
                return null;
            }
            VirtualFile classFile = virtualFile2;
            return classFile.contentsToByteArray();
        }
        if (ProjectRootsUtil.isProjectSourceFile(project, file2) && ((Boolean)sourceFileFilter.invoke((Object)file2)).booleanValue()) {
            Module module = ProjectFileIndex.SERVICE.getInstance((Project)project).getModuleForFile(file2);
            VirtualFile virtualFile3 = CompilerPaths.getModuleOutputDirectory((Module)module, (boolean)false);
            if (virtualFile3 == null) {
                return null;
            }
            VirtualFile outputDir = virtualFile3;
            String className2 = StringsKt.replace$default((String)fqNameWithInners.asString(), (char)'.', (char)'$', (boolean)false, (int)4, null);
            String string = jvmName.getPackageFqName().asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jvmName.packageFqName.asString()");
            VirtualFile virtualFile4 = outputDir;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"outputDir");
            File file3 = SmapUtilKt.findClassFileByPath(string, className2, virtualFile4);
            if (file3 == null) {
                return null;
            }
            File classByDirectory = file3;
            return FilesKt.readBytes((File)classByDirectory);
        }
        return null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ byte[] readClassFile$default(Project project, JvmClassName jvmClassName, VirtualFile virtualFile2, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readClassFile");
        }
        if ((n & 8) != 0) {
            function1 = readClassFile.1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function12 = readClassFile.2.INSTANCE;
        }
        return SmapUtilKt.readClassFile(project, jvmClassName, virtualFile2, (Function1<? super VirtualFile, Boolean>)function1, (Function1<? super VirtualFile, Boolean>)function12);
    }

    private static final File findClassFileByPath(String packageName, String className2, VirtualFile outputDir) {
        File beforeDexFileClassFile;
        File file2 = AddToStdlibKt.check(new File(outputDir.getPath()), findClassFileByPath.outDirFile.1.INSTANCE);
        if (file2 == null) {
            return null;
        }
        File outDirFile2 = file2;
        String string = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.separator");
        File parentDirectory = new File(outDirFile2, StringsKt.replace$default((String)packageName, (String)".", (String)string, (boolean)false, (int)4, null));
        if (!parentDirectory.exists()) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (beforeDexFileClassFile = new File(parentDirectory, className2 + ".class.before_dex")).exists()) {
            return beforeDexFileClassFile;
        }
        File classFile = new File(parentDirectory, className2 + ".class");
        if (classFile.exists()) {
            return classFile;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Pair<KtFile, Integer> mapStacktraceLineToSource(@NotNull SmapData smapData, int line, @NotNull Project project, @NotNull SourceLineKind lineKind, @NotNull GlobalSearchScope searchScope) {
        int n;
        JvmClassName jvmName;
        Object v1;
        block13: {
            void $receiver$iv;
            SMAP sMAP;
            Intrinsics.checkParameterIsNotNull((Object)smapData, (String)"smapData");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)((Object)lineKind), (String)"lineKind");
            Intrinsics.checkParameterIsNotNull((Object)searchScope, (String)"searchScope");
            switch (SmapUtilKt$WhenMappings.$EnumSwitchMapping$0[lineKind.ordinal()]) {
                case 1: {
                    sMAP = smapData.getKotlinDebugStrata();
                    break;
                }
                case 2: {
                    sMAP = smapData.getKotlinStrata();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (sMAP == null) {
                return null;
            }
            SMAP smap = sMAP;
            Iterable iterable = smap.getFileMappings();
            for (Object element$iv : $receiver$iv) {
                FileMapping it = (FileMapping)element$iv;
                if (!(SmapUtilKt.getIntervalIfContains(it, line) != null)) continue;
                v1 = element$iv;
                break block13;
            }
            v1 = null;
        }
        FileMapping fileMapping = v1;
        if (fileMapping == null) {
            return null;
        }
        FileMapping mappingInfo = fileMapping;
        JvmClassName jvmClassName = jvmName = JvmClassName.byInternalName(mappingInfo.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"jvmName");
        KtFile ktFile = DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(project, searchScope, jvmClassName, mappingInfo.getName());
        if (ktFile == null) {
            return null;
        }
        KtFile sourceFile = ktFile;
        RangeMapping rangeMapping = SmapUtilKt.getIntervalIfContains(mappingInfo, line);
        if (rangeMapping == null) {
            Intrinsics.throwNpe();
        }
        RangeMapping interval = rangeMapping;
        switch (SmapUtilKt$WhenMappings.$EnumSwitchMapping$1[lineKind.ordinal()]) {
            case 1: {
                n = interval.getSource() - 1;
                break;
            }
            case 2: {
                n = interval.mapDestToSource(line) - 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int sourceLine = n;
        return TuplesKt.to((Object)sourceFile, (Object)sourceLine);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final SmapData readDebugInfo(@NotNull byte[] bytes2) {
        SmapData smapData;
        void debugInfo2;
        Intrinsics.checkParameterIsNotNull((Object)bytes2, (String)"bytes");
        ClassReader cr = new ClassReader(bytes2);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        cr.accept(new ClassVisitor((Ref.ObjectRef)debugInfo2, 327680){
            final /* synthetic */ Ref.ObjectRef $debugInfo;

            public void visitSource(@Nullable String source, @Nullable String debug) {
                this.$debugInfo.element = debug;
            }
            {
                this.$debugInfo = $captured_local_variable$0;
                super($super_call_param$1);
            }
        }, 0);
        String string = (String)debugInfo2.element;
        if (string != null) {
            String string2 = string;
            String p1 = string2;
            smapData = new SmapData(p1);
        } else {
            smapData = null;
        }
        return smapData;
    }

    private static final RangeMapping getIntervalIfContains(@NotNull FileMapping $receiver, int destLine) {
        Object v0;
        block1: {
            Iterable $receiver$iv = $receiver.getLineMappings();
            for (Object element$iv : $receiver$iv) {
                RangeMapping it = (RangeMapping)element$iv;
                if (!it.contains(destLine)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

