/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.hierarchy.HierarchyUtils;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallHierarchyBrowser;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtFile;

public class KotlinCallHierarchyProvider
implements HierarchyProvider {
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyProvider", "getTarget"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        PsiElement element2 = KotlinCallHierarchyProvider.getCurrentElement(dataContext, project);
        if (element2 == null) {
            return null;
        }
        if ((element2 = HierarchyUtils.getCallHierarchyElement(element2)) instanceof KtFile || element2 == null || element2.getLanguage() != KotlinLanguage.INSTANCE) {
            return null;
        }
        return element2;
    }

    private static PsiElement getCurrentElement(DataContext dataContext, Project project) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return null;
            }
            if (!ProjectRootsUtil.isInProjectOrLibSource((PsiElement)file2)) {
                return null;
            }
            return TargetElementUtilBase.findTargetElement((Editor)editor, (int)TargetElementUtilBase.getInstance().getAllAccepted());
        }
        return (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(PsiElement target) {
        KotlinCallHierarchyBrowser kotlinCallHierarchyBrowser = new KotlinCallHierarchyBrowser(target.getProject(), target);
        if (kotlinCallHierarchyBrowser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyProvider", "createHierarchyBrowser"));
        }
        return kotlinCallHierarchyBrowser;
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        if (hierarchyBrowser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hierarchyBrowser", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyProvider", "browserActivated"));
        }
        ((KotlinCallHierarchyBrowser)hierarchyBrowser).changeView(CallHierarchyBrowserBase.CALLER_TYPE);
    }
}

