/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.LeakingThisDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.AddModifierFix;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LeakingThisInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "MakeFinalFix", "idea"})
public final class LeakingThisInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitExpression(@NotNull KtExpression expression2) {
                void $receiver$iv;
                Collection elements$iv;
                MakeFinalFix makeFinalFix;
                KtClass klass2;
                KtClassOrObject ktClassOrObject;
                MakeFinalFix memberFix;
                MakeFinalFix makeFinalFix2;
                MakeFinalFix[] modifierListOwner;
                CallableMemberDescriptor memberDescriptorToFix;
                String string;
                LeakingThisDescriptor leakingThisDescriptor;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                BindingContext context = ResolutionUtils.analyzeFully(expression2);
                LeakingThisDescriptor leakingThisDescriptor2 = (LeakingThisDescriptor)context.get(BindingContext.LEAKING_THIS, expression2);
                if (leakingThisDescriptor2 == null) {
                    return;
                }
                LeakingThisDescriptor leakingThisDescriptor3 = leakingThisDescriptor = leakingThisDescriptor2;
                if (leakingThisDescriptor3 instanceof LeakingThisDescriptor.NonFinalClass) {
                    if (!(expression2 instanceof KtThisExpression)) return;
                    string = "Leaking 'this' in constructor of non-final class " + ((LeakingThisDescriptor.NonFinalClass)leakingThisDescriptor).getKlass().getName();
                } else if (leakingThisDescriptor3 instanceof LeakingThisDescriptor.NonFinalProperty) {
                    string = "Accessing non-final property " + ((LeakingThisDescriptor.NonFinalProperty)leakingThisDescriptor).getProperty().getName() + " in constructor";
                } else {
                    if (!(leakingThisDescriptor3 instanceof LeakingThisDescriptor.NonFinalFunction)) return;
                    string = "Calling non-final function " + ((LeakingThisDescriptor.NonFinalFunction)leakingThisDescriptor).getFunction().getName() + " in constructor";
                }
                String description = string;
                LeakingThisDescriptor leakingThisDescriptor4 = leakingThisDescriptor;
                CallableMemberDescriptor callableMemberDescriptor = memberDescriptorToFix = leakingThisDescriptor4 instanceof LeakingThisDescriptor.NonFinalProperty ? (CallableMemberDescriptor)((LeakingThisDescriptor.NonFinalProperty)leakingThisDescriptor).getProperty() : (leakingThisDescriptor4 instanceof LeakingThisDescriptor.NonFinalFunction ? (CallableMemberDescriptor)((LeakingThisDescriptor.NonFinalFunction)leakingThisDescriptor).getFunction() : (CallableMemberDescriptor)null);
                if (callableMemberDescriptor != null) {
                    MakeFinalFix makeFinalFix3;
                    CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
                    CallableMemberDescriptor it = callableMemberDescriptor2;
                    if (Intrinsics.areEqual((Object)((Object)it.getModality()), (Object)((Object)Modality.OPEN))) {
                        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(it);
                        if (!(psiElement instanceof KtDeclaration)) {
                            psiElement = null;
                        }
                        modifierListOwner = (KtDeclaration)psiElement;
                        Name name2 = it.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"it.name");
                        makeFinalFix3 = MakeFinalFix.Companion.create((KtDeclaration)modifierListOwner, name2);
                    } else {
                        makeFinalFix3 = null;
                    }
                    makeFinalFix2 = makeFinalFix3;
                } else {
                    makeFinalFix2 = memberFix = null;
                }
                if (!((ktClassOrObject = leakingThisDescriptor.getClassOrObject()) instanceof KtClass)) {
                    ktClassOrObject = null;
                }
                if ((klass2 = (KtClass)ktClassOrObject) != null && klass2.hasModifier(KtTokens.OPEN_KEYWORD)) {
                    KtDeclaration ktDeclaration = klass2;
                    Name name3 = klass2.getNameAsSafeName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"klass.nameAsSafeName");
                    makeFinalFix = MakeFinalFix.Companion.create(ktDeclaration, name3);
                } else {
                    makeFinalFix = null;
                }
                MakeFinalFix classFix = makeFinalFix;
                modifierListOwner = leakingThisDescriptor;
                ProblemHighlightType problemHighlightType = modifierListOwner instanceof LeakingThisDescriptor.NonFinalProperty || modifierListOwner instanceof LeakingThisDescriptor.NonFinalFunction ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.WEAK_WARNING;
                modifierListOwner = new MakeFinalFix[]{memberFix, classFix};
                ProblemHighlightType problemHighlightType2 = problemHighlightType;
                String string2 = description;
                PsiElement psiElement = (PsiElement)expression2;
                ProblemsHolder problemsHolder = this.$holder;
                Object[] objectArray = (Object[])elements$iv;
                elements$iv = ArraysKt.filterNotNull((Object[])objectArray);
                void v12 = $receiver$iv;
                if (v12 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = (Collection)v12;
                MakeFinalFix[] makeFinalFixArray = thisCollection$iv.toArray(new MakeFinalFix[thisCollection$iv.size()]);
                if (makeFinalFixArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                objectArray = makeFinalFixArray;
                LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])objectArray;
                problemsHolder.registerProblem(psiElement, string2, problemHighlightType2, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LeakingThisInspection$MakeFinalFix;", "Lorg/jetbrains/kotlin/idea/inspections/AddModifierFix;", "modifierListOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "name", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Lorg/jetbrains/kotlin/name/Name;)V", "Companion", "idea"})
    public static final class MakeFinalFix
    extends AddModifierFix {
        public static final Companion Companion = new Companion(null);

        private MakeFinalFix(KtModifierListOwner modifierListOwner, Name name2) {
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.FINAL_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.FINAL_KEYWORD");
            super(modifierListOwner, ktModifierKeywordToken, "Make '" + name2 + "' final");
        }

        public /* synthetic */ MakeFinalFix(@NotNull KtModifierListOwner modifierListOwner, @NotNull Name name2, DefaultConstructorMarker $constructor_marker) {
            this(modifierListOwner, name2);
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/LeakingThisInspection$MakeFinalFix$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/idea/inspections/LeakingThisInspection$MakeFinalFix;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "name", "Lorg/jetbrains/kotlin/name/Name;", "idea"})
        public static final class Companion {
            @Nullable
            public final MakeFinalFix create(@Nullable KtDeclaration declaration, @NotNull Name name2) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                if (declaration == null) {
                    return null;
                }
                SearchScope useScope = declaration.getUseScope();
                if (DefinitionsScopedSearch.search((PsiElement)declaration, (SearchScope)useScope).findFirst() != null) {
                    return null;
                }
                return new MakeFinalFix((KtModifierListOwner)declaration, name2, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

