/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.conversion.copy.RangeUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SecondaryConstructorInfo;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001a\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0005*\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveUnnecessaryLateinitIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "assignmentReachableFromAnySecondaryConstructor", "", "constructorsInfo", "", "Lorg/jetbrains/kotlin/idea/intentions/SecondaryConstructorInfo;", "hasAssignmentStatements", "body", "Lorg/jetbrains/kotlin/psi/KtExpression;", "property", "lateinitTextRange", "idea"})
public final class RemoveUnnecessaryLateinitIntention
extends SelfTargetingRangeIntention<KtProperty> {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtProperty element2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        boolean bl;
        KtAnonymousInitializer it;
        Object element$iv;
        KtClass ktClass;
        block10: {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            if (!element2.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
                return null;
            }
            Object $receiver$iv2 = element2;
            KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtClass.class, (boolean)true);
            if (ktClass2 == null) {
                return null;
            }
            ktClass = ktClass2;
            $receiver$iv2 = ktClass.getAnonymousInitializers();
            Iterator $i$f$getStrictParentOfType = $receiver$iv2.iterator();
            while ($i$f$getStrictParentOfType.hasNext()) {
                element$iv = $i$f$getStrictParentOfType.next();
                it = (KtAnonymousInitializer)element$iv;
                if (!this.hasAssignmentStatements(it.getBody(), element2)) continue;
                bl = true;
                break block10;
            }
            bl = false;
        }
        if (bl) {
            return this.lateinitTextRange(element2);
        }
        if (ktClass.hasPrimaryConstructor()) {
            return null;
        }
        List<KtSecondaryConstructor> secondaryConstructors2 = ktClass.getSecondaryConstructors();
        element$iv = secondaryConstructors2;
        it = $receiver$iv;
        Collection $i$a$1$any = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            int n;
            boolean hasAssignmentStatements;
            void var25_20;
            block11: {
                void $receiver$iv3;
                void secondaryConstructor;
                KtSecondaryConstructor ktSecondaryConstructor = (KtSecondaryConstructor)item$iv$iv;
                var25_20 = destination$iv$iv;
                KtConstructorDelegationCall delegationCall = secondaryConstructor.getDelegationCall();
                hasAssignmentStatements = this.hasAssignmentStatements(secondaryConstructor.getBodyExpression(), element2);
                if (!hasAssignmentStatements && !delegationCall.isCallToThis()) {
                    return null;
                }
                if (CallUtilKt.getResolvedCall(delegationCall, ResolutionUtils.analyzeFully(delegationCall)) == null) {
                    return null;
                }
                List<KtSecondaryConstructor> list2 = secondaryConstructors2;
                int index$iv = 0;
                for (Object item$iv : $receiver$iv3) {
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                    KtSecondaryConstructor it2 = (KtSecondaryConstructor)item$iv;
                    if (Intrinsics.areEqual((Object)DescriptorToSourceUtils.descriptorToDeclaration(resolvedCall2.getResultingDescriptor()), (Object)it2)) {
                        n = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int delegationCallIndex = n;
            SecondaryConstructorInfo secondaryConstructorInfo = new SecondaryConstructorInfo(hasAssignmentStatements, delegationCallIndex);
            var25_20.add(secondaryConstructorInfo);
        }
        List secondaryConstructorsInfo = (List)destination$iv$iv;
        return this.assignmentReachableFromAnySecondaryConstructor(secondaryConstructorsInfo) ? this.lateinitTextRange(element2) : (TextRange)null;
    }

    private final boolean assignmentReachableFromAnySecondaryConstructor(List<SecondaryConstructorInfo> constructorsInfo) {
        Iterable $receiver$iv = constructorsInfo;
        for (Object element$iv : $receiver$iv) {
            SecondaryConstructorInfo it = (SecondaryConstructorInfo)element$iv;
            HashSet visitedInfo = SetsKt.hashSetOf((Object[])new SecondaryConstructorInfo[0]);
            SecondaryConstructorInfo currentConstructor = it;
            while (!currentConstructor.getHasAssignmentStatement()) {
                if (!visitedInfo.add(currentConstructor)) {
                    return false;
                }
                if ((SecondaryConstructorInfo)CollectionsKt.getOrNull(constructorsInfo, (int)currentConstructor.getDelegationCallIndex()) != null) continue;
                return false;
            }
        }
        return true;
    }

    private final TextRange lateinitTextRange(@NotNull KtProperty $receiver) {
        KtModifierList ktModifierList = $receiver.getModifierList();
        return ktModifierList != null && (ktModifierList = ktModifierList.getModifier(KtTokens.LATEINIT_KEYWORD)) != null ? RangeUtilsKt.getRange((PsiElement)ktModifierList) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasAssignmentStatements(KtExpression body2, KtProperty property2) {
        PsiElement[] psiElementArray = body2;
        if (body2 == null) return false;
        PsiElement[] psiElementArray2 = psiElementArray.getChildren();
        psiElementArray = psiElementArray2;
        if (psiElementArray2 == null) return false;
        Object[] $receiver$iv = psiElementArray;
        int n = 0;
        while (n < $receiver$iv.length) {
            Object element$iv = $receiver$iv[n];
            PsiElement it = (PsiElement)element$iv;
            if (it instanceof KtBinaryExpression && ((KtBinaryExpression)it).getOperationToken() == KtTokens.EQ) {
                KtExpression ktExpression = ((KtBinaryExpression)it).getLeft();
                if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)property2.getName())) {
                    return true;
                }
            }
            boolean bl = false;
            if (bl) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void applyTo(@NotNull KtProperty element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        element2.removeModifier(KtTokens.LATEINIT_KEYWORD);
    }

    public RemoveUnnecessaryLateinitIntention() {
        super(KtProperty.class, "Remove unnecessary lateinit", null, 4, null);
    }
}

