/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddInlineModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "element", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "findParameterWithName", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Lorg/jetbrains/kotlin/psi/KtElement;", "name", "CrossInlineFactory", "NoInlineFactory", "idea"})
public final class AddInlineModifierFix
extends KotlinQuickFixAction<KtNameReferenceExpression> {
    private final KtModifierKeywordToken modifier;

    @NotNull
    public String getText() {
        return "Add '" + this.modifier.getValue() + "' to parameter '" + ((KtNameReferenceExpression)this.getElement()).getReferencedName() + "'";
    }

    @NotNull
    public String getFamilyName() {
        return "Add '" + this.modifier.getValue() + "' to parameter";
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        KtParameter ktParameter = this.findParameterWithName((KtElement)this.getElement(), ((KtNameReferenceExpression)this.getElement()).getReferencedName());
        if (ktParameter == null) {
            return;
        }
        KtParameter parameter = ktParameter;
        if (!parameter.hasModifier(this.modifier)) {
            parameter.addModifier(this.modifier);
        }
    }

    private final KtParameter findParameterWithName(@NotNull KtElement $receiver, String name2) {
        KtParameter ktParameter;
        Object v1;
        KtFunction function2;
        block3: {
            Iterable $receiver$iv;
            PsiElement psiElement = (PsiElement)$receiver;
            KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtFunction.class, (boolean)true);
            if (ktFunction == null) {
                return null;
            }
            function2 = ktFunction;
            $receiver$iv = function2.getValueParameters();
            for (Object element$iv : $receiver$iv) {
                KtParameter it = (KtParameter)element$iv;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        if ((ktParameter = (KtParameter)v1) == null) {
            ktParameter = this.findParameterWithName(function2, name2);
        }
        return ktParameter;
    }

    public AddInlineModifierFix(@NotNull KtNameReferenceExpression element2, @NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)((Object)modifier), (String)"modifier");
        super((PsiElement)element2);
        this.modifier = modifier;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddInlineModifierFix$CrossInlineFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class CrossInlineFactory
    extends KotlinIntentionActionsFactory {
        public static final CrossInlineFactory INSTANCE;

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters1 casted = (DiagnosticWithParameters1)Errors.NON_LOCAL_RETURN_NOT_ALLOWED.cast(diagnostic);
            Object a = casted.getA();
            if (!(a instanceof KtNameReferenceExpression)) {
                a = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)a;
            if (ktNameReferenceExpression == null) {
                return CollectionsKt.emptyList();
            }
            KtNameReferenceExpression reference2 = ktNameReferenceExpression;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.CROSSINLINE_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.CROSSINLINE_KEYWORD");
            return CollectionsKt.listOf((Object)new AddInlineModifierFix(reference2, ktModifierKeywordToken));
        }

        private CrossInlineFactory() {
            INSTANCE = this;
        }

        static {
            new CrossInlineFactory();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddInlineModifierFix$NoInlineFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class NoInlineFactory
    extends KotlinIntentionActionsFactory {
        public static final NoInlineFactory INSTANCE;

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticWithParameters2 casted = (DiagnosticWithParameters2)Errors.USAGE_IS_NOT_INLINABLE.cast(diagnostic);
            Object a = casted.getA();
            if (!(a instanceof KtNameReferenceExpression)) {
                a = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)a;
            if (ktNameReferenceExpression == null) {
                return CollectionsKt.emptyList();
            }
            KtNameReferenceExpression reference2 = ktNameReferenceExpression;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.NOINLINE_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.NOINLINE_KEYWORD");
            return CollectionsKt.listOf((Object)new AddInlineModifierFix(reference2, ktModifierKeywordToken));
        }

        private NoInlineFactory() {
            INSTANCE = this;
        }

        static {
            new NoInlineFactory();
        }
    }
}

