/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.shorten.ShortenWaitingSetKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValDialog;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValHandler;
import org.jetbrains.kotlin.idea.refactoring.move.ContainerChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.move.ContainerInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilsKt;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CopyableUserDataProperty;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtLambdaArgumentKt;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 02\u00020\u0001:\u000201B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\tH\u0002J(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0002J\"\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J0\u0010\"\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010#\u001a\u00020\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0%H\u0002J\"\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0002J\"\u0010.\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010/\u001a\u00020\u0006H\u0002\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler;", "Lcom/intellij/lang/refactoring/InlineActionHandler;", "()V", "addFunctionLiteralParameterTypes", "", "parameters", "", "inlinedExpressions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "canInlineElement", "", "element", "Lcom/intellij/psi/PsiElement;", "doReplace", "expression", "replacement", "getParametersForFunctionLiteral", "initializer", "highlightExpressions", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "elements", "inlineElement", "isEnabledForLanguage", "l", "Lcom/intellij/lang/Language;", "needToAddParameterTypes", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "reportAmbiguousAssignment", "name", "assignments", "", "showDialog", "Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler$InlineMode;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "ref", "Lcom/intellij/psi/PsiReference;", "occurrenceCount", "", "showErrorHint", "message", "Companion", "InlineMode", "idea"})
public final class KotlinInlineValHandler
extends InlineActionHandler {
    private static final CopyableUserDataProperty internalUsageInfos$delegate;
    public static final Companion Companion;

    public boolean isEnabledForLanguage(@NotNull Language l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        return Intrinsics.areEqual((Object)l, (Object)((Object)KotlinLanguage.INSTANCE));
    }

    public boolean canInlineElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!(element2 instanceof KtProperty)) {
            return false;
        }
        return ((KtProperty)element2).getGetter() == null && ((KtProperty)element2).getReceiverTypeReference() == null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtExpression> doReplace(KtExpression expression2, KtExpression replacement) {
        Object object;
        void $receiver$iv;
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtStringTemplateEntryWithExpression && replacement instanceof KtStringTemplateExpression && Intrinsics.areEqual((Object)((KtStringTemplateEntryWithExpression)parent2).getParent().getFirstChild().getText(), (Object)((KtStringTemplateExpression)replacement).getFirstChild().getText())) {
            List list2;
            KtStringTemplateEntry[] entriesToAdd = ((KtStringTemplateExpression)replacement).getEntries();
            PsiElement psiElement = ((KtStringTemplateEntryWithExpression)parent2).getParent();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtStringTemplateExpression");
            }
            KtStringTemplateExpression templateExpression2 = (KtStringTemplateExpression)psiElement;
            if (((Object[])entriesToAdd).length > 0) {
                PsiElement firstAddedEntry = templateExpression2.addRangeBefore((PsiElement)ArraysKt.first((Object[])entriesToAdd), (PsiElement)ArraysKt.last((Object[])entriesToAdd), parent2);
                PsiElement lastNewEntry = ((KtStringTemplateEntryWithExpression)parent2).getPrevSibling();
                PsiElement nextElement = ((KtStringTemplateEntryWithExpression)parent2).getNextSibling();
                if (lastNewEntry instanceof KtSimpleNameStringTemplateEntry && ((KtSimpleNameStringTemplateEntry)lastNewEntry).getExpression() != null && !KtPsiUtilKt.canPlaceAfterSimpleNameEntry(nextElement)) {
                    KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)expression2);
                    KtExpression ktExpression = ((KtSimpleNameStringTemplateEntry)lastNewEntry).getExpression();
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"lastNewEntry.expression!!");
                    lastNewEntry.replace((PsiElement)ktPsiFactory.createBlockStringTemplateEntry(ktExpression));
                }
                list2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.take((Sequence)PsiUtilsKt.siblings$default(firstAddedEntry, false, false, 3, null), (int)((Object[])entriesToAdd).length), (Function1)doReplace.inlinedExpressions.1.INSTANCE));
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List inlinedExpressions2 = list2;
            parent2.delete();
            return inlinedExpressions2;
        }
        PsiElement entriesToAdd = (PsiElement)expression2;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)replacement);
        if (result$iv instanceof KtExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement = result$iv;
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression = ((KtParenthesizedExpression)psiElement).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            object = ktExpression;
        }
        return AddToStdlibKt.singletonList(object);
    }

    /*
     * WARNING - void declaration
     */
    public void inlineElement(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Object targetPackage2;
        KtExpression it;
        MultiMap multiMap;
        Iterable destination$iv$iv;
        Object it2;
        Collection $receiver$iv$iv;
        void $receiver$iv;
        KtExpression initializer2;
        KtExpression ktExpression;
        Object assignment;
        void $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
        }
        KtProperty declaration = (KtProperty)psiElement;
        KtFile file2 = declaration.getContainingKtFile();
        String string = declaration.getName();
        if (string == null) {
            return;
        }
        String name2 = string;
        Query references2 = ReferencesSearch.search((PsiElement)declaration);
        ArrayList referenceExpressions = new ArrayList();
        ArrayList<Object> foreignUsages = new ArrayList<Object>();
        for (PsiReference ref : references2) {
            Object refElement;
            if (ref.getElement() == null) {
                continue;
            }
            if (!(refElement instanceof KtElement)) {
                foreignUsages.add(refElement);
                continue;
            }
            Collection collection = referenceExpressions;
            Object object = refElement;
            if (!(object instanceof KtExpression)) {
                object = null;
            }
            KtExpression ktExpression2 = (KtExpression)object;
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(collection, ktExpression2 != null ? KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis(ktExpression2) : null);
        }
        if (referenceExpressions.isEmpty()) {
            String kind2 = declaration.isLocal() ? "Variable" : "Property";
            this.showErrorHint(project, editor, kind2 + " '" + name2 + "' is never used");
            return;
        }
        HashSet assignments = Sets.newHashSet();
        Iterable iterable = referenceExpressions;
        for (Object element$iv : $receiver$iv2) {
            KtExpression expression2 = (KtExpression)element$iv;
            PsiElement parent2 = expression2.getParent();
            assignment = KtPsiUtilKt.getAssignmentByLHS(expression2);
            if (assignment != null) {
                assignments.add(parent2);
            }
            if (!(parent2 instanceof KtUnaryExpression) || !CollectionsKt.contains((Iterable)((Iterable)OperatorConventions.INCREMENT_OPERATIONS), (Object)((KtUnaryExpression)parent2).getOperationToken())) continue;
            assignments.add(parent2);
        }
        KtExpression initializerInDeclaration = declaration.getInitializer();
        if (initializerInDeclaration != null) {
            if (!assignments.isEmpty()) {
                String string2 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                Set set = assignments;
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"assignments");
                this.reportAmbiguousAssignment(project, editor, string2, set);
                return;
            }
            ktExpression = initializerInDeclaration;
        } else {
            Object object = CollectionsKt.singleOrNull((Iterable)assignments);
            if (!(object instanceof KtBinaryExpression)) {
                object = null;
            }
            if ((ktExpression = (KtBinaryExpression)object) == null || (ktExpression = ((KtBinaryExpression)ktExpression).getRight()) == null) {
                String string3 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                Set set = assignments;
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"assignments");
                this.reportAmbiguousAssignment(project, editor, string3, set);
                return;
            }
        }
        KtExpression ktExpression3 = initializer2 = ktExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"initializer");
        KtTypeArgumentList typeArgumentsForCall = KotlinRefactoringUtilKt.getQualifiedTypeArgumentList(ktExpression3);
        KtExpression ktExpression4 = initializer2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"initializer");
        String parametersForFunctionLiteral = this.getParametersForFunctionLiteral(ktExpression4);
        assignment = referenceExpressions;
        void $i$a$1$forEach = $receiver$iv;
        Collection $i$f$forEach = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it2 = (KtExpression)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it2.getContainingFile(), (Object)file2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List referencesInOriginalFile = (List)destination$iv$iv;
        $receiver$iv$iv = referencesInOriginalFile;
        boolean isHighlighting = !$receiver$iv$iv.isEmpty();
        this.highlightExpressions(project, editor, referencesInOriginalFile);
        if (referencesInOriginalFile.size() != referenceExpressions.size()) {
            void destination$iv;
            void $receiver$iv$iv2;
            void $receiver$iv3;
            Object element$iv$iv;
            destination$iv$iv = referenceExpressions;
            multiMap = new LinkedHashSet();
            element$iv$iv = $receiver$iv3;
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                FqName fqName2;
                Object element$iv = element$iv$iv2;
                it = (KtExpression)element$iv;
                PsiFile psiFile = it.getContainingFile();
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                KtFile ktFile = (KtFile)psiFile;
                if ((ktFile != null ? ktFile.getPackageFqName() : null) == null) continue;
                fqName2 = fqName2;
                FqName it$iv = fqName2;
                destination$iv.add(it$iv);
            }
            LinkedHashSet targetPackages = (LinkedHashSet)destination$iv;
            for (Object targetPackage2 : targetPackages) {
                if (Intrinsics.areEqual((Object)targetPackage2, (Object)file2.getPackageFqName())) continue;
                FqName fqName3 = file2.getPackageFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"file.packageFqName");
                ContainerInfo containerInfo = new ContainerInfo.Package(fqName3);
                Object object = targetPackage2;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"targetPackage");
                ContainerChangeInfo packageNameInfo = new ContainerChangeInfo(containerInfo, new ContainerInfo.Package((FqName)object));
                MoveUtilsKt.lazilyProcessInternalReferencesToUpdateOnPackageNameChange(initializer2, packageNameInfo, (Function2<? super KtSimpleNameExpression, ? super Function1<? super KtSimpleNameExpression, ? extends UsageInfo>, Unit>)((Function2)new Function2<KtSimpleNameExpression, Function1<? super KtSimpleNameExpression, ? extends UsageInfo>, Unit>((FqName)targetPackage2){
                    final /* synthetic */ FqName $targetPackage;

                    public final void invoke(@NotNull KtSimpleNameExpression expr, @NotNull Function1<? super KtSimpleNameExpression, ? extends UsageInfo> factory2) {
                        LinkedHashMap<FqName, Function1<? super KtSimpleNameExpression, ? extends UsageInfo>> infos;
                        LinkedHashMap<FqName, Function1<? super KtSimpleNameExpression, ? extends UsageInfo>> linkedHashMap;
                        Intrinsics.checkParameterIsNotNull((Object)expr, (String)"expr");
                        Intrinsics.checkParameterIsNotNull(factory2, (String)"factory");
                        Map<FqName, Object> map2 = org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValHandler$Companion.access$getInternalUsageInfos$p(KotlinInlineValHandler.Companion, expr);
                        if (map2 == null) {
                            linkedHashMap = new LinkedHashMap<FqName, Function1<? super KtSimpleNameExpression, ? extends UsageInfo>>();
                            LinkedHashMap<FqName, Function1<? super KtSimpleNameExpression, ? extends UsageInfo>> $receiver = linkedHashMap;
                            org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValHandler$Companion.access$setInternalUsageInfos$p(KotlinInlineValHandler.Companion, expr, $receiver);
                            map2 = linkedHashMap;
                        }
                        linkedHashMap = infos = map2;
                        FqName fqName2 = this.$targetPackage;
                        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"targetPackage");
                        FqName fqName3 = fqName2;
                        Function1<? super KtSimpleNameExpression, ? extends UsageInfo> function1 = factory2;
                        linkedHashMap.put(fqName3, function1);
                    }
                    {
                        this.$targetPackage = fqName2;
                        super(2);
                    }
                }));
            }
        }
        Function0<Unit> performRefactoring$ = new Function0<Unit>(this, editor, referenceExpressions, declaration, isHighlighting, project, name2, assignments, initializer2, typeArgumentsForCall, parametersForFunctionLiteral){
            final /* synthetic */ KotlinInlineValHandler this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ ArrayList $referenceExpressions;
            final /* synthetic */ KtProperty $declaration;
            final /* synthetic */ boolean $isHighlighting;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $name;
            final /* synthetic */ HashSet $assignments;
            final /* synthetic */ KtExpression $initializer;
            final /* synthetic */ KtTypeArgumentList $typeArgumentsForCall;
            final /* synthetic */ String $parametersForFunctionLiteral;

            public final void invoke() {
                KtExpression primaryExpression;
                KtExpression ktExpression;
                if (this.$editor != null) {
                    Object v0;
                    block6: {
                        int offset2 = this.$editor.getCaretModel().getOffset();
                        Iterable $receiver$iv = this.$referenceExpressions;
                        for (T element$iv : $receiver$iv) {
                            KtExpression it = (KtExpression)element$iv;
                            if (!it.getTextRange().contains(offset2)) continue;
                            v0 = element$iv;
                            break block6;
                        }
                        v0 = null;
                    }
                    ktExpression = v0;
                } else {
                    ktExpression = null;
                }
                KtExpression ktExpression2 = primaryExpression = ktExpression;
                KtReference primaryRef = ktExpression2 != null ? ReferenceUtilKt.getMainReference(ktExpression2) : null;
                InlineMode inlineMode = KotlinInlineValHandler.access$showDialog(this.this$0, this.$declaration, (PsiReference)primaryRef, this.$referenceExpressions.size());
                if (Intrinsics.areEqual((Object)((Object)inlineMode), (Object)((Object)InlineMode.NONE))) {
                    if (this.$isHighlighting) {
                        StatusBar statusBar;
                        StatusBar statusBar2 = statusBar = WindowManager.getInstance().getStatusBar(this.$project);
                        if (statusBar2 != null) {
                            statusBar2.setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                        }
                    }
                    return;
                }
                List chosenExpressions = Intrinsics.areEqual((Object)((Object)inlineMode), (Object)((Object)InlineMode.ALL)) ? (List)this.$referenceExpressions : CollectionsKt.listOf((Object)primaryExpression);
                String string = RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{this.$name});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RefactoringBundle.message(\"inline.command\", name)");
                ApplicationUtilsKt.executeWriteCommand(this.$project, string, (Function0<Unit>)((Function0)new Function0<Unit>(this, chosenExpressions, inlineMode){
                    final /* synthetic */ inlineElement.3 this$0;
                    final /* synthetic */ List $chosenExpressions;
                    final /* synthetic */ InlineMode $inlineMode;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        Object it;
                        void $receiver$iv$iv$iv;
                        Collection destination$iv$iv;
                        Iterable list$iv$iv;
                        Object element$iv$iv;
                        Iterator<T> $receiver$iv$iv;
                        Iterable $receiver$iv = this.$chosenExpressions;
                        Iterable iterable = $receiver$iv;
                        Collection collection = new ArrayList<E>();
                        Object object = $receiver$iv$iv.iterator();
                        while (object.hasNext()) {
                            List list2;
                            element$iv$iv = object.next();
                            KtExpression referenceExpression = (KtExpression)element$iv$iv;
                            HashSet hashSet = this.this$0.$assignments;
                            KtExpression ktExpression = referenceExpression;
                            if (ktExpression == null) {
                                Intrinsics.throwNpe();
                            }
                            if (hashSet.contains(ktExpression.getParent())) {
                                list2 = CollectionsKt.emptyList();
                            } else {
                                void $receiver$iv2;
                                PsiElement psiElement = (PsiElement)referenceExpression;
                                KtImportDirective importDirective = (KtImportDirective)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtImportDirective.class, (boolean)true);
                                if (importDirective != null) {
                                    KtReference reference2;
                                    KtElement ktElement = KtPsiUtilKt.getQualifiedElementSelector(referenceExpression);
                                    KtReference ktReference = reference2 = ktElement != null ? ReferenceUtilKt.getMainReference(ktElement) : null;
                                    if (reference2 != null && ((Object[])reference2.multiResolve(false)).length <= 1) {
                                        importDirective.delete();
                                    }
                                    list2 = CollectionsKt.emptyList();
                                } else {
                                    KotlinInlineValHandler kotlinInlineValHandler = this.this$0.this$0;
                                    KtExpression ktExpression2 = this.this$0.$initializer;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"initializer");
                                    list2 = KotlinInlineValHandler.access$doReplace(kotlinInlineValHandler, referenceExpression, ktExpression2);
                                }
                            }
                            list$iv$iv = list2;
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        $receiver$iv = (List)destination$iv$iv;
                        $receiver$iv$iv = $receiver$iv;
                        destination$iv$iv = new ArrayList<E>();
                        object = $receiver$iv$iv;
                        element$iv$iv = $receiver$iv$iv$iv.iterator();
                        while (element$iv$iv.hasNext()) {
                            KtExpression ktExpression;
                            void destination$iv$iv2;
                            Iterable $receiver$iv3;
                            Iterator<T> action$iv$iv$iv;
                            void $receiver$iv$iv$iv2;
                            Iterable predicate$iv;
                            void $receiver$iv$iv2;
                            void $receiver$iv4;
                            E element$iv$iv$iv;
                            E element$iv$iv2 = element$iv$iv$iv = element$iv$iv.next();
                            KtExpression inlinedExpression = (KtExpression)element$iv$iv2;
                            SmartPsiElementPointer<PsiElement> pointer = PsiUtilsKt.createSmartPointer((PsiElement)inlinedExpression);
                            FqName targetPackage = inlinedExpression.getContainingKtFile().getPackageFqName();
                            list$iv$iv = (PsiElement)inlinedExpression;
                            Function1 $i$f$flatMapTo = inlineElement.inlinedExpressions.2.expressionsToProcess.1.INSTANCE;
                            void $i$f$flatMap = $receiver$iv4;
                            Collection<E> result$iv$iv = new ArrayList<E>();
                            void var16_15 = $receiver$iv$iv2;
                            Function1 function1 = (Function1)new Function1<KtSimpleNameExpression, Unit>((Function1)predicate$iv, result$iv$iv){
                                final /* synthetic */ Function1 $predicate;
                                final /* synthetic */ ArrayList $result;

                                /*
                                 * Ignored method signature, as it can't be verified against descriptor
                                 */
                                public final void invoke(PsiElement it) {
                                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                                        this.$result.add(it);
                                    }
                                }
                                {
                                    this.$predicate = function1;
                                    this.$result = arrayList;
                                    super(1);
                                }
                            };
                            $receiver$iv$iv$iv2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((Function1)action$iv$iv$iv){
                                final /* synthetic */ Function1 $action;

                                public void visitElement(PsiElement element2) {
                                    PsiElement it = element2;
                                    if (true) {
                                        super.visitElement(element2);
                                    }
                                    if (element2 instanceof KtSimpleNameExpression) {
                                        this.$action.invoke((Object)element2);
                                    }
                                }
                                {
                                    this.$action = $captured_local_variable$1;
                                }
                            });
                            List expressionsToProcess2 = result$iv$iv;
                            predicate$iv = expressionsToProcess2;
                            $receiver$iv$iv2 = $receiver$iv3;
                            result$iv$iv = new ArrayList<E>();
                            $receiver$iv$iv$iv2 = $receiver$iv$iv2;
                            action$iv$iv$iv = $receiver$iv$iv$iv2.iterator();
                            while (action$iv$iv$iv.hasNext()) {
                                UsageInfo usageInfo;
                                T element$iv$iv$iv2;
                                T element$iv$iv3 = element$iv$iv$iv2 = action$iv$iv$iv.next();
                                KtSimpleNameExpression it2 = (KtSimpleNameExpression)element$iv$iv3;
                                Map map2 = org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValHandler$Companion.access$getInternalUsageInfos$p(KotlinInlineValHandler.Companion, it2);
                                if (map2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                Function1 function12 = (Function1)map2.get(targetPackage);
                                if ((function12 != null ? (UsageInfo)function12.invoke((Object)it2) : null) == null) continue;
                                usageInfo = usageInfo;
                                UsageInfo it$iv$iv = usageInfo;
                                destination$iv$iv2.add(it$iv$iv);
                            }
                            List internalUsages = (List)destination$iv$iv2;
                            $receiver$iv3 = expressionsToProcess2;
                            for (T element$iv : $receiver$iv3) {
                                KtSimpleNameExpression it3 = (KtSimpleNameExpression)element$iv;
                                org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineValHandler$Companion.access$setInternalUsageInfos$p(KotlinInlineValHandler.Companion, it3, null);
                            }
                            MoveUtilsKt.postProcessMoveUsages$default(internalUsages, null, null, 6, null);
                            if ((KtExpression)pointer.getElement() == null) continue;
                            KtExpression it$iv$iv = ktExpression;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List inlinedExpressions2 = (List)destination$iv$iv;
                        if (Intrinsics.areEqual((Object)((Object)this.$inlineMode), (Object)((Object)InlineMode.ALL))) {
                            $receiver$iv = this.this$0.$assignments;
                            for (Object element$iv : $receiver$iv) {
                                it = (PsiElement)element$iv;
                                it.delete();
                            }
                            this.this$0.$declaration.delete();
                        }
                        $receiver$iv = inlinedExpressions2;
                        if (!$receiver$iv.isEmpty()) {
                            if (this.this$0.$typeArgumentsForCall != null) {
                                $receiver$iv = inlinedExpressions2;
                                for (Object element$iv : $receiver$iv) {
                                    Object object2 = it = (KtExpression)element$iv;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
                                    KotlinRefactoringUtilKt.addTypeArgumentsIfNeeded((KtExpression)object2, this.this$0.$typeArgumentsForCall);
                                }
                            }
                            String string = this.this$0.$parametersForFunctionLiteral;
                            if (string != null) {
                                String string2 = string;
                                String it4 = string2;
                                KotlinInlineValHandler.access$addFunctionLiteralParameterTypes(this.this$0.this$0, it4, inlinedExpressions2);
                            }
                            if (this.this$0.$isHighlighting) {
                                KotlinInlineValHandler.access$highlightExpressions(this.this$0.this$0, this.this$0.$project, this.this$0.$editor, inlinedExpressions2);
                            }
                        }
                        ShortenWaitingSetKt.performDelayedShortening(this.this$0.$project);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$chosenExpressions = list2;
                        this.$inlineMode = inlineMode;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = kotlinInlineValHandler;
                this.$editor = editor;
                this.$referenceExpressions = arrayList;
                this.$declaration = ktProperty;
                this.$isHighlighting = bl;
                this.$project = project;
                this.$name = string;
                this.$assignments = hashSet;
                this.$initializer = ktExpression;
                this.$typeArgumentsForCall = ktTypeArgumentList;
                this.$parametersForFunctionLiteral = string2;
                super(0);
            }
        };
        targetPackage2 = foreignUsages;
        if (!targetPackage2.isEmpty()) {
            void $receiver$iv4;
            multiMap = new MultiMap();
            MultiMap $receiver = multiMap;
            $receiver.putValue(null, (Object)("Property '" + name2 + "' has non-Kotlin usages. They won't be processed by the Inline refactoring."));
            it2 = foreignUsages;
            for (Object element$iv : $receiver$iv4) {
                it = (PsiElement)element$iv;
                $receiver.putValue((Object)it, (Object)it.getText());
            }
            MultiMap conflicts2 = multiMap;
            KotlinRefactoringUtilKt.checkConflictsInteractively$default(project, conflicts2, null, (Function0)new Function0<Unit>(performRefactoring$){
                final /* synthetic */ inlineElement.3 $performRefactoring;

                public final void invoke() {
                    this.$performRefactoring.invoke();
                }
                {
                    this.$performRefactoring = var1_1;
                    super(0);
                }
            }, 2, null);
        } else {
            performRefactoring$.invoke();
        }
    }

    private final void reportAmbiguousAssignment(Project project, Editor editor, String name2, Set<? extends PsiElement> assignments) {
        String message2;
        String key = assignments.isEmpty() ? "variable.has.no.initializer" : "variable.has.no.dominating.definition";
        String string = message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key, (Object[])new Object[]{name2}));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
        this.showErrorHint(project, editor, string);
    }

    private final void showErrorHint(Project project, Editor editor, String message2) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)RefactoringBundle.message((String)"inline.variable.title"), (String)"refactoring.inlineVariable");
    }

    /*
     * WARNING - void declaration
     */
    private final void highlightExpressions(Project project, Editor editor, List<? extends PsiElement> elements) {
        void $receiver$iv;
        if (editor == null || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        TextAttributes searchResultsAttributes = editorColorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        Collection collection = elements;
        Editor editor2 = editor;
        HighlightManager highlightManager2 = highlightManager;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = (Collection)v0;
        PsiElement[] psiElementArray = thisCollection$iv.toArray(new PsiElement[thisCollection$iv.size()]);
        if (psiElementArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = psiElementArray;
        highlightManager2.addOccurrenceHighlights(editor2, (PsiElement[])objectArray, searchResultsAttributes, true, (Collection)null);
    }

    private final InlineMode showDialog(KtProperty property2, PsiReference ref, int occurrenceCount) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return InlineMode.ALL;
        }
        if (!(ref != null && occurrenceCount > 1 || EditorSettingsExternalizable.getInstance().isShowInlineLocalDialog())) {
            return InlineMode.ALL;
        }
        KotlinInlineValDialog dialog2 = new KotlinInlineValDialog(property2, ref, occurrenceCount);
        if (!dialog2.showAndGet()) {
            return InlineMode.NONE;
        }
        return JavaRefactoringSettings.getInstance().INLINE_LOCAL_THIS ? InlineMode.PRIMARY : InlineMode.ALL;
    }

    private final String getParametersForFunctionLiteral(KtExpression initializer2) {
        KtLambdaExpression ktLambdaExpression = KtLambdaArgumentKt.unpackFunctionLiteral(initializer2, true);
        if (ktLambdaExpression == null) {
            return null;
        }
        KtLambdaExpression functionLiteralExpression = ktLambdaExpression;
        BindingContext context = ResolutionUtils.analyze(initializer2, BodyResolveMode.PARTIAL);
        SimpleFunctionDescriptor lambdaDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, functionLiteralExpression.getFunctionLiteral());
        if (lambdaDescriptor == null || ErrorUtils.containsErrorType(lambdaDescriptor)) {
            return null;
        }
        return CollectionsKt.joinToString$default((Iterable)lambdaDescriptor.getValueParameters(), null, null, null, (int)0, null, (Function1)getParametersForFunctionLiteral.1.INSTANCE, (int)31, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void addFunctionLiteralParameterTypes(String parameters2, List<? extends KtExpression> inlinedExpressions2) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        KtFile containingFile = ((KtExpression)CollectionsKt.first(inlinedExpressions2)).getContainingKtFile();
        ResolutionFacade resolutionFacade2 = ResolutionUtils.getResolutionFacade(containingFile);
        Iterable iterable = inlinedExpressions2;
        void var7_6 = $receiver$iv;
        Collection collection = new ArrayList();
        void var9_8 = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtLambdaExpression ktLambdaExpression;
            void $receiver$iv2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            KtExpression it = (KtExpression)element$iv$iv;
            KtLambdaExpression ktLambdaExpression2 = KtLambdaArgumentKt.unpackFunctionLiteral(it, true);
            void v0 = $receiver$iv2;
            if (v0 == null) {
                AssertionError assertionError;
                AssertionError assertionError2 = assertionError;
                AssertionError assertionError3 = assertionError;
                String string = "can't find function literal expression for " + it.getText();
                assertionError2((Object)string);
                throw (Throwable)((Object)assertionError3);
            }
            KtLambdaExpression lambdaExpr = (KtLambdaExpression)v0;
            if ((this.needToAddParameterTypes(lambdaExpr, resolutionFacade2) ? lambdaExpr : (KtLambdaExpression)null) == null) continue;
            ktLambdaExpression = ktLambdaExpression;
            KtLambdaExpression it$iv$iv = ktLambdaExpression;
            destination$iv$iv.add(it$iv$iv);
        }
        List functionsToAddParameters = (List)destination$iv$iv;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)containingFile);
        for (KtLambdaExpression lambdaExpr : functionsToAddParameters) {
            KtFunctionLiteral lambda2 = lambdaExpr.getFunctionLiteral();
            KtParameterList currentParameterList = lambda2.getValueParameterList();
            KtParameterList newParameterList = psiFactory.createParameterList("(" + parameters2 + ")");
            if (currentParameterList != null) {
                currentParameterList.replace((PsiElement)newParameterList);
            } else {
                PsiElement openBraceElement = lambda2.getLBrace();
                PsiElement nextSibling = openBraceElement.getNextSibling();
                PsiElement whitespaceToAdd = nextSibling instanceof PsiWhiteSpace && StringsKt.contains$default((CharSequence)((PsiWhiteSpace)nextSibling).getText(), (CharSequence)"\n", (boolean)false, (int)2, null) ? nextSibling.copy() : (PsiElement)null;
                Pair<PsiElement, PsiElement> whitespaceAndArrow = psiFactory.createWhitespaceAndArrow();
                lambda2.addRangeAfter((PsiElement)whitespaceAndArrow.getFirst(), (PsiElement)whitespaceAndArrow.getSecond(), openBraceElement);
                lambda2.addAfter((PsiElement)newParameterList, openBraceElement);
                if (whitespaceToAdd != null) {
                    lambda2.addAfter(whitespaceToAdd, openBraceElement);
                }
            }
            Iterable iterable2 = lambdaExpr.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"lambdaExpr.valueParameters");
            ShortenReferences.process$default(ShortenReferences.DEFAULT, iterable2, null, 2, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean needToAddParameterTypes(KtLambdaExpression lambdaExpression, ResolutionFacade resolutionFacade) {
        block3: {
            functionLiteral = lambdaExpression.getFunctionLiteral();
            context = resolutionFacade.analyze(lambdaExpression, BodyResolveMode.PARTIAL);
            var5_5 = context.getDiagnostics();
            for (T element$iv : $receiver$iv) {
                diagnostic = (Diagnostic)element$iv;
                factory = diagnostic.getFactory();
                element = diagnostic.getPsiElement();
                v0 = hasCantInferParameter = Intrinsics.areEqual(factory, Errors.CANNOT_INFER_PARAMETER_TYPE) != false && Intrinsics.areEqual((Object)element.getParent().getParent(), (Object)functionLiteral) != false;
                if (!Intrinsics.areEqual(factory, Errors.UNRESOLVED_REFERENCE) || !Intrinsics.areEqual((Object)element.getText(), (Object)"it")) ** GOTO lbl-1000
                var12_12 = element;
                if (Intrinsics.areEqual((Object)((KtFunctionLiteral)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtFunctionLiteral.class, (boolean)true)), (Object)functionLiteral)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = hasUnresolvedItOrThis = false;
                }
                if (!(hasCantInferParameter != false || hasUnresolvedItOrThis != false)) continue;
                v2 = true;
                break block3;
            }
            v2 = false;
        }
        return v2;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"INTERNAL_USAGE_INFOS");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"INTERNAL_USAGE_INFOS\")");
        internalUsageInfos$delegate = new CopyableUserDataProperty(key);
    }

    @NotNull
    public static final /* synthetic */ InlineMode access$showDialog(KotlinInlineValHandler $this, @NotNull KtProperty property2, @Nullable PsiReference ref, int occurrenceCount) {
        return $this.showDialog(property2, ref, occurrenceCount);
    }

    @NotNull
    public static final /* synthetic */ List access$doReplace(KotlinInlineValHandler $this, @NotNull KtExpression expression2, @NotNull KtExpression replacement) {
        return $this.doReplace(expression2, replacement);
    }

    public static final /* synthetic */ void access$addFunctionLiteralParameterTypes(KotlinInlineValHandler $this, @NotNull String parameters2, @NotNull List inlinedExpressions2) {
        $this.addFunctionLiteralParameterTypes(parameters2, inlinedExpressions2);
    }

    public static final /* synthetic */ void access$highlightExpressions(KotlinInlineValHandler $this, @NotNull Project project, @Nullable Editor editor, @NotNull List elements) {
        $this.highlightExpressions(project, editor, elements);
    }

    public static final /* synthetic */ void access$setInternalUsageInfos$cp(@NotNull CopyableUserDataProperty copyableUserDataProperty) {
        internalUsageInfos$delegate = copyableUserDataProperty;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler$InlineMode;", "", "(Ljava/lang/String;I)V", "ALL", "PRIMARY", "NONE", "idea"})
    public static final class InlineMode
    extends Enum<InlineMode> {
        public static final /* enum */ InlineMode ALL;
        public static final /* enum */ InlineMode PRIMARY;
        public static final /* enum */ InlineMode NONE;
        private static final /* synthetic */ InlineMode[] $VALUES;

        static {
            InlineMode[] inlineModeArray = new InlineMode[3];
            InlineMode[] inlineModeArray2 = inlineModeArray;
            inlineModeArray[0] = ALL = new InlineMode();
            inlineModeArray[1] = PRIMARY = new InlineMode();
            inlineModeArray[2] = NONE = new InlineMode();
            $VALUES = inlineModeArray;
        }

        public static InlineMode[] values() {
            return (InlineMode[])$VALUES.clone();
        }

        public static InlineMode valueOf(String string) {
            return Enum.valueOf(InlineMode.class, string);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Rf\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u0018\u00010\u0004*\u00020\u00072\"\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u0018\u00010\u00048B@BX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler$Companion;", "", "()V", "<set-?>", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "Lcom/intellij/usageView/UsageInfo;", "internalUsageInfos", "getInternalUsageInfos", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)Ljava/util/Map;", "setInternalUsageInfos", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Ljava/util/Map;)V", "internalUsageInfos$delegate", "Lorg/jetbrains/kotlin/psi/CopyableUserDataProperty;", "idea"})
    public static final class Companion {
        private static final /* synthetic */ KProperty[] $$delegatedProperties;

        private final Map<FqName, Function1<KtSimpleNameExpression, UsageInfo>> getInternalUsageInfos(@NotNull KtSimpleNameExpression $receiver) {
            return (Map)internalUsageInfos$delegate.getValue((PsiElement)$receiver, $$delegatedProperties[0]);
        }

        private final void setInternalUsageInfos(@NotNull KtSimpleNameExpression $receiver, Map<FqName, Function1<KtSimpleNameExpression, UsageInfo>> map2) {
            internalUsageInfos$delegate.setValue((PsiElement)$receiver, $$delegatedProperties[0], map2);
        }

        private Companion() {
        }

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty2((MutablePropertyReference2)new MutablePropertyReference2Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "internalUsageInfos", "getInternalUsageInfos(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)Ljava/util/Map;"))};
        }

        @Nullable
        public static final /* synthetic */ Map access$getInternalUsageInfos$p(Companion $this, @NotNull KtSimpleNameExpression $receiver) {
            return $this.getInternalUsageInfos($receiver);
        }

        public static final /* synthetic */ void access$setInternalUsageInfos$p(Companion $this, @NotNull KtSimpleNameExpression $receiver, @Nullable Map map2) {
            $this.setInternalUsageInfos($receiver, map2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

