/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForDeferredFile;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinTopLevelDeclarationsDialog;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveDeclarationToSeparateFileIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "startInWriteAction", "", "idea"})
public final class MoveDeclarationToSeparateFileIntention
extends SelfTargetingRangeIntention<KtClassOrObject>
implements LowPriorityAction {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClassOrObject element2) {
        PsiElement keyword;
        PsiElement psiElement;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2.getName() == null) {
            return null;
        }
        if (!(element2.getParent() instanceof KtFile)) {
            return null;
        }
        if (element2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            return null;
        }
        if (element2.getContainingKtFile().getDeclarations().size() == 1) {
            return null;
        }
        KtClassOrObject ktClassOrObject = element2;
        if (ktClassOrObject instanceof KtClass) {
            psiElement = ((KtClass)element2).getClassOrInterfaceKeyword();
        } else if (ktClassOrObject instanceof KtObjectDeclaration) {
            psiElement = ((KtObjectDeclaration)element2).getObjectKeyword();
        } else {
            return null;
        }
        PsiElement psiElement2 = keyword = psiElement;
        if (psiElement2 == null) {
            return null;
        }
        int startOffset = PsiUtilsKt.getStartOffset(psiElement2);
        PsiElement psiElement3 = element2.getNameIdentifier();
        if (psiElement3 == null) {
            return null;
        }
        int endOffset = PsiUtilsKt.getEndOffset(psiElement3);
        this.setText("Move '" + element2.getName() + "' to separate file");
        return new TextRange(startOffset, endOffset);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtClassOrObject element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (editor == null) {
            throw (Throwable)new IllegalArgumentException("This intention requires an editor");
        }
        KtFile file2 = element2.getContainingKtFile();
        Project project = file2.getProject();
        int originalOffset = editor.getCaretModel().getOffset() - PsiUtilsKt.getStartOffset(element2);
        PsiDirectory psiDirectory = file2.getContainingDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory directory = psiDirectory;
        FqName packageName = file2.getPackageFqName();
        String targetFileName = element2.getName() + ".kt";
        PsiFile targetFile = directory.findFile(targetFileName);
        if (targetFile != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw (Throwable)new CommonRefactoringUtil.RefactoringErrorHintException("File " + targetFileName + " already exists");
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(project, element2, packageName, directory, targetFile){
                final /* synthetic */ Project $project;
                final /* synthetic */ KtClassOrObject $element;
                final /* synthetic */ FqName $packageName;
                final /* synthetic */ PsiDirectory $directory;
                final /* synthetic */ PsiFile $targetFile;

                public final void run() {
                    Set set = SetsKt.setOf((Object)this.$element);
                    String string = this.$packageName.asString();
                    PsiFile psiFile = this.$targetFile;
                    if (!(psiFile instanceof KtFile)) {
                        psiFile = null;
                    }
                    new MoveKotlinTopLevelDeclarationsDialog(this.$project, set, string, this.$directory, (KtFile)psiFile, true, true, true, null).show();
                }
                {
                    this.$project = project;
                    this.$element = ktClassOrObject;
                    this.$packageName = fqName2;
                    this.$directory = psiDirectory;
                    this.$targetFile = psiFile;
                }
            });
            return;
        }
        FqName fqName2 = packageName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageName");
        KotlinMoveTargetForDeferredFile moveTarget2 = new KotlinMoveTargetForDeferredFile(fqName2, directory, null, (Function1<? super KtFile, ? extends KtFile>)((Function1)new Function1<KtFile, KtFile>(targetFileName, directory, packageName){
            final /* synthetic */ String $targetFileName;
            final /* synthetic */ PsiDirectory $directory;
            final /* synthetic */ FqName $packageName;

            @NotNull
            public final KtFile invoke(@NotNull KtFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                PsiDirectory psiDirectory = this.$directory;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"directory");
                return KotlinRefactoringUtilKt.createKotlinFile(this.$targetFileName, psiDirectory, this.$packageName.asString());
            }
            {
                this.$targetFileName = string;
                this.$directory = psiDirectory;
                this.$packageName = fqName2;
                super(1);
            }
        }));
        MoveDeclarationsDescriptor moveOptions2 = new MoveDeclarationsDescriptor(CollectionsKt.listOf((Object)element2), moveTarget2, MoveDeclarationsDelegate.TopLevel.INSTANCE, false, false, true, false, new MoveCallback(directory, targetFileName, project, originalOffset){
            final /* synthetic */ PsiDirectory $directory;
            final /* synthetic */ String $targetFileName;
            final /* synthetic */ Project $project;
            final /* synthetic */ int $originalOffset;

            public final void refactoringCompleted() {
                block1: {
                    PsiFile psiFile = this.$directory.findFile(this.$targetFileName);
                    if (psiFile == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    KtFile newFile = (KtFile)psiFile;
                    KtDeclaration newDeclaration = (KtDeclaration)CollectionsKt.first(newFile.getDeclarations());
                    NavigationUtil.activateFileWithPsiElement((PsiElement)((PsiElement)newFile));
                    Editor editor = FileEditorManager.getInstance((Project)this.$project).getSelectedTextEditor();
                    if (editor == null) break block1;
                    GenerateUtilKt.moveCaret$default(editor, PsiUtilsKt.getStartOffset(newDeclaration) + this.$originalOffset, null, 2, null);
                }
            }
            {
                this.$directory = psiDirectory;
                this.$targetFileName = string;
                this.$project = project;
                this.$originalOffset = n;
            }
        }, false, 320, null);
        Function0 move2 = (Function0)new Function0<Unit>(project, moveOptions2){
            final /* synthetic */ Project $project;
            final /* synthetic */ MoveDeclarationsDescriptor $moveOptions;

            public final void invoke() {
                Project project = this.$project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                new MoveKotlinDeclarationsProcessor(project, this.$moveOptions, null, 4, null).run();
            }
            {
                this.$project = project;
                this.$moveOptions = moveDeclarationsDescriptor;
                super(0);
            }
        };
        Function0 optimizeImports2 = (Function0)new Function0<Unit>(project, file2){
            final /* synthetic */ Project $project;
            final /* synthetic */ KtFile $file;

            public final void invoke() {
                new OptimizeImportsProcessor(this.$project, (PsiFile)this.$file).run();
            }
            {
                this.$project = project;
                this.$file = ktFile;
                super(0);
            }
        };
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        KotlinRefactoringUtilKt.runRefactoringWithPostprocessing((Function0<? extends Object>)move2, project2, MoveKotlinDeclarationsProcessor.Companion.getREFACTORING_ID(), (Function0<Unit>)optimizeImports2);
    }

    public MoveDeclarationToSeparateFileIntention() {
        super(KtClassOrObject.class, "Move declaration to separate file", null, 4, null);
    }
}

