/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.OverloadFilter;
import org.jetbrains.kotlin.resolve.OverloadResolver;
import org.jetbrains.kotlin.resolve.OverloadUtil;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rH\u0002J\u0016\u0010\u0013\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00140\rH\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0004\u0012\u00020\u00140\u001b0\u001a2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00140\rH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J$\u0010#\u001a\u00020\b2\u001a\u0010$\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0004\u0012\u00020\u00140\u001b0\u001aH\u0002J\f\u0010%\u001a\u00020\u001e*\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/resolve/OverloadResolver;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "overloadFilter", "Lorg/jetbrains/kotlin/resolve/OverloadFilter;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/OverloadFilter;)V", "checkOverloads", "", "c", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "checkOverloadsInClass", "members", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "nestedClassConstructors", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "checkOverloadsInPackage", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorNonRoot;", "checkOverloadsInPackages", "findConstructorsInNestedClasses", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "findRedeclarations", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isConstructorsOfDifferentRedeclaredClasses", "", "member1", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "member2", "isTopLevelMainInDifferentFiles", "reportRedeclarations", "redeclarations", "isSynthesized", "frontend"})
public final class OverloadResolver {
    private final BindingTrace trace;
    private final OverloadFilter overloadFilter;

    public final void checkOverloads(@NotNull BodiesResolveContext c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        MultiMap<ClassDescriptor, ConstructorDescriptor> inClasses = this.findConstructorsInNestedClasses(c);
        for (Map.Entry<KtClassOrObject, ClassDescriptorWithResolutionScopes> entry : c.getDeclaredClasses().entrySet()) {
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = entry.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptorWithResolutionScopes, (String)"entry.value");
            Collection collection = inClasses.get((Object)entry.getValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"inClasses.get(entry.value)");
            this.checkOverloadsInClass(classDescriptorWithResolutionScopes, collection);
        }
        this.checkOverloadsInPackages(c);
    }

    private final MultiMap<ClassDescriptor, ConstructorDescriptor> findConstructorsInNestedClasses(BodiesResolveContext c) {
        MultiMap constructorsInNestedClasses = MultiMap.create();
        for (ClassDescriptorWithResolutionScopes klass2 : c.getDeclaredClasses().values()) {
            DeclarationDescriptor containingDeclaration;
            if (klass2.getKind().isSingleton() || klass2.getName().isSpecial() || (containingDeclaration = klass2.getContainingDeclaration()) instanceof ScriptDescriptor) continue;
            if (containingDeclaration instanceof ClassDescriptor) {
                constructorsInNestedClasses.putValues((Object)containingDeclaration, klass2.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof FunctionDescriptor || containingDeclaration instanceof PropertyDescriptor || containingDeclaration instanceof PackageFragmentDescriptor) continue;
            throw (Throwable)new IllegalStateException("Illegal class container: " + containingDeclaration);
        }
        MultiMap multiMap = constructorsInNestedClasses;
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"constructorsInNestedClasses");
        return multiMap;
    }

    private final void checkOverloadsInPackages(BodiesResolveContext c) {
        MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> membersByName = OverloadUtil.groupModulePackageMembersByFqName(c, this.overloadFilter);
        for (Map.Entry e : membersByName.entrySet()) {
            Collection collection = (Collection)e.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"e.value");
            this.checkOverloadsInPackage(collection);
        }
    }

    private final void checkOverloadsInClass(ClassDescriptorWithResolutionScopes classDescriptor, Collection<? extends ConstructorDescriptor> nestedClassConstructors) {
        MultiMap functionsByName = MultiMap.create();
        for (CallableMemberDescriptor callableMemberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            functionsByName.putValue((Object)callableMemberDescriptor.getName(), (Object)callableMemberDescriptor);
        }
        for (ConstructorDescriptor constructorDescriptor : nestedClassConstructors) {
            functionsByName.putValue((Object)constructorDescriptor.getContainingDeclaration().getName(), (Object)constructorDescriptor);
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"e.value");
            this.checkOverloadsInClass(collection);
        }
    }

    private final void checkOverloadsInPackage(Collection<? extends DeclarationDescriptorNonRoot> members) {
        if (members.size() == 1) {
            return;
        }
        for (Collection<DeclarationDescriptorNonRoot> redeclarationGroup : OverloadUtil.getPossibleRedeclarationGroups(members)) {
            this.reportRedeclarations(this.findRedeclarations(redeclarationGroup));
        }
    }

    private final void checkOverloadsInClass(Collection<? extends CallableMemberDescriptor> members) {
        if (members.size() == 1) {
            return;
        }
        this.reportRedeclarations(this.findRedeclarations(members));
    }

    private final boolean isSynthesized(@NotNull DeclarationDescriptor $receiver) {
        return $receiver instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)((Object)((CallableMemberDescriptor)$receiver).getKind()), (Object)((Object)CallableMemberDescriptor.Kind.SYNTHESIZED));
    }

    private final Set<Pair<KtDeclaration, DeclarationDescriptorNonRoot>> findRedeclarations(Collection<? extends DeclarationDescriptorNonRoot> members) {
        LinkedHashSet redeclarations = SetsKt.linkedSetOf((Object[])new Pair[0]);
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : members) {
            if (this.isSynthesized(declarationDescriptorNonRoot)) continue;
            for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot2 : members) {
                if (Intrinsics.areEqual((Object)declarationDescriptorNonRoot, (Object)declarationDescriptorNonRoot2) || this.isConstructorsOfDifferentRedeclaredClasses(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isTopLevelMainInDifferentFiles(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || OverloadUtil.isOverloadable(declarationDescriptorNonRoot, declarationDescriptorNonRoot2)) continue;
                KtDeclaration ktDeclaration = (KtDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptorNonRoot);
                redeclarations.add(TuplesKt.to((Object)ktDeclaration, (Object)declarationDescriptorNonRoot));
            }
        }
        return redeclarations;
    }

    private final boolean isConstructorsOfDifferentRedeclaredClasses(DeclarationDescriptor member1, DeclarationDescriptor member2) {
        ClassDescriptor parent2;
        if (!(member1 instanceof ConstructorDescriptor) || !(member2 instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassDescriptor parent1 = ((ConstructorDescriptor)member1).getContainingDeclaration();
        return parent1 != (parent2 = ((ConstructorDescriptor)member2).getContainingDeclaration()) && Intrinsics.areEqual((Object)parent1.getContainingDeclaration(), (Object)parent2.getContainingDeclaration());
    }

    private final boolean isTopLevelMainInDifferentFiles(DeclarationDescriptor member1, DeclarationDescriptor member2) {
        if (!MainFunctionDetector.Companion.isMain(member1) || !MainFunctionDetector.Companion.isMain(member2)) {
            return false;
        }
        KtFile file1 = DescriptorToSourceUtils.getContainingFile(member1);
        KtFile file2 = DescriptorToSourceUtils.getContainingFile(member2);
        return file1 == null || file2 == null || file1 != file2;
    }

    private final void reportRedeclarations(Set<? extends Pair<? extends KtDeclaration, ? extends DeclarationDescriptorNonRoot>> redeclarations) {
        if (redeclarations.isEmpty()) {
            return;
        }
        Iterator<? extends Pair<? extends KtDeclaration, ? extends DeclarationDescriptorNonRoot>> redeclarationsIterator = redeclarations.iterator();
        DeclarationDescriptorNonRoot firstRedeclarationDescriptor = (DeclarationDescriptorNonRoot)redeclarationsIterator.next().getSecond();
        Iterator<? extends Pair<? extends KtDeclaration, ? extends DeclarationDescriptorNonRoot>> iterator2 = AddToStdlibKt.check(redeclarationsIterator, reportRedeclarations.otherRedeclarationDescriptor.1.INSTANCE);
        DeclarationDescriptorNonRoot otherRedeclarationDescriptor2 = iterator2 != null && (iterator2 = iterator2.next()) != null ? (DeclarationDescriptorNonRoot)iterator2.getSecond() : null;
        for (Pair<? extends KtDeclaration, ? extends DeclarationDescriptorNonRoot> pair2 : redeclarations) {
            KtDeclaration ktDeclaration = (KtDeclaration)pair2.component1();
            DeclarationDescriptorNonRoot memberDescriptor = (DeclarationDescriptorNonRoot)pair2.component2();
            if (ktDeclaration == null) continue;
            DeclarationDescriptorNonRoot declarationDescriptorNonRoot = memberDescriptor;
            if (declarationDescriptorNonRoot instanceof PropertyDescriptor || declarationDescriptorNonRoot instanceof ClassifierDescriptor) {
                this.trace.report(Errors.REDECLARATION.on(ktDeclaration, memberDescriptor.getName().asString()));
                continue;
            }
            if (!(declarationDescriptorNonRoot instanceof FunctionDescriptor)) continue;
            DeclarationDescriptorNonRoot redeclarationDescriptor = otherRedeclarationDescriptor2 == null ? firstRedeclarationDescriptor : (Intrinsics.areEqual((Object)memberDescriptor, (Object)firstRedeclarationDescriptor) ? otherRedeclarationDescriptor2 : firstRedeclarationDescriptor);
            this.trace.report(Errors.CONFLICTING_OVERLOADS.on(ktDeclaration, (CallableMemberDescriptor)memberDescriptor, redeclarationDescriptor.getContainingDeclaration()));
        }
    }

    public OverloadResolver(@NotNull BindingTrace trace, @NotNull OverloadFilter overloadFilter) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)overloadFilter, (String)"overloadFilter");
        this.trace = trace;
        this.overloadFilter = overloadFilter;
    }
}

