/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.context.TypeLazinessToken;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtSelfType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionTypeResolveUtilsKt;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.PlatformTypesMappedToKotlinChecker;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.TypeResolver$Companion$WhenMappings;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallableDescriptors;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DelegatingType;
import org.jetbrains.kotlin.types.DynamicTypesSettings;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 W2\u00020\u0001:\u0002WXBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016H\u0002J.\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0016H\u0002J(\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00162\b\b\u0002\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u001bH\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010 \u001a\u00020!H\u0002J(\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u000204J&\u0010>\u001a\u00020?2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u000204J\u0016\u0010@\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+J\u0018\u0010A\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+H\u0002J&\u0010A\u001a\u00020/2\u0006\u00107\u001a\u0002082\u0006\u0010*\u001a\u00020+2\u0006\u0010;\u001a\u00020<2\u0006\u0010B\u001a\u000204J\"\u0010C\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010GH\u0002J0\u0010H\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010D\u001a\u00020E2\u0006\u0010 \u001a\u00020!2\u0006\u0010.\u001a\u00020:2\u0006\u0010I\u001a\u00020?H\u0002J0\u0010J\u001a\u00020/2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010D\u001a\u00020E2\u0006\u0010K\u001a\u00020\u001b2\u0006\u0010L\u001a\u00020M2\u0006\u0010.\u001a\u00020:H\u0002J,\u0010N\u001a\b\u0012\u0004\u0012\u00020O0\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010P\u001a\u00020Q2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0016H\u0002J.\u0010R\u001a\b\u0012\u0004\u0012\u00020O0\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00162\b\b\u0002\u0010'\u001a\u00020(H\u0002J\u0014\u0010S\u001a\b\u0012\u0004\u0012\u00020!0\u0016*\u0004\u0018\u000106H\u0002J\u0014\u0010T\u001a\u000204*\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010U\u001a\u000204*\u00020V2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeResolver;", "", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "qualifiedExpressionResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "typeTransformerForTests", "Lorg/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "lazinessToken", "Lorg/jetbrains/kotlin/context/TypeLazinessToken;", "dynamicTypesSettings", "Lorg/jetbrains/kotlin/types/DynamicTypesSettings;", "dynamicCallableDescriptors", "Lorg/jetbrains/kotlin/resolve/calls/tasks/DynamicCallableDescriptors;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "(Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/context/TypeLazinessToken;Lorg/jetbrains/kotlin/types/DynamicTypesSettings;Lorg/jetbrains/kotlin/resolve/calls/tasks/DynamicCallableDescriptors;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;)V", "appendDefaultArgumentsForInnerScope", "", "Lorg/jetbrains/kotlin/types/TypeProjectionImpl;", "fromIndex", "", "constructorParameters", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "collectArgumentsForClassTypeConstructor", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "c", "Lorg/jetbrains/kotlin/resolve/TypeResolutionContext;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "qualifierParts", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$QualifierPart;", "createErrorTypeAndResolveArguments", "Lorg/jetbrains/kotlin/resolve/PossiblyBareType;", "argumentElements", "message", "", "doResolvePossiblyBareType", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "forceResolveTypeContents", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getScopeForTypeParameter", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "typeParameterDescriptor", "isPossibleToSpecifyTypeArgumentsFor", "", "resolveClass", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "userType", "Lorg/jetbrains/kotlin/psi/KtUserType;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "isDebuggerContext", "resolveDescriptorForType", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver$TypeQualifierResolutionResult;", "resolvePossiblyBareType", "resolveType", "checkBounds", "resolveTypeElement", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "typeElement", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "resolveTypeForClass", "qualifierResolutionResult", "resolveTypeForTypeParameter", "typeParameter", "referenceExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "resolveTypeProjections", "Lorg/jetbrains/kotlin/types/TypeProjection;", "constructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "resolveTypeProjectionsWithErrorConstructor", "classDescriptorChain", "isDeclaredInScope", "isInsideOfClass", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Companion", "TypeTransformerForTests", "frontend"})
public final class TypeResolver {
    private final AnnotationResolver annotationResolver;
    private final QualifiedExpressionResolver qualifiedExpressionResolver;
    private final ModuleDescriptor moduleDescriptor;
    private final TypeTransformerForTests typeTransformerForTests;
    private final StorageManager storageManager;
    private final TypeLazinessToken lazinessToken;
    private final DynamicTypesSettings dynamicTypesSettings;
    private final DynamicCallableDescriptors dynamicCallableDescriptors;
    private final IdentifierChecker identifierChecker;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final KotlinType resolveType(@NotNull LexicalScope scope2, @NotNull KtTypeReference typeReference, @NotNull BindingTrace trace, boolean checkBounds) {
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)typeReference, (String)"typeReference");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        return this.resolveType(new TypeResolutionContext(scope2, trace, checkBounds, false, CodeFragmentUtilKt.suppressDiagnosticsInDebugMode(typeReference)), typeReference);
    }

    private final KotlinType resolveType(TypeResolutionContext c, KtTypeReference typeReference) {
        boolean bl = !c.allowBareTypes;
        if (_Assertions.ENABLED && !bl) {
            String string = "Use resolvePossiblyBareType() when bare types are allowed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinType kotlinType = this.resolvePossiblyBareType(c, typeReference).getActualType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"resolvePossiblyBareType(\u2026eference).getActualType()");
        return kotlinType;
    }

    @NotNull
    public final PossiblyBareType resolvePossiblyBareType(@NotNull TypeResolutionContext c, @NotNull KtTypeReference typeReference) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)typeReference, (String)"typeReference");
        KotlinType cachedType = (KotlinType)c.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
        if (cachedType != null) {
            PossiblyBareType possiblyBareType = PossiblyBareType.type(cachedType);
            Intrinsics.checkExpressionValueIsNotNull((Object)possiblyBareType, (String)"type(cachedType)");
            return possiblyBareType;
        }
        KotlinType debugType = CodeFragmentUtilKt.getDebugTypeInfo(typeReference);
        if (debugType != null) {
            c.trace.record(BindingContext.TYPE, typeReference, debugType);
            PossiblyBareType possiblyBareType = PossiblyBareType.type(debugType);
            Intrinsics.checkExpressionValueIsNotNull((Object)possiblyBareType, (String)"type(debugType)");
            return possiblyBareType;
        }
        if (!c.allowBareTypes && !c.forceResolveLazyTypes && this.lazinessToken.isLazy()) {
            @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000'\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\r\u0010\n\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0014R\u0019\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"org/jetbrains/kotlin/resolve/TypeResolver$resolvePossiblyBareType$LazyKotlinType", "Lorg/jetbrains/kotlin/types/DelegatingType;", "Lorg/jetbrains/kotlin/resolve/lazy/LazyEntity;", "(Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/resolve/TypeResolutionContext;Lorg/jetbrains/kotlin/psi/KtTypeReference;)V", "_delegate", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/annotations/NotNull;", "forceResolveAllContents", "", "getDelegate", "frontend"})
            public final class LazyKotlinType
            extends DelegatingType
            implements LazyEntity {
                private final NotNullLazyValue<KotlinType> _delegate;
                final /* synthetic */ TypeResolver this$0;
                final /* synthetic */ TypeResolutionContext $c;
                final /* synthetic */ KtTypeReference $typeReference;

                @NotNull
                protected KotlinType getDelegate() {
                    return (KotlinType)this._delegate.invoke();
                }

                public void forceResolveAllContents() {
                    ForceResolveUtil.forceResolveAllContents(this.getConstructor());
                    Iterable $receiver$iv = this.getArguments();
                    for (T element$iv : $receiver$iv) {
                        TypeProjection it = (TypeProjection)element$iv;
                        ForceResolveUtil.forceResolveAllContents(it.getType());
                    }
                }

                public LazyKotlinType(TypeResolver $outer, TypeResolutionContext $captured_local_variable$1, KtTypeReference $captured_local_variable$2) {
                    this.this$0 = $outer;
                    this.$c = $captured_local_variable$1;
                    this.$typeReference = $captured_local_variable$2;
                    this._delegate = TypeResolver.access$getStorageManager$p($outer).createLazyValue((Function0)new Function0<KotlinType>(this){
                        final /* synthetic */ LazyKotlinType this$0;

                        @NotNull
                        public final KotlinType invoke() {
                            return TypeResolver.access$doResolvePossiblyBareType(this.this$0.this$0, this.this$0.$c, this.this$0.$typeReference).getActualType();
                        }
                        {
                            this.this$0 = lazyKotlinType;
                            super(0);
                        }
                    });
                }
            }
            LazyKotlinType lazyKotlinType = new LazyKotlinType(this, c, typeReference);
            c.trace.record(BindingContext.TYPE, typeReference, lazyKotlinType);
            PossiblyBareType possiblyBareType = PossiblyBareType.type(lazyKotlinType);
            Intrinsics.checkExpressionValueIsNotNull((Object)possiblyBareType, (String)"type(lazyKotlinType)");
            return possiblyBareType;
        }
        PossiblyBareType type2 = this.doResolvePossiblyBareType(c, typeReference);
        if (!type2.isBare()) {
            c.trace.record(BindingContext.TYPE, typeReference, type2.getActualType());
        }
        return type2;
    }

    private final PossiblyBareType doResolvePossiblyBareType(TypeResolutionContext c, KtTypeReference typeReference) {
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithoutArguments(c.scope, typeReference.getAnnotationEntries(), c.trace);
        KtTypeElement typeElement = typeReference.getTypeElement();
        Annotations annotations3 = annotations2;
        Intrinsics.checkExpressionValueIsNotNull((Object)annotations3, (String)"annotations");
        PossiblyBareType type2 = this.resolveTypeElement(c, annotations3, typeElement);
        BindingTrace bindingTrace = c.trace;
        LexicalScope lexicalScope = c.scope;
        Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"c.scope");
        BindingContextUtilsKt.recordScope(bindingTrace, lexicalScope, typeReference);
        if (!type2.isBare()) {
            for (TypeProjection argument2 : type2.getActualType().getArguments()) {
                KotlinType kotlinType = argument2.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"argument.type");
                this.forceResolveTypeContents(kotlinType);
            }
        }
        return type2;
    }

    private final void forceResolveTypeContents(KotlinType type2) {
        type2.getAnnotations();
        if (FlexibleTypesKt.isFlexible(type2)) {
            this.forceResolveTypeContents(FlexibleTypesKt.flexibility(type2).getLowerBound());
            this.forceResolveTypeContents(FlexibleTypesKt.flexibility(type2).getUpperBound());
        } else {
            type2.getConstructor();
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                KotlinType kotlinType = projection.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"projection.type");
                this.forceResolveTypeContents(kotlinType);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final PossiblyBareType resolveTypeElement(TypeResolutionContext c, Annotations annotations2, KtTypeElement typeElement) {
        PossiblyBareType possiblyBareType;
        void result2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        KtTypeElement ktTypeElement = typeElement;
        if (ktTypeElement != null) {
            ktTypeElement.accept(new KtVisitorVoid(this, c, (Ref.ObjectRef)result2, annotations2){
                final /* synthetic */ TypeResolver this$0;
                final /* synthetic */ TypeResolutionContext $c;
                final /* synthetic */ Ref.ObjectRef $result;
                final /* synthetic */ Annotations $annotations;

                /*
                 * WARNING - void declaration
                 */
                public void visitUserType(@NotNull KtUserType type2) {
                    PossiblyBareType possiblyBareType;
                    void classifierDescriptor;
                    QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResults;
                    Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                    LexicalScope lexicalScope = this.$c.scope;
                    Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"c.scope");
                    BindingTrace bindingTrace = this.$c.trace;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"c.trace");
                    QualifiedExpressionResolver.TypeQualifierResolutionResult typeQualifierResolutionResult = qualifierResolutionResults = this.this$0.resolveDescriptorForType(lexicalScope, type2, bindingTrace, this.$c.isDebuggerContext);
                    List<QualifiedExpressionResolver.QualifierPart> list2 = typeQualifierResolutionResult.component1();
                    ClassifierDescriptor classifierDescriptor2 = typeQualifierResolutionResult.component2();
                    typeQualifierResolutionResult = null;
                    if (classifierDescriptor == null) {
                        TypeConstructor typeConstructor2 = ErrorUtils.createErrorType("No type").getConstructor();
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"ErrorUtils.createErrorType(\"No type\").constructor");
                        List arguments2 = TypeResolver.access$resolveTypeProjections(this.this$0, this.$c, typeConstructor2, qualifierResolutionResults.getAllProjections());
                        this.$result.element = PossiblyBareType.type(ErrorUtils.createErrorTypeWithArguments(DebugTextUtilKt.getDebugText(type2), arguments2));
                        return;
                    }
                    KtSimpleNameExpression referenceExpression = type2.getReferenceExpression();
                    String referencedName = type2.getReferencedName();
                    if (referenceExpression == null || referencedName == null) {
                        return;
                    }
                    this.$c.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classifierDescriptor);
                    Ref.ObjectRef objectRef = this.$result;
                    void var7_7 = classifierDescriptor;
                    if (var7_7 instanceof TypeParameterDescriptor) {
                        void qualifierParts;
                        boolean bl = qualifierParts.size() == 1;
                        Ref.ObjectRef objectRef2 = objectRef;
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Type parameter can be resolved only by it's short name, but '" + type2.getText() + "' is contradiction " + ("with " + qualifierParts.size() + " qualifier parts");
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        objectRef = objectRef2;
                        possiblyBareType = PossiblyBareType.type(TypeResolver.access$resolveTypeForTypeParameter(this.this$0, this.$c, this.$annotations, (TypeParameterDescriptor)classifierDescriptor, referenceExpression, type2));
                    } else if (var7_7 instanceof ClassDescriptor) {
                        possiblyBareType = TypeResolver.access$resolveTypeForClass(this.this$0, this.$c, this.$annotations, (ClassDescriptor)classifierDescriptor, type2, qualifierResolutionResults);
                    } else {
                        String string = "Unexpected classifier type: " + classifierDescriptor.getClass();
                        Ref.ObjectRef objectRef3 = objectRef;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    objectRef.element = possiblyBareType;
                }

                public void visitNullableType(@NotNull KtNullableType nullableType) {
                    Intrinsics.checkParameterIsNotNull((Object)nullableType, (String)"nullableType");
                    KtTypeElement innerType = nullableType.getInnerType();
                    PossiblyBareType baseType = TypeResolver.access$resolveTypeElement(this.this$0, this.$c, this.$annotations, innerType);
                    if (baseType.isNullable() || innerType instanceof KtNullableType || innerType instanceof KtDynamicType) {
                        this.$c.trace.report(Errors.REDUNDANT_NULLABLE.on((KtNullableType)((PsiElement)nullableType)));
                    }
                    this.$result.element = baseType.makeNullable();
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitFunctionType(@NotNull KtFunctionType type2) {
                    List list2;
                    void destination$iv$iv;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    KotlinType kotlinType;
                    KotlinType kotlinType2;
                    Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                    KtTypeReference receiverTypeRef = type2.getReceiverTypeReference();
                    if (receiverTypeRef == null) {
                        kotlinType2 = null;
                    } else {
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeResolutionContext, (String)"c.noBareTypes()");
                        kotlinType2 = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, receiverTypeRef);
                    }
                    KotlinType receiverType = kotlinType2;
                    List<KtParameter> list3 = type2.getParameters();
                    Intrinsics.checkExpressionValueIsNotNull(list3, (String)"type.parameters");
                    List<VariableDescriptor> parameterDescriptors = this.resolveParametersOfFunctionType(list3);
                    KtTypeReference returnTypeRef = type2.getReturnTypeReference();
                    if (returnTypeRef != null) {
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeResolutionContext, (String)"c.noBareTypes()");
                        kotlinType = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, returnTypeRef);
                    } else {
                        KotlinType kotlinType3 = TypeResolver.access$getModuleDescriptor$p(this.this$0).getBuiltIns().getUnitType();
                        kotlinType = kotlinType3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"moduleDescriptor.builtIns.unitType");
                    }
                    KotlinType returnType2 = kotlinType;
                    Iterable iterable = parameterDescriptors;
                    KotlinType kotlinType4 = receiverType;
                    Annotations annotations2 = this.$annotations;
                    KotlinBuiltIns kotlinBuiltIns = TypeResolver.access$getModuleDescriptor$p(this.this$0).getBuiltIns();
                    Ref.ObjectRef objectRef = this.$result;
                    void var8_12 = $receiver$iv;
                    Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        VariableDescriptor variableDescriptor = (VariableDescriptor)item$iv$iv;
                        list2 = destination$iv$iv;
                        KotlinType kotlinType5 = it.getType();
                        list2.add(kotlinType5);
                    }
                    list2 = (List)destination$iv$iv;
                    objectRef.element = PossiblyBareType.type(FunctionTypeResolveUtilsKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType4, list2, returnType2));
                }

                /*
                 * WARNING - void declaration
                 */
                private final List<VariableDescriptor> resolveParametersOfFunctionType(List<? extends KtParameter> parameters2) {
                    void destination$iv$iv;
                    void $receiver$iv$iv;
                    Object element$iv2;
                    Iterable $receiver$iv = parameters2;
                    for (Object element$iv2 : $receiver$iv) {
                        KtParameter it = (KtParameter)element$iv2;
                        IdentifierChecker identifierChecker = TypeResolver.access$getIdentifierChecker$p(this.this$0);
                        KtDeclaration ktDeclaration = it;
                        DiagnosticSink diagnosticSink = this.$c.trace;
                        Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticSink, (String)"c.trace");
                        identifierChecker.checkDeclaration(ktDeclaration, diagnosticSink);
                        this.checkParameterInFunctionType(it);
                    }
                    $receiver$iv = parameters2;
                    Iterable iterable = $receiver$iv;
                    element$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void parameter;
                        KtParameter $i$f$forEach = (KtParameter)item$iv$iv;
                        void var13_10 = destination$iv$iv;
                        TypeResolutionContext typeResolutionContext = this.$c.noBareTypes();
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeResolutionContext, (String)"c.noBareTypes()");
                        KtTypeReference ktTypeReference = parameter.getTypeReference();
                        if (ktTypeReference == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"parameter.typeReference!!");
                        KotlinType parameterType = TypeResolver.access$resolveType(this.this$0, typeResolutionContext, ktTypeReference);
                        DeclarationDescriptor declarationDescriptor = this.$c.scope.getOwnerDescriptor();
                        Annotations annotations2 = TypeResolver.access$getAnnotationResolver$p(this.this$0).resolveAnnotationsWithoutArguments(this.$c.scope, parameter.getModifierList(), this.$c.trace);
                        Intrinsics.checkExpressionValueIsNotNull((Object)annotations2, (String)"annotationResolver.resol\u2026er.modifierList, c.trace)");
                        Name name2 = parameter.getNameAsSafeName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"parameter.nameAsSafeName");
                        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000S\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ5\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u0002H\u000fH\u0016\u00a2\u0006\u0002\u0010\u0013J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006\u001f"}, d2={"org/jetbrains/kotlin/resolve/TypeResolver$resolveTypeElement$1$resolveParametersOfFunctionType$ParameterOfFunctionTypeDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/VariableDescriptorImpl;", "containingDeclaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "name", "Lorg/jetbrains/kotlin/name/Name;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "source", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/descriptors/SourceElement;)V", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorVisitor;", "data", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getCompileTimeInitializer", "", "getVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "kotlin.jvm.PlatformType", "isVar", "", "substitute", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "frontend"})
                        public final class ParameterOfFunctionTypeDescriptor
                        extends VariableDescriptorImpl {
                            public Visibility getVisibility() {
                                return Visibilities.LOCAL;
                            }

                            @Nullable
                            public VariableDescriptor substitute(@NotNull TypeSubstitutor substitutor3) {
                                Intrinsics.checkParameterIsNotNull((Object)substitutor3, (String)"substitutor");
                                throw (Throwable)new UnsupportedOperationException("Should not be called for descriptor of type " + this.getClass());
                            }

                            public boolean isVar() {
                                return false;
                            }

                            @Nullable
                            public Void getCompileTimeInitializer() {
                                return null;
                            }

                            public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor2, D data) {
                                Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
                                return visitor2.visitVariableDescriptor(this, data);
                            }

                            public ParameterOfFunctionTypeDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name2, @NotNull KotlinType type2, @NotNull SourceElement source) {
                                Intrinsics.checkParameterIsNotNull((Object)containingDeclaration, (String)"containingDeclaration");
                                Intrinsics.checkParameterIsNotNull((Object)annotations2, (String)"annotations");
                                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                                super(containingDeclaration, annotations2, name2, type2, source);
                            }
                        }
                        ParameterOfFunctionTypeDescriptor descriptor2 = new ParameterOfFunctionTypeDescriptor(declarationDescriptor, annotations2, name2, parameterType, KotlinSourceElementKt.toSourceElement((KtElement)parameter));
                        this.$c.trace.record(BindingContext.VALUE_PARAMETER, parameter, descriptor2);
                        ParameterOfFunctionTypeDescriptor parameterOfFunctionTypeDescriptor = descriptor2;
                        var13_10.add(parameterOfFunctionTypeDescriptor);
                    }
                    return (List)destination$iv$iv;
                }

                public void visitDynamicType(@NotNull KtDynamicType type2) {
                    Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                    this.$result.element = PossiblyBareType.type(TypeResolver.access$getDynamicCallableDescriptors$p(this.this$0).getDynamicType());
                    if (!TypeResolver.access$getDynamicTypesSettings$p(this.this$0).getDynamicTypesAllowed()) {
                        this.$c.trace.report(Errors.UNSUPPORTED.on((PsiElement)type2, "Dynamic types are not supported in this context"));
                    }
                }

                public void visitSelfType(@NotNull KtSelfType type2) {
                    Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                    this.$c.trace.report(Errors.UNSUPPORTED.on((PsiElement)type2, "Self-types are not supported"));
                }

                public void visitKtElement(@NotNull KtElement element2) {
                    Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                    this.$c.trace.report(Errors.UNSUPPORTED.on((PsiElement)element2, "Self-types are not supported yet"));
                }

                /*
                 * WARNING - void declaration
                 */
                private final void checkParameterInFunctionType(KtParameter param) {
                    block7: {
                        KtModifierList modifierList;
                        if (param.hasDefaultValue()) {
                            BindingTrace bindingTrace = this.$c.trace;
                            KtExpression ktExpression = param.getDefaultValue();
                            if (ktExpression == null) {
                                Intrinsics.throwNpe();
                            }
                            bindingTrace.report(Errors.UNSUPPORTED.on((PsiElement)ktExpression, "default value of parameter in function type"));
                        }
                        if (param.getName() != null) {
                            for (KtAnnotationEntry annotationEntry2 : param.getAnnotationEntries()) {
                                this.$c.trace.report(Errors.UNSUPPORTED.on((PsiElement)annotationEntry2, "annotation on parameter in function type"));
                            }
                        }
                        if ((modifierList = param.getModifierList()) != null) {
                            void destination$iv$iv;
                            void $receiver$iv$iv$iv;
                            Iterator<T> $receiver$iv$iv;
                            Object $receiver$iv = (Object[])KtTokens.MODIFIER_KEYWORDS_ARRAY;
                            Object[] objectArray = $receiver$iv;
                            Collection collection = new ArrayList<E>();
                            void var6_6 = $receiver$iv$iv;
                            for (int i = 0; i < ((void)$receiver$iv$iv$iv).length; ++i) {
                                PsiElement psiElement;
                                void element$iv$iv$iv = $receiver$iv$iv$iv[i];
                                void element$iv$iv = element$iv$iv$iv;
                                KtModifierKeywordToken it = (KtModifierKeywordToken)element$iv$iv;
                                if (modifierList.getModifier(it) == null) continue;
                                PsiElement it$iv$iv = psiElement;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            $receiver$iv = (List)destination$iv$iv;
                            $receiver$iv$iv = $receiver$iv.iterator();
                            while ($receiver$iv$iv.hasNext()) {
                                T element$iv = $receiver$iv$iv.next();
                                PsiElement it = (PsiElement)element$iv;
                                this.$c.trace.report(Errors.UNSUPPORTED.on(it, "modifier on parameter in function type"));
                            }
                        }
                        PsiElement psiElement = param.getValOrVarKeyword();
                        if (psiElement == null) break block7;
                        PsiElement psiElement2 = psiElement;
                        PsiElement it = psiElement2;
                        this.$c.trace.report(Errors.UNSUPPORTED.on(it, "val or val on parameter in function type"));
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$c = $captured_local_variable$1;
                    this.$result = $captured_local_variable$2;
                    this.$annotations = $captured_local_variable$3;
                }
            });
        }
        if ((possiblyBareType = (PossiblyBareType)result2.element) == null) {
            Object object = typeElement;
            if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
                object = "No type element";
            }
            PossiblyBareType possiblyBareType2 = PossiblyBareType.type(ErrorUtils.createErrorType((String)object));
            possiblyBareType = possiblyBareType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)possiblyBareType2, (String)"type(ErrorUtils.createEr\u2026() ?: \"No type element\"))");
        }
        return possiblyBareType;
    }

    private final KotlinType resolveTypeForTypeParameter(TypeResolutionContext c, Annotations annotations2, TypeParameterDescriptor typeParameter, KtSimpleNameExpression referenceExpression, KtUserType type2) {
        KotlinType kotlinType;
        DeclarationDescriptor containing;
        MemberScope scopeForTypeParameter = this.getScopeForTypeParameter(c, typeParameter);
        TypeConstructor typeConstructor2 = ErrorUtils.createErrorType("No type").getConstructor();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"ErrorUtils.createErrorType(\"No type\").constructor");
        List<KtTypeProjection> list2 = type2.getTypeArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"type.typeArguments");
        List<TypeProjection> arguments2 = this.resolveTypeProjections(c, typeConstructor2, list2);
        if (!arguments2.isEmpty()) {
            BindingTrace bindingTrace = c.trace;
            KtTypeArgumentList ktTypeArgumentList = type2.getTypeArgumentList();
            if (ktTypeArgumentList == null) {
                Intrinsics.throwNpe();
            }
            bindingTrace.report(Errors.TYPE_ARGUMENTS_NOT_ALLOWED.on((KtElement)((PsiElement)ktTypeArgumentList), "for type parameters"));
        }
        if ((containing = typeParameter.getContainingDeclaration()) instanceof ClassDescriptor) {
            DescriptorResolver.checkHasOuterClassInstance(c.scope, c.trace, (PsiElement)referenceExpression, (ClassDescriptor)containing);
        }
        if (scopeForTypeParameter instanceof ErrorUtils.ErrorScope) {
            KotlinType kotlinType2 = ErrorUtils.createErrorType("?");
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"ErrorUtils.createErrorType(\"?\")");
        } else {
            TypeConstructor typeConstructor3 = typeParameter.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor3, (String)"typeParameter.typeConstructor");
            boolean bl = false;
            TypeConstructor typeConstructor4 = typeConstructor3;
            Annotations annotations3 = annotations2;
            KotlinTypeImpl.Companion companion = KotlinTypeImpl.Companion;
            List list3 = CollectionsKt.emptyList();
            kotlinType = companion.create(annotations3, typeConstructor4, bl, list3, scopeForTypeParameter);
        }
        return kotlinType;
    }

    private final MemberScope getScopeForTypeParameter(TypeResolutionContext c, TypeParameterDescriptor typeParameterDescriptor) {
        MemberScope memberScope2;
        if (c.checkBounds) {
            MemberScope memberScope3 = TypeIntersector.getUpperBoundsAsType(typeParameterDescriptor).getMemberScope();
            memberScope2 = memberScope3;
            Intrinsics.checkExpressionValueIsNotNull((Object)memberScope3, (String)"TypeIntersector.getUpper\u2026erDescriptor).memberScope");
        } else {
            memberScope2 = new LazyScopeAdapter(LockBasedStorageManager.NO_LOCKS.createLazyValue((Function0)new Function0<MemberScope>(typeParameterDescriptor){
                final /* synthetic */ TypeParameterDescriptor $typeParameterDescriptor;

                @NotNull
                public final MemberScope invoke() {
                    return TypeIntersector.getUpperBoundsAsType(this.$typeParameterDescriptor).getMemberScope();
                }
                {
                    this.$typeParameterDescriptor = typeParameterDescriptor;
                    super(0);
                }
            }));
        }
        return memberScope2;
    }

    /*
     * WARNING - void declaration
     */
    private final PossiblyBareType resolveTypeForClass(TypeResolutionContext c, Annotations annotations2, ClassDescriptor classDescriptor, KtUserType type2, QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult) {
        TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
        List<KtTypeProjection> projectionFromAllQualifierParts = qualifierResolutionResult.getAllProjections();
        List<TypeParameterDescriptor> parameters2 = typeConstructor2.getParameters();
        if (c.allowBareTypes && projectionFromAllQualifierParts.isEmpty() && this.isPossibleToSpecifyTypeArgumentsFor(classDescriptor)) {
            PossiblyBareType possiblyBareType = PossiblyBareType.bare(typeConstructor2, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)possiblyBareType, (String)"PossiblyBareType.bare(typeConstructor, false)");
            return possiblyBareType;
        }
        if (ErrorUtils.isError(classDescriptor)) {
            return this.createErrorTypeAndResolveArguments(c, projectionFromAllQualifierParts, "[Error type: " + typeConstructor2 + "]");
        }
        List<KtTypeProjection> list2 = this.collectArgumentsForClassTypeConstructor(c, classDescriptor, qualifierResolutionResult.getQualifierParts());
        if (list2 == null) {
            return this.createErrorTypeAndResolveArguments(c, projectionFromAllQualifierParts, typeConstructor2.toString());
        }
        List<KtTypeProjection> collectedArgumentAsTypeProjections = list2;
        boolean bl = collectedArgumentAsTypeProjections.size() <= parameters2.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Collected arguments count should be not greater then parameters count," + (" but " + collectedArgumentAsTypeProjections.size() + " instead of " + parameters2.size() + " found in " + type2.getText());
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        TypeConstructor typeConstructor3 = typeConstructor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor3, (String)"typeConstructor");
        List<TypeProjection> argumentsFromUserType = this.resolveTypeProjections(c, typeConstructor3, collectedArgumentAsTypeProjections);
        Collection collection = argumentsFromUserType;
        int n = argumentsFromUserType.size();
        List<TypeParameterDescriptor> list3 = parameters2;
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"parameters");
        List arguments2 = CollectionsKt.plus((Collection)collection, (Iterable)this.appendDefaultArgumentsForInnerScope(n, list3));
        boolean bl2 = arguments2.size() == parameters2.size();
        if (_Assertions.ENABLED && !bl2) {
            String string = "Collected arguments count should be equal to parameters count," + (" but " + collectedArgumentAsTypeProjections.size() + " instead of " + parameters2.size() + " found in " + type2.getText());
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinTypeImpl resultingType = KotlinTypeImpl.Companion.create(annotations2, classDescriptor, false, arguments2);
        KotlinType kotlinType = this.typeTransformerForTests.transformType(resultingType);
        if (kotlinType != null) {
            KotlinType $i$a$2$assert = kotlinType;
            KotlinType it = $i$a$2$assert;
            PossiblyBareType possiblyBareType = PossiblyBareType.type(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)possiblyBareType, (String)"type(it)");
            return possiblyBareType;
        }
        if (c.checkBounds) {
            TypeSubstitutor substitutor3 = TypeSubstitutor.create(resultingType);
            int it = 0;
            int n2 = ((Collection)parameters2).size() - 1;
            if (it <= n2) {
                while (true) {
                    KtTypeReference typeReference;
                    void i;
                    TypeParameterDescriptor parameter = parameters2.get((int)i);
                    KotlinType argument2 = ((TypeProjection)arguments2.get((int)i)).getType();
                    KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.getOrNull(collectedArgumentAsTypeProjections, (int)i);
                    KtTypeReference ktTypeReference = typeReference = ktTypeProjection != null ? ktTypeProjection.getTypeReference() : null;
                    if (typeReference != null) {
                        DescriptorResolver.checkBounds(typeReference, argument2, parameter, substitutor3, c.trace);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
        }
        if (TypeUtilsKt.isArrayOfNothing(resultingType)) {
            c.trace.report(Errors.UNSUPPORTED.on((PsiElement)type2, "Array<Nothing> is illegal"));
        }
        PossiblyBareType possiblyBareType = PossiblyBareType.type(resultingType);
        Intrinsics.checkExpressionValueIsNotNull((Object)possiblyBareType, (String)"type(resultingType)");
        return possiblyBareType;
    }

    private final boolean isPossibleToSpecifyTypeArgumentsFor(ClassDescriptor classDescriptor) {
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)CollectionsKt.firstOrNull(classDescriptor.getTypeConstructor().getParameters());
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor firstTypeParameter = typeParameterDescriptor;
        return firstTypeParameter.getOriginal().getContainingDeclaration() instanceof ClassDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtTypeProjection> collectArgumentsForClassTypeConstructor(TypeResolutionContext c, ClassDescriptor classDescriptor, List<QualifiedExpressionResolver.QualifierPart> qualifierParts) {
        Object currentParameters;
        Iterable currentArguments;
        List<ClassDescriptor> classDescriptorChain2 = this.classDescriptorChain(classDescriptor);
        List reversedQualifierParts = CollectionsKt.asReversed(qualifierParts);
        boolean wasStatic = false;
        SmartList result2 = new SmartList();
        int n = 0;
        int classChainLastIndex = Math.min(classDescriptorChain2.size(), reversedQualifierParts.size()) - 1;
        int n2 = classChainLastIndex;
        if (n <= n2) {
            while (true) {
                void index2;
                QualifiedExpressionResolver.QualifierPart qualifierPart = (QualifiedExpressionResolver.QualifierPart)reversedQualifierParts.get((int)index2);
                KtTypeArgumentList ktTypeArgumentList = qualifierPart.getTypeArguments();
                List list2 = ktTypeArgumentList != null ? ktTypeArgumentList.getArguments() : null;
                Object object = list2;
                if (object == null) {
                    object = CollectionsKt.emptyList();
                }
                currentArguments = object;
                List<TypeParameterDescriptor> declaredTypeParameters = classDescriptorChain2.get((int)index2).getDeclaredTypeParameters();
                Object object2 = currentParameters = wasStatic ? CollectionsKt.emptyList() : declaredTypeParameters;
                if (wasStatic) {
                    Collection collection = currentArguments;
                    if (!collection.isEmpty()) {
                        collection = declaredTypeParameters;
                        if (!collection.isEmpty()) {
                            BindingTrace bindingTrace = c.trace;
                            KtTypeArgumentList ktTypeArgumentList2 = qualifierPart.getTypeArguments();
                            if (ktTypeArgumentList2 == null) {
                                Intrinsics.throwNpe();
                            }
                            bindingTrace.report(Errors.TYPE_ARGUMENTS_FOR_OUTER_CLASS_WHEN_NESTED_REFERENCED.on((KtTypeArgumentList)((PsiElement)ktTypeArgumentList2)));
                            return null;
                        }
                    }
                }
                if (currentArguments.size() != currentParameters.size()) {
                    KtTypeArgumentList ktTypeArgumentList3 = qualifierPart.getTypeArguments();
                    c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)(ktTypeArgumentList3 != null ? (KtElement)ktTypeArgumentList3 : (KtElement)qualifierPart.getExpression())), currentParameters.size(), classDescriptorChain2.get((int)index2)));
                    return null;
                }
                result2.addAll((Collection)currentArguments);
                boolean bl = wasStatic = wasStatic || !classDescriptorChain2.get((int)index2).isInner();
                if (index2 == n2) break;
                ++index2;
            }
        }
        List nonClassQualifierParts = reversedQualifierParts.subList(Math.min(classChainLastIndex + 1, reversedQualifierParts.size()), reversedQualifierParts.size());
        for (QualifiedExpressionResolver.QualifierPart qualifierPart : nonClassQualifierParts) {
            if (qualifierPart.getTypeArguments() == null) continue;
            c.trace.report(Errors.TYPE_ARGUMENTS_NOT_ALLOWED.on((KtElement)((PsiElement)qualifierPart.getTypeArguments()), "here"));
            return null;
        }
        List<TypeParameterDescriptor> parameters2 = classDescriptor.getTypeConstructor().getParameters();
        if (result2.size() < parameters2.size()) {
            boolean bl;
            block13: {
                Object item$iv;
                TypeParameterDescriptor it;
                Iterable $receiver$iv;
                currentArguments = parameters2.subList(result2.size(), parameters2.size());
                ArrayList list$iv = new ArrayList();
                currentParameters = $receiver$iv.iterator();
                while (currentParameters.hasNext() && (it = (TypeParameterDescriptor)(item$iv = currentParameters.next())).getOriginal().getContainingDeclaration() instanceof ClassDescriptor) {
                    list$iv.add(item$iv);
                }
                List typeParametersToSpecify = list$iv;
                $receiver$iv = typeParametersToSpecify;
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor parameter = (TypeParameterDescriptor)element$iv;
                    if (!(!this.isDeclaredInScope(parameter, c))) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
            if (bl) {
                c.trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on((KtElement)((PsiElement)((QualifiedExpressionResolver.QualifierPart)CollectionsKt.last(qualifierParts)).getExpression()), parameters2.size(), classDescriptor));
                return null;
            }
        }
        return (List)result2;
    }

    private final List<ClassDescriptor> classDescriptorChain(@Nullable ClassifierDescriptor $receiver) {
        return SequencesKt.toList((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<ClassDescriptor>($receiver){
            final /* synthetic */ ClassifierDescriptor receiver$0;

            @Nullable
            public final ClassDescriptor invoke() {
                ClassifierDescriptor classifierDescriptor = this.receiver$0;
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                return (ClassDescriptor)classifierDescriptor;
            }
            {
                this.receiver$0 = classifierDescriptor;
                super(0);
            }
        }), (Function1)classDescriptorChain.2.INSTANCE));
    }

    private final boolean isDeclaredInScope(@NotNull TypeParameterDescriptor $receiver, TypeResolutionContext c) {
        boolean bl = $receiver.getContainingDeclaration() instanceof ClassDescriptor;
        if (_Assertions.ENABLED && !bl) {
            String string = "This function is implemented for classes only, but " + $receiver.getContainingDeclaration() + " was given";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        HierarchicalScope hierarchicalScope = c.scope;
        Name name2 = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"name");
        ClassifierDescriptor classifierDescriptor = ScopeUtilsKt.findClassifier(hierarchicalScope, name2, NoLookupLocation.WHEN_RESOLVING_DEFAULT_TYPE_ARGUMENTS);
        if (classifierDescriptor == null) {
            return false;
        }
        ClassifierDescriptor contributedClassifier = classifierDescriptor;
        if (Intrinsics.areEqual((Object)contributedClassifier.getTypeConstructor(), (Object)$receiver.getTypeConstructor())) {
            return true;
        }
        DeclarationDescriptor declarationDescriptor = $receiver.getOriginal().getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return this.isInsideOfClass(c.scope.getOwnerDescriptor(), (ClassDescriptor)declarationDescriptor);
    }

    private final boolean isInsideOfClass(@NotNull DeclarationDescriptor $receiver, ClassDescriptor classDescriptor) {
        boolean bl;
        block1: {
            Sequence $receiver$iv = SequencesKt.generateSequence((Object)$receiver, (Function1)isInsideOfClass.1.INSTANCE);
            for (Object element$iv : $receiver$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                if (!Intrinsics.areEqual((Object)it.getOriginal(), (Object)classDescriptor)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final List<TypeProjection> resolveTypeProjectionsWithErrorConstructor(TypeResolutionContext c, List<? extends KtTypeProjection> argumentElements, String message2) {
        TypeConstructor typeConstructor2 = ErrorUtils.createErrorTypeConstructor(message2);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"ErrorUtils.createErrorTypeConstructor(message)");
        return this.resolveTypeProjections(c, typeConstructor2, argumentElements);
    }

    static /* bridge */ /* synthetic */ List resolveTypeProjectionsWithErrorConstructor$default(TypeResolver typeResolver, TypeResolutionContext typeResolutionContext, List list2, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveTypeProjectionsWithErrorConstructor");
        }
        if ((n & 4) != 0) {
            string = "Error type for resolving type projections";
        }
        return typeResolver.resolveTypeProjectionsWithErrorConstructor(typeResolutionContext, list2, string);
    }

    private final PossiblyBareType createErrorTypeAndResolveArguments(TypeResolutionContext c, List<? extends KtTypeProjection> argumentElements, String message2) {
        PossiblyBareType possiblyBareType = PossiblyBareType.type(ErrorUtils.createErrorTypeWithArguments(message2, TypeResolver.resolveTypeProjectionsWithErrorConstructor$default(this, c, argumentElements, null, 4, null)));
        Intrinsics.checkExpressionValueIsNotNull((Object)possiblyBareType, (String)"type(ErrorUtils.createEr\u2026or(c, argumentElements)))");
        return possiblyBareType;
    }

    static /* bridge */ /* synthetic */ PossiblyBareType createErrorTypeAndResolveArguments$default(TypeResolver typeResolver, TypeResolutionContext typeResolutionContext, List list2, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createErrorTypeAndResolveArguments");
        }
        if ((n & 4) != 0) {
            string = "";
        }
        return typeResolver.createErrorTypeAndResolveArguments(typeResolutionContext, list2, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeProjectionImpl> appendDefaultArgumentsForInnerScope(int fromIndex, List<? extends TypeParameterDescriptor> constructorParameters) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = constructorParameters.subList(fromIndex, constructorParameters.size());
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            void var12_9 = destination$iv$iv;
            DeclarationDescriptorWithSource declarationDescriptorWithSource = it.getOriginal();
            if (declarationDescriptorWithSource == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.TypeParameterDescriptor");
            }
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(((TypeParameterDescriptor)declarationDescriptorWithSource).getDefaultType());
            var12_9.add(typeProjectionImpl);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeProjection> resolveTypeProjections(TypeResolutionContext c, TypeConstructor constructor, List<? extends KtTypeProjection> argumentElements) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = argumentElements;
        void var5_5 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            TypeProjection typeProjection;
            void i;
            void argumentElement;
            int n = index$iv$iv++;
            KtTypeProjection ktTypeProjection = (KtTypeProjection)item$iv$iv;
            int n2 = n;
            void var19_16 = destination$iv$iv;
            KtProjectionKind projectionKind = argumentElement.getProjectionKind();
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)argumentElement;
            BindingTrace bindingTrace = c.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"c.trace");
            ModifierCheckerCore.INSTANCE.check(ktModifierListOwner, bindingTrace, null);
            if (Intrinsics.areEqual((Object)((Object)projectionKind), (Object)((Object)KtProjectionKind.STAR))) {
                List<TypeParameterDescriptor> parameters2 = constructor.getParameters();
                if (parameters2.size() > i) {
                    TypeParameterDescriptor parameterDescriptor = parameters2.get((int)i);
                    TypeProjection typeProjection2 = TypeUtils.makeStarProjection(parameterDescriptor);
                    typeProjection = typeProjection2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeProjection2, (String)"TypeUtils.makeStarProjection(parameterDescriptor)");
                } else {
                    typeProjection = new TypeProjectionImpl(Variance.OUT_VARIANCE, ErrorUtils.createErrorType("*"));
                }
            } else {
                TypeResolutionContext typeResolutionContext = c.noBareTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeResolutionContext, (String)"c.noBareTypes()");
                KtTypeReference ktTypeReference = argumentElement.getTypeReference();
                if (ktTypeReference == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"argumentElement.getTypeReference()!!");
                KotlinType type2 = this.resolveType(typeResolutionContext, ktTypeReference);
                KtProjectionKind ktProjectionKind = projectionKind;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktProjectionKind), (String)"projectionKind");
                Variance kind2 = Companion.resolveProjectionKind(ktProjectionKind);
                if (constructor.getParameters().size() > i) {
                    TypeParameterDescriptor parameterDescriptor = constructor.getParameters().get((int)i);
                    if (Intrinsics.areEqual((Object)((Object)kind2), (Object)((Object)Variance.INVARIANT)) ^ true && Intrinsics.areEqual((Object)((Object)parameterDescriptor.getVariance()), (Object)((Object)Variance.INVARIANT)) ^ true) {
                        if (Intrinsics.areEqual((Object)((Object)kind2), (Object)((Object)parameterDescriptor.getVariance()))) {
                            BindingTrace bindingTrace2 = c.trace;
                            PsiElement psiElement = (PsiElement)argumentElement;
                            ClassifierDescriptor classifierDescriptor = constructor.getDeclarationDescriptor();
                            if (classifierDescriptor == null) {
                                Intrinsics.throwNpe();
                            }
                            bindingTrace2.report(Errors.REDUNDANT_PROJECTION.on((KtTypeProjection)psiElement, classifierDescriptor));
                        } else {
                            BindingTrace bindingTrace3 = c.trace;
                            PsiElement psiElement = (PsiElement)argumentElement;
                            ClassifierDescriptor classifierDescriptor = constructor.getDeclarationDescriptor();
                            if (classifierDescriptor == null) {
                                Intrinsics.throwNpe();
                            }
                            bindingTrace3.report(Errors.CONFLICTING_PROJECTION.on((KtTypeProjection)psiElement, classifierDescriptor));
                        }
                    }
                }
                typeProjection = new TypeProjectionImpl(kind2, type2);
            }
            TypeProjection typeProjection3 = typeProjection;
            var19_16.add(typeProjection3);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ClassifierDescriptor resolveClass(@NotNull LexicalScope scope2, @NotNull KtUserType userType, @NotNull BindingTrace trace, boolean isDebuggerContext) {
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)userType, (String)"userType");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        return this.resolveDescriptorForType(scope2, userType, trace, isDebuggerContext).getClassifierDescriptor();
    }

    @NotNull
    public final QualifiedExpressionResolver.TypeQualifierResolutionResult resolveDescriptorForType(@NotNull LexicalScope scope2, @NotNull KtUserType userType, @NotNull BindingTrace trace, boolean isDebuggerContext) {
        QualifiedExpressionResolver.TypeQualifierResolutionResult result2;
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)userType, (String)"userType");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        if (userType.getQualifier() != null) {
            KtUserType ktUserType = userType.getQualifier();
            if (ktUserType == null) {
                Intrinsics.throwNpe();
            }
            for (KtTypeProjection typeArgument : ktUserType.getTypeArguments()) {
                if (typeArgument.getTypeReference() != null) {
                    KtTypeReference ktTypeReference;
                    KtTypeReference it;
                    KtTypeReference ktTypeReference2 = it = ktTypeReference;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference2, (String)"it");
                    this.forceResolveTypeContents(this.resolveType(scope2, ktTypeReference2, trace, true));
                }
            }
        }
        if ((result2 = this.qualifiedExpressionResolver.resolveDescriptorForType(userType, scope2, trace, isDebuggerContext)).getClassifierDescriptor() != null) {
            PlatformTypesMappedToKotlinChecker.reportPlatformClassMappedToKotlin(this.moduleDescriptor, trace, userType, result2.getClassifierDescriptor());
        }
        return result2;
    }

    public TypeResolver(@NotNull AnnotationResolver annotationResolver, @NotNull QualifiedExpressionResolver qualifiedExpressionResolver, @NotNull ModuleDescriptor moduleDescriptor, @NotNull TypeTransformerForTests typeTransformerForTests, @NotNull StorageManager storageManager, @NotNull TypeLazinessToken lazinessToken, @NotNull DynamicTypesSettings dynamicTypesSettings, @NotNull DynamicCallableDescriptors dynamicCallableDescriptors, @NotNull IdentifierChecker identifierChecker) {
        Intrinsics.checkParameterIsNotNull((Object)annotationResolver, (String)"annotationResolver");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedExpressionResolver, (String)"qualifiedExpressionResolver");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)typeTransformerForTests, (String)"typeTransformerForTests");
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        Intrinsics.checkParameterIsNotNull((Object)lazinessToken, (String)"lazinessToken");
        Intrinsics.checkParameterIsNotNull((Object)dynamicTypesSettings, (String)"dynamicTypesSettings");
        Intrinsics.checkParameterIsNotNull((Object)dynamicCallableDescriptors, (String)"dynamicCallableDescriptors");
        Intrinsics.checkParameterIsNotNull((Object)identifierChecker, (String)"identifierChecker");
        this.annotationResolver = annotationResolver;
        this.qualifiedExpressionResolver = qualifiedExpressionResolver;
        this.moduleDescriptor = moduleDescriptor;
        this.typeTransformerForTests = typeTransformerForTests;
        this.storageManager = storageManager;
        this.lazinessToken = lazinessToken;
        this.dynamicTypesSettings = dynamicTypesSettings;
        this.dynamicCallableDescriptors = dynamicCallableDescriptors;
        this.identifierChecker = identifierChecker;
    }

    @NotNull
    public static final /* synthetic */ StorageManager access$getStorageManager$p(TypeResolver $this) {
        return $this.storageManager;
    }

    @NotNull
    public static final /* synthetic */ PossiblyBareType access$doResolvePossiblyBareType(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull KtTypeReference typeReference) {
        return $this.doResolvePossiblyBareType(c, typeReference);
    }

    @NotNull
    public static final /* synthetic */ List access$resolveTypeProjections(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull TypeConstructor constructor, @NotNull List argumentElements) {
        return $this.resolveTypeProjections(c, constructor, argumentElements);
    }

    @NotNull
    public static final /* synthetic */ KotlinType access$resolveTypeForTypeParameter(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull Annotations annotations2, @NotNull TypeParameterDescriptor typeParameter, @NotNull KtSimpleNameExpression referenceExpression, @NotNull KtUserType type2) {
        return $this.resolveTypeForTypeParameter(c, annotations2, typeParameter, referenceExpression, type2);
    }

    @NotNull
    public static final /* synthetic */ PossiblyBareType access$resolveTypeForClass(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull Annotations annotations2, @NotNull ClassDescriptor classDescriptor, @NotNull KtUserType type2, @NotNull QualifiedExpressionResolver.TypeQualifierResolutionResult qualifierResolutionResult) {
        return $this.resolveTypeForClass(c, annotations2, classDescriptor, type2, qualifierResolutionResult);
    }

    @NotNull
    public static final /* synthetic */ PossiblyBareType access$resolveTypeElement(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull Annotations annotations2, @Nullable KtTypeElement typeElement) {
        return $this.resolveTypeElement(c, annotations2, typeElement);
    }

    @NotNull
    public static final /* synthetic */ KotlinType access$resolveType(TypeResolver $this, @NotNull TypeResolutionContext c, @NotNull KtTypeReference typeReference) {
        return $this.resolveType(c, typeReference);
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(TypeResolver $this) {
        return $this.moduleDescriptor;
    }

    @NotNull
    public static final /* synthetic */ IdentifierChecker access$getIdentifierChecker$p(TypeResolver $this) {
        return $this.identifierChecker;
    }

    @NotNull
    public static final /* synthetic */ AnnotationResolver access$getAnnotationResolver$p(TypeResolver $this) {
        return $this.annotationResolver;
    }

    @NotNull
    public static final /* synthetic */ DynamicCallableDescriptors access$getDynamicCallableDescriptors$p(TypeResolver $this) {
        return $this.dynamicCallableDescriptors;
    }

    @NotNull
    public static final /* synthetic */ DynamicTypesSettings access$getDynamicTypesSettings$p(TypeResolver $this) {
        return $this.dynamicTypesSettings;
    }

    @JvmStatic
    @NotNull
    public static final Variance resolveProjectionKind(@NotNull KtProjectionKind projectionKind) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)projectionKind), (String)"projectionKind");
        return Companion.resolveProjectionKind(projectionKind);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeResolver$TypeTransformerForTests;", "", "()V", "transformType", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlinType", "frontend"})
    public static class TypeTransformerForTests {
        @Nullable
        public KotlinType transformType(@NotNull KotlinType kotlinType) {
            Intrinsics.checkParameterIsNotNull((Object)kotlinType, (String)"kotlinType");
            return null;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeResolver$Companion;", "", "()V", "resolveProjectionKind", "Lorg/jetbrains/kotlin/types/Variance;", "projectionKind", "Lorg/jetbrains/kotlin/psi/KtProjectionKind;", "frontend"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Variance resolveProjectionKind(@NotNull KtProjectionKind projectionKind) {
            Variance variance;
            Intrinsics.checkParameterIsNotNull((Object)((Object)projectionKind), (String)"projectionKind");
            switch (TypeResolver$Companion$WhenMappings.$EnumSwitchMapping$0[projectionKind.ordinal()]) {
                case 1: {
                    variance = Variance.IN_VARIANCE;
                    break;
                }
                case 2: {
                    variance = Variance.OUT_VARIANCE;
                    break;
                }
                case 3: {
                    variance = Variance.INVARIANT;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException("Illegal projection kind:" + (Object)((Object)projectionKind));
                }
            }
            return variance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

