/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callResolverUtil;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001e\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u00190\u00182\u0006\u0010\u001b\u001a\u00020\rH\u0002\u001a\u0013\u0010\u001c\u001a\u00070\r\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u001b\u001a\u00020\r\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\r\u001a\u000e\u0010\"\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\r\u001a\u000e\u0010#\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010$\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010%\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010&\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010'\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020(\u001a\u000e\u0010)\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r\u001a\u0016\u0010*\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010+\u001a\u00020\r\u001a\u001e\u0010,\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020\r2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u001a\u0012\u0010/\u001a\u00020!*\u00020\u00162\u0006\u00100\u001a\u000201\u001a\u0014\u00102\u001a\u00020!*\u00020\u00162\u0006\u00100\u001a\u000201H\u0002\u00a8\u00063"}, d2={"createResolutionCandidatesForConstructors", "", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate;", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "lexicalScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "classWithConstructors", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "knownSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "getEffectiveExpectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getErasedReceiverType", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getParameterArgumentsOfCallableType", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "kotlin.jvm.PlatformType", "type", "getReturnTypeForCallable", "Lorg/jetbrains/annotations/NotNull;", "getSuperCallExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "hasUnknownFunctionParameter", "", "hasUnknownReturnType", "isConventionCall", "isInfixCall", "isInvokeCallOnExpressionWithBothReceivers", "isInvokeCallOnVariable", "isOrOverridesSynthesized", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "replaceReturnTypeByUnknown", "replaceReturnTypeForCallable", "given", "replaceTypeArguments", "Lorg/jetbrains/kotlin/types/KotlinTypeImpl;", "newArguments", "hasInferredReturnType", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "hasReturnTypeDependentOnUninferredParams", "frontend"})
public final class CallResolverUtilKt {
    public static final boolean hasUnknownFunctionParameter(@NotNull KotlinType type2) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
            boolean bl2 = ReflectionTypes.Companion.isCallableType(type2);
            if (_Assertions.ENABLED && !bl2) {
                String string = "type " + type2 + " is not a function or property";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable $receiver$iv = CallResolverUtilKt.getParameterArgumentsOfCallableType(type2);
            for (Object element$iv : $receiver$iv) {
                TypeProjection it = (TypeProjection)element$iv;
                if (!(TypeUtilsKt.contains(it.getType(), (Function1<? super KotlinType, Boolean>)((Function1)hasUnknownFunctionParameter.2.1.INSTANCE)) || ErrorUtils.containsUninferredParameter(it.getType()))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasUnknownReturnType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        boolean bl = ReflectionTypes.Companion.isCallableType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return ErrorUtils.containsErrorType(CallResolverUtilKt.getReturnTypeForCallable(type2));
    }

    @NotNull
    public static final KotlinType replaceReturnTypeForCallable(@NotNull KotlinType type2, @NotNull KotlinType given) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)given, (String)"given");
        boolean bl = ReflectionTypes.Companion.isCallableType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList newArguments = Lists.newArrayList();
        newArguments.addAll((Collection)CallResolverUtilKt.getParameterArgumentsOfCallableType(type2));
        newArguments.add(new TypeProjectionImpl(Variance.INVARIANT, given));
        List list2 = newArguments;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"newArguments");
        return CallResolverUtilKt.replaceTypeArguments(type2, list2);
    }

    @NotNull
    public static final KotlinType replaceReturnTypeByUnknown(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        KotlinType kotlinType = TypeUtils.DONT_CARE;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"DONT_CARE");
        return CallResolverUtilKt.replaceReturnTypeForCallable(type2, kotlinType);
    }

    private static final KotlinTypeImpl replaceTypeArguments(KotlinType type2, List<? extends TypeProjection> newArguments) {
        Annotations annotations2 = type2.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull((Object)annotations2, (String)"type.annotations");
        TypeConstructor typeConstructor2 = type2.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"type.constructor");
        boolean bl = type2.isMarkedNullable();
        MemberScope memberScope2 = type2.getMemberScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)memberScope2, (String)"type.memberScope");
        return KotlinTypeImpl.Companion.create(annotations2, typeConstructor2, bl, newArguments, memberScope2);
    }

    private static final List<TypeProjection> getParameterArgumentsOfCallableType(KotlinType type2) {
        return CollectionsKt.dropLast(type2.getArguments(), (int)1);
    }

    @NotNull
    public static final KotlinType getReturnTypeForCallable(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return ((TypeProjection)CollectionsKt.last(type2.getArguments())).getType();
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasReturnTypeDependentOnUninferredParams(@NotNull CallableDescriptor $receiver, ConstraintSystem constraintSystem) {
        boolean bl;
        block2: {
            void $receiver$iv;
            KotlinType returnType2;
            KotlinType kotlinType = $receiver.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType kotlinType2 = returnType2 = kotlinType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"returnType");
            List<TypeVariable> nestedTypeVariables = ConstraintSystemUtilsKt.getNestedTypeVariables(constraintSystem, kotlinType2);
            Iterable iterable = nestedTypeVariables;
            for (Object element$iv : $receiver$iv) {
                TypeVariable it = (TypeVariable)element$iv;
                if (!(constraintSystem.getTypeBounds(it).getValue() == null)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasInferredReturnType(@NotNull CallableDescriptor $receiver, @NotNull ConstraintSystem constraintSystem) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)constraintSystem, (String)"constraintSystem");
        if (CallResolverUtilKt.hasReturnTypeDependentOnUninferredParams($receiver, constraintSystem)) {
            return false;
        }
        return !constraintSystem.getStatus().hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION);
    }

    @NotNull
    public static final KotlinType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)receiverParameterDescriptor, (String)"receiverParameterDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        KotlinType receiverType = receiverParameterDescriptor.getType();
        for (TypeParameterDescriptor typeParameter : descriptor2.getTypeParameters()) {
            if (!Intrinsics.areEqual((Object)typeParameter.getTypeConstructor(), (Object)receiverType.getConstructor())) continue;
            receiverType = TypeIntersector.getUpperBoundsAsType(typeParameter);
        }
        List fakeTypeArguments = ContainerUtil.newSmartList();
        for (TypeProjection typeProjection : receiverType.getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        Annotations annotations2 = receiverType.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull((Object)annotations2, (String)"receiverType.annotations");
        TypeConstructor typeConstructor2 = receiverType.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"receiverType.constructor");
        boolean bl = receiverType.isMarkedNullable();
        List list2 = fakeTypeArguments;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"fakeTypeArguments");
        MemberScope memberScope2 = ErrorUtils.createErrorScope("Error scope for erased receiver type", true);
        Intrinsics.checkExpressionValueIsNotNull((Object)memberScope2, (String)"ErrorUtils.createErrorSc\u2026/*throwExceptions=*/true)");
        return KotlinTypeImpl.Companion.create(annotations2, typeConstructor2, bl, list2, memberScope2);
    }

    public static final boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (Intrinsics.areEqual((Object)((Object)descriptor2.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.SYNTHESIZED))) {
            return true;
        }
        if (Intrinsics.areEqual((Object)((Object)descriptor2.getKind()), (Object)((Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE))) {
            boolean bl;
            block3: {
                Iterable $receiver$iv = descriptor2.getOverriddenDescriptors();
                for (Object element$iv : $receiver$iv) {
                    CallableMemberDescriptor it;
                    CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"it");
                    if (CallResolverUtilKt.isOrOverridesSynthesized(callableMemberDescriptor)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static final boolean isConventionCall(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        if (call instanceof CallTransformer.CallForImplicitInvoke) {
            return true;
        }
        KtElement callElement2 = call.getCallElement();
        if (callElement2 instanceof KtArrayAccessExpression || callElement2 instanceof KtDestructuringDeclarationEntry) {
            return true;
        }
        KtExpression ktExpression = call.getCalleeExpression();
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            ktExpression = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)ktExpression;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression calleeExpression = ktOperationReferenceExpression;
        return KtOperationReferenceExpression.getNameForConventionalOperation$default(calleeExpression, false, false, 3, null) != null;
    }

    public static final boolean isInfixCall(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        KtExpression ktExpression = call.getCalleeExpression();
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            ktExpression = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)ktExpression;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression operationRefExpression = ktOperationReferenceExpression;
        PsiElement psiElement = operationRefExpression.getParent();
        if (!(psiElement instanceof KtBinaryExpression)) {
            psiElement = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        return binaryExpression.getOperationReference() == operationRefExpression && !operationRefExpression.isPredefinedOperator();
    }

    public static final boolean isInvokeCallOnVariable(@NotNull Call call) {
        ReceiverValue dispatchReceiver;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        if (call.getCallType() != Call.CallType.INVOKE) {
            return false;
        }
        ReceiverValue receiverValue = dispatchReceiver = call.getDispatchReceiver();
        if (receiverValue == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver");
        }
        KtExpression expression2 = ((ExpressionReceiver)receiverValue).getExpression();
        return expression2 instanceof KtSimpleNameExpression;
    }

    public static final boolean isInvokeCallOnExpressionWithBothReceivers(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        if (call.getCallType() != Call.CallType.INVOKE || CallResolverUtilKt.isInvokeCallOnVariable(call)) {
            return false;
        }
        return call.getExplicitReceiver() != null && call.getDispatchReceiver() != null;
    }

    @Nullable
    public static final KtSuperExpression getSuperCallExpression(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Receiver receiver = call.getExplicitReceiver();
        if (!(receiver instanceof ExpressionReceiver)) {
            receiver = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiver;
        KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        if (!(ktExpression instanceof KtSuperExpression)) {
            ktExpression = null;
        }
        return (KtSuperExpression)ktExpression;
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument2) {
        Intrinsics.checkParameterIsNotNull((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        if (argument2.getSpreadElement() != null) {
            if (parameterDescriptor.getVarargElementType() == null) {
                KotlinType kotlinType = TypeUtils.DONT_CARE;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"DONT_CARE");
                return kotlinType;
            }
            KotlinType kotlinType = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameterDescriptor.type");
            return kotlinType;
        }
        KotlinType varargElementType = parameterDescriptor.getVarargElementType();
        if (varargElementType != null) {
            return varargElementType;
        }
        KotlinType kotlinType = parameterDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameterDescriptor.type");
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<ResolutionCandidate<ConstructorDescriptor>> createResolutionCandidatesForConstructors(@NotNull LexicalScope lexicalScope, @NotNull Call call, @NotNull ClassDescriptor classWithConstructors, @Nullable TypeSubstitutor knownSubstitutor) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        ReceiverValue dispatchReceiver;
        ExplicitReceiverKind receiverKind;
        Object receiver;
        Object substitutedOuterClassType;
        Object outerClassType;
        Collection<ConstructorDescriptor> constructors2;
        block13: {
            block10: {
                Object v3;
                block9: {
                    void $receiver$iv2;
                    Object it;
                    Object object;
                    block12: {
                        block11: {
                            Annotated annotated;
                            Intrinsics.checkParameterIsNotNull((Object)lexicalScope, (String)"lexicalScope");
                            Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                            Intrinsics.checkParameterIsNotNull((Object)classWithConstructors, (String)"classWithConstructors");
                            constructors2 = classWithConstructors.getConstructors();
                            if (constructors2.isEmpty()) {
                                return CollectionsKt.emptyList();
                            }
                            if (!classWithConstructors.isInner()) break block10;
                            DeclarationDescriptor declarationDescriptor = classWithConstructors.getContainingDeclaration();
                            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                                declarationDescriptor = null;
                            }
                            if ((annotated = (ClassDescriptor)declarationDescriptor) == null || (annotated = annotated.getDefaultType()) == null) {
                                return CollectionsKt.emptyList();
                            }
                            outerClassType = annotated;
                            object = knownSubstitutor;
                            if (object == null) break block11;
                            TypeSubstitutor typeSubstitutor2 = object;
                            it = typeSubstitutor2;
                            object = ((TypeSubstitutor)it).substitute((KotlinType)outerClassType, Variance.INVARIANT);
                            if (object != null) break block12;
                        }
                        object = outerClassType;
                    }
                    substitutedOuterClassType = object;
                    it = ScopeUtilsKt.getImplicitReceiversHierarchy(lexicalScope);
                    for (Object element$iv : $receiver$iv2) {
                        ReceiverParameterDescriptor it2 = (ReceiverParameterDescriptor)element$iv;
                        if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(it2.getType(), (KotlinType)substitutedOuterClassType)) continue;
                        v3 = element$iv;
                        break block9;
                    }
                    v3 = null;
                }
                ReceiverParameterDescriptor receiverParameterDescriptor = v3;
                if (receiverParameterDescriptor == null) {
                    return CollectionsKt.emptyList();
                }
                receiver = receiverParameterDescriptor;
                receiverKind = ExplicitReceiverKind.DISPATCH_RECEIVER;
                dispatchReceiver = receiver.getValue();
                break block13;
            }
            receiverKind = ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
            dispatchReceiver = null;
        }
        outerClassType = constructors2;
        substitutedOuterClassType = $receiver$iv;
        receiver = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Object element$iv;
            element$iv = (ConstructorDescriptor)item$iv$iv;
            void var16_14 = destination$iv$iv;
            ResolutionCandidate<CallableDescriptor> resolutionCandidate = ResolutionCandidate.create(call, (CallableDescriptor)it, dispatchReceiver, receiverKind, knownSubstitutor);
            var16_14.add(resolutionCandidate);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Collection createResolutionCandidatesForConstructors$default(LexicalScope lexicalScope, Call call, ClassDescriptor classDescriptor, TypeSubstitutor typeSubstitutor2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createResolutionCandidatesForConstructors");
        }
        if ((n & 8) != 0) {
            typeSubstitutor2 = null;
        }
        return CallResolverUtilKt.createResolutionCandidatesForConstructors(lexicalScope, call, classDescriptor, typeSubstitutor2);
    }
}

