/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.renderers;

import com.android.tools.idea.editors.gfxtrace.widgets.CellWidget;
import com.android.tools.idea.editors.gfxtrace.widgets.Repaintable;
import com.android.tools.idea.editors.gfxtrace.widgets.Repaintables;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class CellRenderer<T extends CellWidget.Data>
implements ListCellRenderer {
    @NotNull
    private final CellLoader<T> myCellLoader;
    @NotNull
    private final T myNullCell;

    public CellRenderer(CellLoader<T> loader) {
        this.myCellLoader = loader;
        this.myNullCell = this.createNullCell();
    }

    protected abstract T createNullCell();

    public Component getListCellRendererComponent(final @NotNull JList list, Object data, int index, boolean isSelected, boolean cellHasFocus) {
        Object cell;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/editors/gfxtrace/renderers/CellRenderer", "getListCellRendererComponent"));
        }
        if (data != null) {
            assert (data instanceof CellWidget.Data);
            cell = (CellWidget.Data)data;
        } else {
            cell = this.myNullCell;
        }
        if (((CellWidget.Data)cell).requiresLoading()) {
            this.myCellLoader.loadCell(cell, new Runnable((CellWidget.Data)cell){
                final /* synthetic */ CellWidget.Data val$cell;
                {
                    this.val$cell = data;
                }

                @Override
                public void run() {
                    CellRenderer.this.onCellLoaded(list, this.val$cell);
                }
            });
        }
        ((CellWidget.Data)cell).isSelected = isSelected;
        return this.getRendererComponent(list, cell);
    }

    protected Repaintable getRepaintable(JList list) {
        return Repaintables.forComponent(list);
    }

    protected void onCellLoaded(JList list, T cell) {
    }

    protected abstract Component getRendererComponent(@NotNull JList var1, @NotNull T var2);

    public abstract Dimension getInitialCellSize();

    public static interface CellLoader<T extends CellWidget.Data> {
        public void loadCell(T var1, Runnable var2);
    }
}

