/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.java;

import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageLevelUtil {
    @Nullable
    public static LanguageLevel parseFromGradleString(@NotNull String gradleString) {
        if (gradleString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleString", "com/android/tools/idea/gradle/dsl/parser/java/LanguageLevelUtil", "parseFromGradleString"));
        }
        String digitalVersion = gradleString.startsWith("JavaVersion.VERSION_") ? gradleString.substring("JavaVersion.VERSION_".length()).replace('_', '.') : (gradleString.startsWith("VERSION_") ? gradleString.substring("VERSION_".length()).replace('_', '.') : (gradleString.startsWith("'") || gradleString.startsWith("\"") ? gradleString.substring(1, gradleString.length() - 1) : gradleString));
        return LanguageLevel.parse((String)digitalVersion);
    }

    @NotNull
    public static String convertToGradleString(@NotNull LanguageLevel languageLevel, @Nullable String sampleGradleString) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/android/tools/idea/gradle/dsl/parser/java/LanguageLevelUtil", "convertToGradleString"));
        }
        String underscoreVersion = languageLevel.name().substring("JDK_".length());
        String dotVersion = underscoreVersion.replace('_', '.');
        if (sampleGradleString != null) {
            if (sampleGradleString.startsWith("JavaVersion.VERSION_")) {
                String string = "JavaVersion.VERSION_" + underscoreVersion;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/java/LanguageLevelUtil", "convertToGradleString"));
                }
                return string;
            }
            if (sampleGradleString.startsWith("VERSION_")) {
                String string = "VERSION_" + underscoreVersion;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/java/LanguageLevelUtil", "convertToGradleString"));
                }
                return string;
            }
            if (sampleGradleString.startsWith("'")) {
                String string = "'" + dotVersion + "'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/java/LanguageLevelUtil", "convertToGradleString"));
                }
                return string;
            }
            if (sampleGradleString.startsWith("\"")) {
                String string = "\"" + dotVersion + "\"";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/java/LanguageLevelUtil", "convertToGradleString"));
                }
                return string;
            }
        }
        String string = dotVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/java/LanguageLevelUtil", "convertToGradleString"));
        }
        return string;
    }
}

