/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.tools.idea.npw.assetstudio.icon.AndroidActionBarIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidLauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidNotificationIconGenerator;
import org.jetbrains.annotations.NotNull;

public enum AndroidIconType {
    LAUNCHER("Launcher Icons", "ic_launcher"),
    ACTIONBAR("Action Bar and Tab Icons", "ic_action_%s"),
    NOTIFICATION("Notification Icons", "ic_stat_%s");

    @NotNull
    private final String myDisplayName;
    @NotNull
    private final String myDefaultNameFormat;

    private AndroidIconType(String displayName, String defaultNameFormat) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconType", "<init>"));
        }
        if (defaultNameFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultNameFormat", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconType", "<init>"));
        }
        this.myDisplayName = displayName;
        this.myDefaultNameFormat = defaultNameFormat;
    }

    @NotNull
    public static AndroidIconGenerator createIconGenerator(@NotNull AndroidIconType iconType) {
        if (iconType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconType", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconType", "createIconGenerator"));
        }
        switch (iconType) {
            case LAUNCHER: {
                AndroidLauncherIconGenerator androidLauncherIconGenerator = new AndroidLauncherIconGenerator();
                if (androidLauncherIconGenerator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconType", "createIconGenerator"));
                }
                return androidLauncherIconGenerator;
            }
            case ACTIONBAR: {
                AndroidActionBarIconGenerator androidActionBarIconGenerator = new AndroidActionBarIconGenerator();
                if (androidActionBarIconGenerator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconType", "createIconGenerator"));
                }
                return androidActionBarIconGenerator;
            }
            case NOTIFICATION: {
                AndroidNotificationIconGenerator androidNotificationIconGenerator = new AndroidNotificationIconGenerator();
                if (androidNotificationIconGenerator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconType", "createIconGenerator"));
                }
                return androidNotificationIconGenerator;
            }
        }
        throw new IllegalArgumentException("Can't create generator for unexpected icon type: " + (Object)((Object)iconType));
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconType", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String toOutputName(@NotNull String baseName) {
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconType", "toOutputName"));
        }
        String string = String.format(this.myDefaultNameFormat, baseName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconType", "toOutputName"));
        }
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/icon/AndroidIconType", "toString"));
        }
        return string;
    }
}

