/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.builder.model.SourceProvider;
import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.ui.FileTreeCellRenderer;
import com.android.tools.idea.ui.FileTreeModel;
import com.android.tools.idea.ui.properties.ListenerManager;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.ObservableBool;
import com.android.tools.idea.ui.properties.expressions.value.AsValueExpression;
import com.android.tools.idea.ui.properties.swing.SelectedItemProperty;
import com.android.tools.idea.ui.validation.Validator;
import com.android.tools.idea.ui.validation.ValidatorPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.primitives.Ints;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class ConfirmGenerateIconsStep
extends ModelWizardStep<GenerateIconsModel> {
    private static final DefaultTreeModel EMPTY_MODEL = new DefaultTreeModel(null);
    private static final int MAX_TREE_ROW_HEIGHT = 200;
    private final ValidatorPanel myValidatorPanel;
    private final ListenerManager myListeners;
    private JPanel myRootPanel;
    private JComboBox myPathsComboBox;
    private Tree myOutputPreviewTree;
    private ObservableValue<AndroidProjectPaths> mySelectedPaths;
    private BoolProperty myFilesAlreadyExist;

    public ConfirmGenerateIconsStep(@NotNull GenerateIconsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateIconsStep", "<init>"));
        }
        super(model, "Confirm Icon Path");
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myFilesAlreadyExist = new BoolValueProperty();
        this.myValidatorPanel = new ValidatorPanel(this, this.myRootPanel);
        AndroidFacet facet = model.getFacet();
        List<SourceProvider> sourceProviders = AndroidProjectPaths.getSourceProviders(facet, null);
        DefaultComboBoxModel<AndroidProjectPaths> pathsModel = new DefaultComboBoxModel<AndroidProjectPaths>();
        for (SourceProvider sourceProvider : sourceProviders) {
            pathsModel.addElement(new AndroidProjectPaths(facet, sourceProvider));
        }
        this.myPathsComboBox.setRenderer(new ListCellRendererWrapper<AndroidProjectPaths>(){

            public void customize(JList list, AndroidProjectPaths paths, int index, boolean selected, boolean hasFocus) {
                File moduleRoot = paths.getModuleRoot();
                File resDir = paths.getResDirectory();
                this.setText(FileUtil.getRelativePath((File)moduleRoot, (File)resDir));
            }
        });
        this.myPathsComboBox.setModel(pathsModel);
        this.myOutputPreviewTree.setModel((TreeModel)EMPTY_MODEL);
        this.myOutputPreviewTree.setCellRenderer((TreeCellRenderer)((Object)new FileTreeCellRenderer()));
        this.myOutputPreviewTree.setBorder(BorderFactory.createLineBorder(UIUtil.getBoundsColor()));
        this.myOutputPreviewTree.setRowHeight(-1);
        this.myOutputPreviewTree.getEmptyText().setText("No resource folder defined in project");
        this.myValidatorPanel.registerValidator(this.myFilesAlreadyExist, new Validator<Boolean>(){

            @Override
            @NotNull
            public Validator.Result validate(@NotNull Boolean filesAlreadyExist) {
                if (filesAlreadyExist == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesAlreadyExist", "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateIconsStep$2", "validate"));
                }
                if (filesAlreadyExist.booleanValue()) {
                    Validator.Result result = new Validator.Result(Validator.Severity.WARNING, WizardUtils.toHtmlString("Some existing files will be overwritten by this operation.<br>Files which replace existing files are marked red in the preview above."));
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateIconsStep$2", "validate"));
                    }
                    return result;
                }
                Validator.Result result = Validator.Result.OK;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateIconsStep$2", "validate"));
                }
                return result;
            }
        });
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        ValidatorPanel validatorPanel = this.myValidatorPanel;
        if (validatorPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateIconsStep", "getComponent"));
        }
        return validatorPanel;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizard", "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateIconsStep", "onWizardStarting"));
        }
        this.mySelectedPaths = new AsValueExpression<AndroidProjectPaths>(new SelectedItemProperty(this.myPathsComboBox));
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/wizard/ConfirmGenerateIconsStep", "canGoForward"));
        }
        return observableBool;
    }

    @Override
    protected void onProceeding() {
        ((GenerateIconsModel)this.getModel()).setPaths(this.mySelectedPaths.get());
    }

    @Override
    protected void onEntering() {
        this.myListeners.release(this.mySelectedPaths);
        this.myListeners.listenAndFire(this.mySelectedPaths, new Consumer<AndroidProjectPaths>(){

            public void consume(AndroidProjectPaths paths) {
                AndroidIconGenerator iconGenerator = ((GenerateIconsModel)ConfirmGenerateIconsStep.this.getModel()).getIconGenerator();
                File resDir = paths.getResDirectory();
                if (iconGenerator == null || resDir == null || resDir.getParentFile() == null) {
                    return;
                }
                final Map<File, BufferedImage> pathIconMap = iconGenerator.generateIntoFileMap(paths);
                ConfirmGenerateIconsStep.this.myFilesAlreadyExist.set(false);
                int minHeight = Integer.MAX_VALUE;
                int maxHeight = Integer.MIN_VALUE;
                for (BufferedImage image : pathIconMap.values()) {
                    minHeight = Math.min(minHeight, image.getHeight());
                    maxHeight = Math.max(maxHeight, image.getHeight());
                }
                ImmutableSortedSet.Builder sortedPaths = ImmutableSortedSet.orderedBy((Comparator)new Comparator<File>(){

                    @Override
                    public int compare(File file1, File file2) {
                        String path1 = file1.getAbsolutePath();
                        String path2 = file2.getAbsolutePath();
                        Density density1 = CategoryIconMap.pathToDensity(path1);
                        Density density2 = CategoryIconMap.pathToDensity(path2);
                        if (density1 != null && density2 != null && density1 != density2) {
                            return Ints.compare((int)density2.ordinal(), (int)density1.ordinal());
                        }
                        BufferedImage image1 = (BufferedImage)pathIconMap.get(file1);
                        BufferedImage image2 = (BufferedImage)pathIconMap.get(file2);
                        int compareValue = Ints.compare((int)image2.getHeight(), (int)image1.getHeight());
                        return compareValue != 0 ? compareValue : path2.compareTo(path1);
                    }
                });
                sortedPaths.addAll(pathIconMap.keySet());
                FileTreeModel treeModel = new FileTreeModel(resDir.getParentFile(), true);
                for (File path : sortedPaths.build()) {
                    Image image = pathIconMap.get(path);
                    if (path.exists()) {
                        ConfirmGenerateIconsStep.this.myFilesAlreadyExist.set(true);
                    }
                    if (maxHeight > 200) {
                        int hCurr = image.getHeight(null);
                        int wCurr = image.getWidth(null);
                        double hCurrPercent = (double)(hCurr - minHeight) / (double)(maxHeight - minHeight);
                        double scaledDeltaH = hCurrPercent * (double)(200 - minHeight);
                        double hCurrScaled = (double)minHeight + scaledDeltaH;
                        double hScale = hCurrScaled / (double)hCurr;
                        int hFinal = (int)((double)hCurr * hScale);
                        int wFinal = (int)((double)wCurr * hScale);
                        image = image.getScaledInstance(wFinal, hFinal, 4);
                    }
                    treeModel.forceAddFile(path, new ImageIcon(image));
                }
                ConfirmGenerateIconsStep.this.myOutputPreviewTree.setModel((TreeModel)treeModel);
                for (int i = 0; i < ConfirmGenerateIconsStep.this.myOutputPreviewTree.getRowCount(); ++i) {
                    ConfirmGenerateIconsStep.this.myOutputPreviewTree.expandRow(i);
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.myListeners.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        Tree tree;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Res Directory:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Output Directories:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myPathsComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myOutputPreviewTree = tree = new Tree();
        tree.setToolTipText("A preview rendering of the output tree");
        tree.setOpaque(false);
        jBScrollPane.setViewportView((Component)tree);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

