/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DevicePickerStateService;
import com.android.tools.idea.run.DeviceStateAtLaunch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class ManualTargetChooser {
    @NotNull
    public static Collection<IDevice> getLastUsedDevices(@NotNull Project project, int runConfigId, @NotNull DeviceCount deviceCount) {
        Collection<IDevice> usedDevices;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/ManualTargetChooser", "getLastUsedDevices"));
        }
        if (deviceCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/android/tools/idea/run/ManualTargetChooser", "getLastUsedDevices"));
        }
        DeviceStateAtLaunch devicesToReuse = DevicePickerStateService.getInstance(project).getDevicesUsedInLastLaunch(runConfigId);
        if (devicesToReuse == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ManualTargetChooser", "getLastUsedDevices"));
            }
            return immutableList;
        }
        Set<IDevice> onlineDevices = ManualTargetChooser.getOnlineDevices(project);
        if (devicesToReuse.matchesCurrentAvailableDevices(onlineDevices) && ((usedDevices = devicesToReuse.filterByUsed(onlineDevices)).size() == 1 || deviceCount.isMultiple())) {
            Collection<IDevice> collection = usedDevices;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ManualTargetChooser", "getLastUsedDevices"));
            }
            return collection;
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ManualTargetChooser", "getLastUsedDevices"));
        }
        return immutableList;
    }

    public static Set<IDevice> getOnlineDevices(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/ManualTargetChooser", "getOnlineDevices"));
        }
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(project);
        if (debugBridge == null) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])debugBridge.getDevices());
    }
}

