/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.fd.client.InstantRunPushFailedException;
import com.android.tools.fd.client.UpdateMode;
import com.android.tools.idea.fd.InstantRunGradleUtils;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class HotSwapTask
implements LaunchTask {
    private final AndroidFacet myFacet;
    private final ExecutionEnvironment myEnv;
    private boolean myNeedsActivityLaunch;

    public HotSwapTask(@NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/tasks/HotSwapTask", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/tasks/HotSwapTask", "<init>"));
        }
        this.myEnv = env;
        this.myFacet = facet;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Hotswapping changes" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/tasks/HotSwapTask", "getDescription"));
        }
        return "Hotswapping changes";
    }

    @Override
    public int getDuration() {
        return 8;
    }

    @Override
    public boolean perform(final @NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/tasks/HotSwapTask", "perform"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/idea/run/tasks/HotSwapTask", "perform"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/tasks/HotSwapTask", "perform"));
        }
        printer.stdout("Hotswapping changes...");
        InstantRunManager manager = InstantRunManager.get(this.myFacet.getModule().getProject());
        AndroidGradleModel model = AndroidGradleModel.get(this.myFacet);
        assert (model != null);
        InstantRunBuildInfo buildInfo = InstantRunGradleUtils.getBuildInfo(model);
        assert (buildInfo != null);
        try {
            this.myNeedsActivityLaunch = manager.pushArtifacts(device, this.myFacet, UpdateMode.HOT_SWAP, buildInfo);
        }
        catch (InstantRunPushFailedException e) {
            launchStatus.terminateLaunch("Restarting launch, Error installing hot swap patches: " + (Object)((Object)e));
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    InstantRunUtils.setRestartSession(HotSwapTask.this.myEnv, device);
                    ExecutionUtil.restart((ExecutionEnvironment)HotSwapTask.this.myEnv);
                }
            });
            return true;
        }
        InstantRunStatsService.get(this.myEnv.getProject()).notifyDeployType(InstantRunStatsService.DeployType.HOTSWAP);
        return true;
    }

    public boolean needsActivityLaunch() {
        return this.myNeedsActivityLaunch;
    }
}

