/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ListCellRendererWrapper;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidModulesComboBox
extends JComboBox {
    public AndroidModulesComboBox() {
        this.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof Module) {
                    Module module = (Module)value;
                    this.setText(module.getName());
                    this.setIcon(ModuleType.get((Module)module).getIcon());
                } else {
                    this.setText("<html><font color='red'>[none]</font></html>");
                }
            }
        });
    }

    public void init(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/newProject/AndroidModulesComboBox", "init"));
        }
        Module[] modules = AndroidModulesComboBox.getModulesWithAndroidFacet(project);
        this.setModel(new DefaultComboBoxModel<Module>(modules));
    }

    public Module getModule() {
        return (Module)this.getSelectedItem();
    }

    private static Module[] getModulesWithAndroidFacet(Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module[] modules = moduleManager.getModules();
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : modules) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || facet.isLibraryProject()) continue;
            result.add(module);
        }
        return result.toArray(new Module[result.size()]);
    }
}

