/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.run;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;
import org.intellij.lang.xpath.xslt.run.XsltRunConfiguration;
import org.intellij.lang.xpath.xslt.run.XsltRunnerExtension;
import org.jetbrains.annotations.NotNull;

public class XsltCommandLineState
extends CommandLineState {
    private static final Logger LOG = Logger.getInstance((String)XsltCommandLineState.class.getName());
    public static final Key<XsltCommandLineState> STATE = Key.create((String)"STATE");
    private final XsltRunConfiguration myXsltRunConfiguration;
    private final boolean myIsDebugger;
    private int myPort;
    private UserDataHolder myExtensionData;

    public XsltCommandLineState(XsltRunConfiguration xsltRunConfiguration, ExecutionEnvironment environment) {
        super(environment);
        this.myXsltRunConfiguration = xsltRunConfiguration;
        this.myIsDebugger = "Debug".equals(environment.getExecutor().getId());
    }

    public boolean isDebugger() {
        return this.myIsDebugger;
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler osProcessHandler = this.createJavaParameters().createOSProcessHandler();
        osProcessHandler.putUserData(STATE, (Object)this);
        osProcessHandler.addProcessListener((ProcessListener)new MyProcessAdapter());
        List<XsltRunnerExtension> extensions = XsltRunnerExtension.getExtensions(this.myXsltRunConfiguration, this.myIsDebugger);
        for (XsltRunnerExtension extension : extensions) {
            osProcessHandler.addProcessListener(extension.createProcessListener(this.myXsltRunConfiguration.getProject(), this.myExtensionData));
        }
        OSProcessHandler oSProcessHandler = osProcessHandler;
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/run/XsltCommandLineState", "startProcess"));
        }
        return oSProcessHandler;
    }

    protected SimpleJavaParameters createJavaParameters() throws ExecutionException {
        File pluginPath;
        Module module;
        Sdk jdk = this.myXsltRunConfiguration.getEffectiveJDK();
        if (jdk == null) {
            throw CantRunException.noJdkConfigured();
        }
        SimpleJavaParameters parameters = new SimpleJavaParameters();
        parameters.setJdk(jdk);
        if (this.myXsltRunConfiguration.getJdkChoice() == XsltRunConfiguration.JdkChoice.FROM_MODULE && (module = this.myXsltRunConfiguration.getEffectiveModule()) != null) {
            OrderEnumerator.orderEntries((Module)module).productionOnly().recursively().classes().collectPaths(parameters.getClassPath());
        }
        ParametersList vmParameters = parameters.getVMParametersList();
        vmParameters.addParametersString(this.myXsltRunConfiguration.myVmArguments);
        if (XsltRunConfiguration.isEmpty(this.myXsltRunConfiguration.getXsltFile())) {
            throw new CantRunException("No XSLT file selected");
        }
        vmParameters.defineProperty("xslt.file", this.myXsltRunConfiguration.getXsltFile());
        if (XsltRunConfiguration.isEmpty(this.myXsltRunConfiguration.getXmlInputFile())) {
            throw new CantRunException("No XML input file selected");
        }
        vmParameters.defineProperty("xslt.input", this.myXsltRunConfiguration.getXmlInputFile());
        XsltRunConfiguration.OutputType outputType = this.myXsltRunConfiguration.getOutputType();
        if (outputType == XsltRunConfiguration.OutputType.CONSOLE) {
            this.myPort = NetUtils.tryToFindAvailableSocketPort((int)this.myXsltRunConfiguration.myRunnerPort);
            vmParameters.defineProperty("xslt.listen-port", String.valueOf(this.myPort));
        }
        if (this.myXsltRunConfiguration.isSaveToFile()) {
            vmParameters.defineProperty("xslt.output", this.myXsltRunConfiguration.myOutputFile);
        }
        for (Pair<String, String> pair : this.myXsltRunConfiguration.getParameters()) {
            String name = (String)pair.getFirst();
            String value = (String)pair.getSecond();
            if (XsltRunConfiguration.isEmpty(name) || value == null) continue;
            vmParameters.defineProperty("xslt.param." + name, value);
        }
        vmParameters.defineProperty("xslt.smart-error-handling", String.valueOf(this.myXsltRunConfiguration.mySmartErrorHandling));
        PluginId pluginId = PluginManagerCore.getPluginByClassName((String)((Object)((Object)this)).getClass().getName());
        assert (pluginId != null || System.getProperty("xslt.plugin.path") != null) : "PluginId not found - development builds need to specify -Dxslt.plugin.path=../out/classes/production/xslt-rt";
        if (pluginId != null) {
            IdeaPluginDescriptor descriptor = PluginManager.getPlugin((PluginId)pluginId);
            assert (descriptor != null);
            pluginPath = descriptor.getPath();
        } else {
            pluginPath = new File(System.getProperty("xslt.plugin.path"));
        }
        LOG.debug("Plugin Path = " + pluginPath.getAbsolutePath());
        char c = File.separatorChar;
        File rtClasspath = new File(pluginPath, "lib" + c + "rt" + c + "xslt-rt.jar");
        if (!rtClasspath.exists()) {
            LOG.warn("Plugin's Runtime classes not found in " + rtClasspath.getAbsolutePath());
            rtClasspath = new File(pluginPath, "classes");
            if (!rtClasspath.exists()) {
                if (ApplicationManagerEx.getApplicationEx().isInternal() && new File(pluginPath, "org").exists()) {
                    rtClasspath = pluginPath;
                } else {
                    throw new CantRunException("Runtime classes not found");
                }
            }
            parameters.getVMParametersList().prepend("-ea");
        }
        parameters.getClassPath().addTail(rtClasspath.getAbsolutePath());
        parameters.setMainClass("org.intellij.plugins.xslt.run.rt.XSLTRunner");
        if (XsltRunConfiguration.isEmpty(this.myXsltRunConfiguration.myWorkingDirectory)) {
            parameters.setWorkingDirectory(new File(this.myXsltRunConfiguration.getXsltFile()).getParentFile().getAbsolutePath());
        } else {
            parameters.setWorkingDirectory(XsltCommandLineState.expandPath(this.myXsltRunConfiguration.myWorkingDirectory, this.myXsltRunConfiguration.getEffectiveModule(), this.myXsltRunConfiguration.getProject()));
        }
        this.myExtensionData = new UserDataHolderBase();
        List<XsltRunnerExtension> extensions = XsltRunnerExtension.getExtensions(this.myXsltRunConfiguration, this.myIsDebugger);
        for (XsltRunnerExtension extension : extensions) {
            extension.patchParameters(parameters, this.myXsltRunConfiguration, this.myExtensionData);
        }
        parameters.setUseDynamicClasspath(JdkUtil.useDynamicClasspath((Project)this.myXsltRunConfiguration.getProject()));
        return parameters;
    }

    protected static String expandPath(String path, Module module, Project project) {
        path = PathMacroManager.getInstance((ComponentManager)project).expandPath(path);
        if (module != null) {
            path = PathMacroManager.getInstance((ComponentManager)module).expandPath(path);
        }
        return path;
    }

    public int getPort() {
        return this.myPort;
    }

    public UserDataHolder getExtensionData() {
        return this.myExtensionData;
    }

    private class MyProcessAdapter
    extends ProcessAdapter {
        private MyProcessAdapter() {
        }

        public void processTerminated(ProcessEvent event) {
            if (XsltCommandLineState.this.myXsltRunConfiguration.isSaveToFile()) {
                Runnable runnable = () -> {
                    Runnable runnable1 = () -> {
                        if (event.getExitCode() == 0) {
                            if (((XsltCommandLineState)XsltCommandLineState.this).myXsltRunConfiguration.myOpenInBrowser) {
                                BrowserUtil.browse((String)((XsltCommandLineState)XsltCommandLineState.this).myXsltRunConfiguration.myOutputFile);
                            }
                            if (((XsltCommandLineState)XsltCommandLineState.this).myXsltRunConfiguration.myOpenOutputFile) {
                                String url = VfsUtilCore.pathToUrl((String)((XsltCommandLineState)XsltCommandLineState.this).myXsltRunConfiguration.myOutputFile);
                                VirtualFile fileByUrl = VirtualFileManager.getInstance().refreshAndFindFileByUrl(url.replace(File.separatorChar, '/'));
                                if (fileByUrl != null) {
                                    fileByUrl.refresh(false, false);
                                    new OpenFileDescriptor(XsltCommandLineState.this.myXsltRunConfiguration.getProject(), fileByUrl).navigate(true);
                                    return;
                                }
                            }
                            VirtualFileManager.getInstance().asyncRefresh(null);
                        }
                    };
                    ApplicationManager.getApplication().runWriteAction(runnable1);
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }
}

