/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.reader;

import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class mxGraphViewReader
extends DefaultHandler {
    protected mxICanvas canvas;
    protected double scale = 1.0;
    protected boolean htmlLabels = false;

    public void setHtmlLabels(boolean bl) {
        this.htmlLabels = bl;
    }

    public boolean isHtmlLabels() {
        return this.htmlLabels;
    }

    public abstract mxICanvas createCanvas(Map<String, Object> var1);

    public mxICanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string3.toUpperCase();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string5 = attributes.getQName(i);
            if (string5 == null || string5.length() == 0) {
                string5 = attributes.getLocalName(i);
            }
            hashtable.put(string5, attributes.getValue(i));
        }
        this.parseElement(string4, hashtable);
    }

    public void parseElement(String string, Map<String, Object> map) {
        if (this.canvas == null && string.equalsIgnoreCase("graph")) {
            this.scale = mxUtils.getDouble(map, "scale", 1.0);
            this.canvas = this.createCanvas(map);
            if (this.canvas != null) {
                this.canvas.setScale(this.scale);
            }
        } else if (this.canvas != null) {
            boolean bl = string.equalsIgnoreCase("edge");
            boolean bl2 = string.equalsIgnoreCase("group");
            boolean bl3 = string.equalsIgnoreCase("vertex");
            if (bl && map.containsKey("points") || (bl3 || bl2) && map.containsKey("x") && map.containsKey("y") && map.containsKey("width") && map.containsKey("height")) {
                mxCellState mxCellState2 = new mxCellState(null, null, map);
                String string2 = this.parseState(mxCellState2, bl);
                this.canvas.drawCell(mxCellState2);
                this.canvas.drawLabel(string2, mxCellState2, this.isHtmlLabels());
            }
        }
    }

    public String parseState(mxCellState mxCellState2, boolean bl) {
        String string;
        Map<String, Object> map = mxCellState2.getStyle();
        mxCellState2.setX(mxUtils.getDouble(map, "x"));
        mxCellState2.setY(mxUtils.getDouble(map, "y"));
        mxCellState2.setWidth(mxUtils.getDouble(map, "width"));
        mxCellState2.setHeight(mxUtils.getDouble(map, "height"));
        List<mxPoint> list = mxGraphViewReader.parsePoints(mxUtils.getString(map, "points"));
        if (list.size() > 0) {
            mxCellState2.setAbsolutePoints(list);
        }
        if ((string = mxUtils.getString(map, "label")) != null && string.length() > 0) {
            mxPoint mxPoint2 = new mxPoint(mxUtils.getDouble(map, "dx"), mxUtils.getDouble(map, "dy"));
            mxCellState mxCellState3 = !bl ? mxCellState2 : null;
            mxCellState2.setLabelBounds(mxUtils.getLabelPaintBounds(string, mxCellState2.getStyle(), mxUtils.isTrue(map, "html", false), mxPoint2, mxCellState3, this.scale));
        }
        return string;
    }

    public static List<mxPoint> parsePoints(String string) {
        ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>();
        if (string != null) {
            int n = string.length();
            String string2 = "";
            String string3 = null;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == ',' || c == ' ') {
                    if (string3 == null) {
                        string3 = string2;
                    } else {
                        arrayList.add(new mxPoint(Double.parseDouble(string3), Double.parseDouble(string2)));
                        string3 = null;
                    }
                    string2 = "";
                    continue;
                }
                string2 = string2 + c;
            }
            arrayList.add(new mxPoint(Double.parseDouble(string3), Double.parseDouble(string2)));
        }
        return arrayList;
    }
}

