/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.compiler.rt;

import groovy.lang.GroovyResourceLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstAwareResourceLoader
implements GroovyResourceLoader {
    final Map<String, File> myClass2File;

    AstAwareResourceLoader(Map<String, File> class2File) {
        this.myClass2File = Collections.synchronizedMap(class2File);
    }

    public URL loadGroovySource(String className) throws MalformedURLException {
        if (className == null) {
            return null;
        }
        File file = this.getSourceFile(className);
        if (file != null && file.exists()) {
            return file.toURL();
        }
        file = new File(className);
        if (file.exists()) {
            return file.toURL();
        }
        return null;
    }

    File getSourceFile(String className) {
        return this.myClass2File.get(className);
    }
}

