/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.extensions;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.search.GlobalSearchScope;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public abstract class GroovyScriptTypeDetector {
    public static final ExtensionPointName<GroovyScriptTypeDetector> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.scriptTypeDetector");
    private final GroovyScriptType myScriptType;
    private final String[] myExtensions;

    protected GroovyScriptTypeDetector(GroovyScriptType scriptType, String ... extensions) {
        this.myScriptType = scriptType;
        this.myExtensions = extensions;
    }

    @NotNull
    public final String[] getExtensions() {
        if (this.myExtensions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "getExtensions"));
        }
        return this.myExtensions;
    }

    @NotNull
    public final GroovyScriptType getScriptType() {
        GroovyScriptType groovyScriptType = this.myScriptType;
        if (groovyScriptType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "getScriptType"));
        }
        return groovyScriptType;
    }

    public abstract boolean isSpecificScriptFile(@NotNull GroovyFile var1);

    @NotNull
    public static Icon getIcon(@NotNull GroovyFile script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "getIcon"));
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile(script)) continue;
            Icon icon = detector.getScriptType().getScriptIcon();
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "getIcon"));
            }
            return icon;
        }
        Icon icon = JetgroovyIcons.Groovy.Groovy_16x16;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "getIcon"));
        }
        return icon;
    }

    public static GlobalSearchScope patchResolveScope(@NotNull GroovyFile script, GlobalSearchScope scope) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "patchResolveScope"));
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile(script)) continue;
            return detector.getScriptType().patchResolveScope(script, scope);
        }
        return scope;
    }
}

