/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.execution.process.SelfKiller;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OSProcessHandler
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.process.OSProcessHandler");
    public static Key<Set<File>> DELETE_FILES_ON_TERMINATION = Key.create((String)"OSProcessHandler.FileToDelete");
    private boolean myHasErrorStream;
    private boolean myHasPty;
    private boolean myDestroyRecursively;
    private Set<File> myFilesToDelete;

    public OSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        this(commandLine.createProcess(), commandLine.getCommandLineString(), commandLine.getCharset());
        this.myHasErrorStream = !commandLine.isRedirectErrorStream();
        this.myFilesToDelete = commandLine.getUserData(DELETE_FILES_ON_TERMINATION);
    }

    @Deprecated
    public OSProcessHandler(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        this(process, null);
    }

    public OSProcessHandler(@NotNull Process process, String commandLine) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        this(process, commandLine, EncodingManager.getInstance().getDefaultCharset());
    }

    public OSProcessHandler(@NotNull Process process, String commandLine, @Nullable Charset charset) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        super(process, commandLine, charset);
        this.myHasErrorStream = true;
        this.myDestroyRecursively = true;
        this.myFilesToDelete = null;
        this.setHasPty(OSProcessHandler.isPtyProcess(process));
    }

    private static boolean isPtyProcess(Process process) {
        for (Class<?> c = process.getClass(); c != null; c = c.getSuperclass()) {
            if (!"com.pty4j.unix.UnixPtyProcess".equals(c.getName()) && !"com.pty4j.windows.WinPtyProcess".equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected Future<?> executeOnPooledThread(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/execution/process/OSProcessHandler", "executeOnPooledThread"));
        }
        Future future = super.executeOnPooledThread(task);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/OSProcessHandler", "executeOnPooledThread"));
        }
        return future;
    }

    protected void onOSProcessTerminated(int exitCode) {
        super.onOSProcessTerminated(exitCode);
        if (this.myFilesToDelete != null) {
            for (File file : this.myFilesToDelete) {
                FileUtil.delete((File)file);
            }
        }
    }

    protected boolean processHasSeparateErrorStream() {
        return this.myHasErrorStream;
    }

    protected boolean shouldDestroyProcessRecursively() {
        return this.myDestroyRecursively;
    }

    public void setShouldDestroyProcessRecursively(boolean destroyRecursively) {
        this.myDestroyRecursively = destroyRecursively;
    }

    protected void doDestroyProcess() {
        Process process = this.getProcess();
        if (this.shouldDestroyProcessRecursively() && OSProcessHandler.processCanBeKilledByOS(process)) {
            this.killProcessTree(process);
        } else {
            process.destroy();
        }
    }

    public static boolean processCanBeKilledByOS(Process process) {
        return !(process instanceof SelfKiller);
    }

    protected void killProcessTree(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "killProcessTree"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.killProcessTreeSync(process);
        } else {
            this.executeOnPooledThread(() -> {
                if (process == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "lambda$killProcessTree$0"));
                }
                this.killProcessTreeSync(process);
            });
        }
    }

    private void killProcessTreeSync(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "killProcessTreeSync"));
        }
        LOG.debug("killing process tree");
        boolean destroyed = OSProcessManager.getInstance().killProcessTree(process);
        if (!destroyed) {
            if (!process.isAlive()) {
                LOG.warn("Process has been already terminated: " + this.myCommandLine);
            } else {
                LOG.warn("Cannot kill process tree. Trying to destroy process using Java API. Cmdline:\n" + this.myCommandLine);
                process.destroy();
            }
        }
    }

    public void setHasPty(boolean hasPty) {
        this.myHasPty = hasPty;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = this.myHasPty ? BaseOutputReader.Options.BLOCKING : super.readerOptions();
        if (options == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/OSProcessHandler", "readerOptions"));
        }
        return options;
    }
}

