/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsRootSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirectoryMapping {
    public static final String PROJECT_CONSTANT = "<Project>";
    public static final VcsDirectoryMapping[] EMPTY_ARRAY = new VcsDirectoryMapping[0];
    @NotNull
    private final String myDirectory;
    private String myVcs;
    private VcsRootSettings myRootSettings;

    public VcsDirectoryMapping(@NotNull String directory, String vcs) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/openapi/vcs/VcsDirectoryMapping", "<init>"));
        }
        this(directory, vcs, null);
    }

    public VcsDirectoryMapping(@NotNull String directory, @Nullable String vcs, @Nullable VcsRootSettings rootSettings) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/openapi/vcs/VcsDirectoryMapping", "<init>"));
        }
        this.myDirectory = directory;
        this.myVcs = vcs;
        this.myRootSettings = rootSettings;
    }

    @NotNull
    public String getDirectory() {
        String string = this.myDirectory;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsDirectoryMapping", "getDirectory"));
        }
        return string;
    }

    @NotNull
    public String systemIndependentPath() {
        String string = FileUtil.toSystemIndependentName((String)this.myDirectory);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsDirectoryMapping", "systemIndependentPath"));
        }
        return string;
    }

    public String getVcs() {
        return this.myVcs;
    }

    public void setVcs(String vcs) {
        this.myVcs = vcs;
    }

    @Nullable
    public VcsRootSettings getRootSettings() {
        return this.myRootSettings;
    }

    public void setRootSettings(VcsRootSettings rootSettings) {
        this.myRootSettings = rootSettings;
    }

    public boolean isDefaultMapping() {
        return this.myDirectory.length() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsDirectoryMapping mapping = (VcsDirectoryMapping)o;
        if (!this.myDirectory.equals(mapping.myDirectory)) {
            return false;
        }
        if (this.myVcs != null ? !this.myVcs.equals(mapping.myVcs) : mapping.myVcs != null) {
            return false;
        }
        return !(this.myRootSettings != null ? !this.myRootSettings.equals(mapping.myRootSettings) : mapping.myRootSettings != null);
    }

    public int hashCode() {
        int result = this.myDirectory.hashCode();
        result = 31 * result + (this.myVcs != null ? this.myVcs.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.isDefaultMapping() ? PROJECT_CONSTANT : this.myDirectory;
    }
}

