/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnionPackageSet
extends PackageSetBase {
    private final PackageSet myFirstSet;
    private final PackageSet mySecondSet;
    private String myText;

    public UnionPackageSet(@NotNull PackageSet set1, @NotNull PackageSet set2) {
        if (set1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set1", "com/intellij/psi/search/scope/packageSet/UnionPackageSet", "<init>"));
        }
        if (set2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set2", "com/intellij/psi/search/scope/packageSet/UnionPackageSet", "<init>"));
        }
        this.myFirstSet = set1;
        this.mySecondSet = set2;
    }

    @Override
    public boolean contains(VirtualFile file, @NotNull NamedScopesHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/search/scope/packageSet/UnionPackageSet", "contains"));
        }
        return this.contains(file, holder.getProject(), holder);
    }

    @Override
    public boolean contains(VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/scope/packageSet/UnionPackageSet", "contains"));
        }
        return (!(this.myFirstSet instanceof PackageSetBase) ? this.myFirstSet.contains(UnionPackageSet.getPsiFile(file, project), holder) : ((PackageSetBase)this.myFirstSet).contains(file, project, holder)) || (this.mySecondSet instanceof PackageSetBase ? ((PackageSetBase)this.mySecondSet).contains(file, project, holder) : this.mySecondSet.contains(UnionPackageSet.getPsiFile(file, project), holder));
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        UnionPackageSet unionPackageSet = new UnionPackageSet(this.myFirstSet.createCopy(), this.mySecondSet.createCopy());
        if (unionPackageSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/UnionPackageSet", "createCopy"));
        }
        return unionPackageSet;
    }

    @Override
    public int getNodePriority() {
        return 3;
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myText == null) {
            this.myText = this.myFirstSet.getText() + "||" + this.mySecondSet.getText();
        }
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/UnionPackageSet", "getText"));
        }
        return string;
    }

    public PackageSet getFirstSet() {
        return this.myFirstSet;
    }

    public PackageSet getSecondSet() {
        return this.mySecondSet;
    }
}

