/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.switcher;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.switcher.SwitchProvider;
import com.intellij.util.Consumer;
import java.awt.Container;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QuickActionManager
implements ProjectComponent {
    private SwitchProvider myActiveProvider;

    @Override
    public void projectOpened() {
    }

    @Override
    public void projectClosed() {
    }

    @Override
    @NotNull
    public String getComponentName() {
        if ("QuickActionsManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/switcher/QuickActionManager", "getComponentName"));
        }
        return "QuickActionsManager";
    }

    @Override
    public void initComponent() {
    }

    @Override
    public void disposeComponent() {
    }

    public static QuickActionManager getInstance(Project project) {
        return project != null ? project.getComponent(QuickActionManager.class) : null;
    }

    public void showQuickActions() {
        if (this.isActive()) {
            return;
        }
        this.showActionsPopup();
    }

    private void showActionsPopup() {
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(new Consumer<DataContext>(){

            public void consume(DataContext context) {
                QuickActionProvider provider = QuickActionProvider.KEY.getData(context);
                if (provider == null) {
                    return;
                }
                List<AnAction> actions = provider.getActions(true);
                if (actions != null && actions.size() > 0) {
                    DefaultActionGroup group = new DefaultActionGroup();
                    for (AnAction each : actions) {
                        group.add(each);
                    }
                    boolean firstParent = true;
                    for (Container eachParent = provider.getComponent().getParent(); eachParent != null; eachParent = eachParent.getParent()) {
                        List<AnAction> eachActionList;
                        if (!(eachParent instanceof QuickActionProvider)) continue;
                        QuickActionProvider eachProvider = (QuickActionProvider)((Object)eachParent);
                        if (firstParent) {
                            group.addSeparator();
                            firstParent = false;
                        }
                        if ((eachActionList = eachProvider.getActions(false)).size() > 0) {
                            group.add(new Group(eachActionList, eachProvider.getName()));
                        }
                        if (eachProvider.isCycleRoot()) break;
                    }
                    JBPopupFactory.getInstance().createActionGroupPopup(null, group, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, () -> QuickActionManager.this.myActiveProvider = null, -1).showInFocusCenter();
                }
            }
        });
    }

    public boolean isActive() {
        return this.myActiveProvider != null;
    }

    private class Group
    extends DefaultActionGroup
    implements DumbAware {
        private String myTitle;

        private Group(List<AnAction> actions, String title) {
            this.setPopup(true);
            for (AnAction each : actions) {
                this.add(each);
            }
            this.myTitle = title;
        }

        @Override
        public void update(AnActionEvent e) {
            e.getPresentation().setText(this.myTitle);
        }
    }
}

