/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.vm.ModuleResourceLocator;
import com.oracle.truffle.api.vm.PolyglotEngine;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;

final class LanguageCache {
    private static final boolean PRELOAD;
    private static final Map<String, LanguageCache> CACHE;
    private TruffleLanguage<?> language;
    private final String className;
    private final Set<String> mimeTypes;
    private final String name;
    private final String version;

    private static Map<String, LanguageCache> initializeLanguages(ClassLoader loader) {
        Map<String, LanguageCache> map = LanguageCache.createLanguages(loader);
        for (LanguageCache info : map.values()) {
            info.createLanguage(loader);
        }
        return map;
    }

    private LanguageCache(String prefix, Properties info, TruffleLanguage<?> language) {
        String mt;
        this.className = info.getProperty(prefix + "className");
        this.name = info.getProperty(prefix + "name");
        this.version = info.getProperty(prefix + "version");
        TreeSet<String> ts = new TreeSet<String>();
        int i = 0;
        while ((mt = info.getProperty(prefix + "mimeType." + i)) != null) {
            ts.add(mt);
            ++i;
        }
        this.mimeTypes = Collections.unmodifiableSet(ts);
        this.language = language;
    }

    private static ClassLoader loader() {
        ClassLoader l;
        if (PolyglotEngine.JDK8OrEarlier) {
            l = PolyglotEngine.class.getClassLoader();
            if (l == null) {
                l = ClassLoader.getSystemClassLoader();
            }
        } else {
            l = ModuleResourceLocator.createLoader();
        }
        return l;
    }

    static Map<String, LanguageCache> languages() {
        if (PRELOAD) {
            return CACHE;
        }
        return LanguageCache.createLanguages(LanguageCache.loader());
    }

    private static Map<String, LanguageCache> createLanguages(ClassLoader loader) {
        Enumeration<URL> en;
        LinkedHashMap<String, LanguageCache> map = new LinkedHashMap<String, LanguageCache>();
        try {
            en = loader.getResources("META-INF/truffle/language");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot read list of Truffle languages", ex);
        }
        while (en.hasMoreElements()) {
            String prefix;
            Properties p;
            URL u = en.nextElement();
            try {
                p = new Properties();
                try (InputStream is = u.openStream();){
                    p.load(is);
                }
            }
            catch (IOException ex) {
                PolyglotEngine.LOG.log(Level.CONFIG, "Cannot process " + u + " as language definition", ex);
                continue;
            }
            int cnt = 1;
            while (p.getProperty((prefix = "language" + cnt + ".") + "name") != null) {
                LanguageCache l = new LanguageCache(prefix, p, null);
                for (String mimeType : l.getMimeTypes()) {
                    map.put(mimeType, l);
                }
                ++cnt;
            }
        }
        return map;
    }

    Set<String> getMimeTypes() {
        return this.mimeTypes;
    }

    String getName() {
        return this.name;
    }

    String getVersion() {
        return this.version;
    }

    TruffleLanguage<?> getImpl(boolean create) {
        if (PRELOAD) {
            return this.language;
        }
        if (create) {
            this.createLanguage(LanguageCache.loader());
        }
        return this.language;
    }

    private void createLanguage(ClassLoader loader) {
        try {
            TruffleLanguage result;
            Class<?> langClazz = Class.forName(this.className, true, loader);
            this.language = result = (TruffleLanguage)langClazz.getField("INSTANCE").get(null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot initialize " + this.getName() + " language with implementation " + this.className, ex);
        }
    }

    static {
        CACHE = TruffleOptions.AOT ? LanguageCache.initializeLanguages(LanguageCache.loader()) : null;
        PRELOAD = CACHE != null;
    }
}

