/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.security;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import org.parosproxy.paros.security.SslCertificateService;
import org.parosproxy.paros.security.SslCertificateServiceImpl;

public final class CachedSslCertifificateServiceImpl
implements SslCertificateService {
    private static final SslCertificateService singleton = new CachedSslCertifificateServiceImpl();
    private final SslCertificateService delegate;
    private Map<String, KeyStore> cache = new HashMap<String, KeyStore>();

    private CachedSslCertifificateServiceImpl() {
        this.delegate = SslCertificateServiceImpl.getService();
    }

    @Override
    public synchronized KeyStore createCertForHost(String string) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException, NoSuchProviderException, SignatureException, KeyStoreException, IOException, UnrecoverableKeyException {
        if (this.cache.containsKey(string)) {
            return this.cache.get(string);
        }
        KeyStore keyStore = this.delegate.createCertForHost(string);
        this.cache.put(string, keyStore);
        return keyStore;
    }

    public static SslCertificateService getService() {
        return singleton;
    }

    @Override
    public void initializeRootCA(KeyStore keyStore) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        this.delegate.initializeRootCA(keyStore);
    }
}

