/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.all.request;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.httppanel.view.util.CaretVisibilityEnforcerOnFocusGain;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.model.DefaultTextHttpMessageLocation;
import org.zaproxy.zap.model.HttpMessageLocation;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.model.TextHttpMessageLocation;
import org.zaproxy.zap.view.messagecontainer.http.SelectableContentHttpMessageContainer;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightsManager;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListener;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListenerAdapter;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlightsManager;

public class HttpRequestAllPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView
implements SelectableContentHttpMessageContainer {
    public static final String NAME = "HttpRequestSyntaxTextView";
    private MessageLocationProducerFocusListenerAdapter focusListenerAdapter;

    public HttpRequestAllPanelSyntaxHighlightTextView(RequestStringHttpPanelViewModel requestStringHttpPanelViewModel) {
        super(requestStringHttpPanelViewModel);
        this.getHttpPanelTextArea().setComponentPopupMenu(new HttpPanelSyntaxHighlightTextView.CustomPopupMenu(){
            private static final long serialVersionUID = 377256890518967680L;

            @Override
            public void show(Component component, int n, int n2) {
                if (!HttpRequestAllPanelSyntaxHighlightTextView.this.getHttpPanelTextArea().isFocusOwner()) {
                    HttpRequestAllPanelSyntaxHighlightTextView.this.getHttpPanelTextArea().requestFocusInWindow();
                }
                View.getSingleton().getPopupMenu().show(HttpRequestAllPanelSyntaxHighlightTextView.this, n, n2);
            }
        });
    }

    @Override
    protected HttpRequestAllPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpRequestAllPanelSyntaxHighlightTextArea();
    }

    @Override
    protected HttpRequestAllPanelSyntaxHighlightTextArea getHttpPanelTextArea() {
        return (HttpRequestAllPanelSyntaxHighlightTextArea)super.getHttpPanelTextArea();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<HttpMessage> getMessageClass() {
        return HttpMessage.class;
    }

    @Override
    public Class<? extends MessageLocation> getMessageLocationClass() {
        return TextHttpMessageLocation.class;
    }

    @Override
    public MessageLocation getSelection() {
        return this.getHttpPanelTextArea().getSelection();
    }

    @Override
    public MessageLocationHighlightsManager create() {
        return this.getHttpPanelTextArea().create();
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation messageLocation) {
        if (!this.supports(messageLocation)) {
            return null;
        }
        TextHttpMessageLocation textHttpMessageLocation = (TextHttpMessageLocation)messageLocation;
        return this.getHttpPanelTextArea().highlightImpl(textHttpMessageLocation, new TextMessageLocationHighlight(Color.LIGHT_GRAY));
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation messageLocation, MessageLocationHighlight messageLocationHighlight) {
        if (!this.supports(messageLocation) || !(messageLocationHighlight instanceof TextMessageLocationHighlight)) {
            return null;
        }
        TextHttpMessageLocation textHttpMessageLocation = (TextHttpMessageLocation)messageLocation;
        TextMessageLocationHighlight textMessageLocationHighlight = (TextMessageLocationHighlight)messageLocationHighlight;
        return this.getHttpPanelTextArea().highlightImpl(textHttpMessageLocation, textMessageLocationHighlight);
    }

    @Override
    public void removeHighlight(MessageLocation messageLocation, MessageLocationHighlight messageLocationHighlight) {
        if (!(messageLocationHighlight instanceof TextMessageLocationHighlight)) {
            return;
        }
        this.getHttpPanelTextArea().removeHighlight(((TextMessageLocationHighlight)messageLocationHighlight).getHighlightReference());
    }

    @Override
    public boolean supports(MessageLocation messageLocation) {
        if (!(messageLocation instanceof TextHttpMessageLocation)) {
            return false;
        }
        HttpMessageLocation.Location location = ((TextHttpMessageLocation)messageLocation).getLocation();
        return location == HttpMessageLocation.Location.REQUEST_HEADER || location == HttpMessageLocation.Location.REQUEST_BODY;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> clazz) {
        return TextHttpMessageLocation.class.isAssignableFrom(clazz);
    }

    @Override
    public void addFocusListener(MessageLocationProducerFocusListener messageLocationProducerFocusListener) {
        this.getFocusListenerAdapter().addFocusListener(messageLocationProducerFocusListener);
    }

    @Override
    public void removeFocusListener(MessageLocationProducerFocusListener messageLocationProducerFocusListener) {
        this.getFocusListenerAdapter().removeFocusListener(messageLocationProducerFocusListener);
        if (!this.getFocusListenerAdapter().hasFocusListeners()) {
            this.getHttpPanelTextArea().removeFocusListener(this.focusListenerAdapter);
            this.focusListenerAdapter = null;
        }
    }

    @Override
    public HttpMessage getMessage() {
        return this.getHttpPanelTextArea().getMessage();
    }

    @Override
    public Component getComponent() {
        return this.getHttpPanelTextArea();
    }

    @Override
    public boolean isEmpty() {
        return this.getHttpPanelTextArea().getMessage() == null;
    }

    private MessageLocationProducerFocusListenerAdapter getFocusListenerAdapter() {
        if (this.focusListenerAdapter == null) {
            this.focusListenerAdapter = new MessageLocationProducerFocusListenerAdapter(this);
            this.getHttpPanelTextArea().addFocusListener(this.focusListenerAdapter);
        }
        return this.focusListenerAdapter;
    }

    protected static class HttpRequestAllPanelSyntaxHighlightTextArea
    extends HttpPanelSyntaxHighlightTextArea {
        private static final long serialVersionUID = 923466158533211593L;
        private static final Logger log = Logger.getLogger(HttpRequestAllPanelSyntaxHighlightTextArea.class);
        private static RequestAllTokenMakerFactory tokenMakerFactory = null;
        private CaretVisibilityEnforcerOnFocusGain caretVisiblityEnforcer = new CaretVisibilityEnforcerOnFocusGain((JTextComponent)((Object)this));

        @Override
        public HttpMessage getMessage() {
            return (HttpMessage)super.getMessage();
        }

        @Override
        public void setMessage(Message message) {
            super.setMessage(message);
            this.caretVisiblityEnforcer.setEnforceVisibilityOnFocusGain(message != null);
        }

        protected MessageLocation getSelection() {
            HttpMessageLocation.Location location;
            HttpMessage httpMessage = this.getMessage();
            int n = 0;
            String string = httpMessage.getRequestHeader().toString();
            int n2 = 0;
            while ((n2 = string.indexOf("\r\n", n2)) != -1) {
                n2 += 2;
                ++n;
            }
            int n3 = this.getSelectionStart();
            int n4 = this.getSelectionEnd();
            int n5 = string.length();
            if (n3 + n < n5) {
                try {
                    n3 += this.getLineOfOffset(n3);
                }
                catch (BadLocationException badLocationException) {
                    log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                    return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_HEADER, 0);
                }
                try {
                    n4 += this.getLineOfOffset(n4);
                }
                catch (BadLocationException badLocationException) {
                    log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                    return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_HEADER, 0);
                }
                if (n4 > n5) {
                    n4 = n5;
                }
                location = HttpMessageLocation.Location.REQUEST_HEADER;
            } else {
                n3 += n - n5;
                n4 += n - n5;
                location = HttpMessageLocation.Location.REQUEST_BODY;
            }
            try {
                return new DefaultTextHttpMessageLocation(location, n3, n4, this.getText(n3, n4 - n3));
            }
            catch (BadLocationException badLocationException) {
                log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_HEADER, 0);
            }
        }

        protected MessageLocationHighlightsManager create() {
            return new TextMessageLocationHighlightsManager();
        }

        protected MessageLocationHighlight highlightImpl(TextHttpMessageLocation textHttpMessageLocation, TextMessageLocationHighlight textMessageLocationHighlight) {
            int n;
            if (this.getMessage() == null) {
                return null;
            }
            boolean bl = HttpMessageLocation.Location.REQUEST_BODY.equals((Object)textHttpMessageLocation.getLocation());
            int n2 = 0;
            String string = this.getMessage().getRequestHeader().toString();
            int n3 = 0;
            while ((n3 = string.indexOf("\r\n", n3)) != -1 && (bl || (n3 += 2) <= textHttpMessageLocation.getStart())) {
                ++n2;
            }
            int n4 = textHttpMessageLocation.getStart() - n2;
            int n5 = textHttpMessageLocation.getEnd() - n2;
            if (bl) {
                n4 += string.length();
                n5 += string.length();
            }
            if (n4 > (n = this.getText().length()) || n5 > n) {
                return null;
            }
            textMessageLocationHighlight.setHighlightReference(this.highlight(n4, n5, textMessageLocationHighlight));
            return textMessageLocationHighlight;
        }

        @Override
        public void search(Pattern pattern, List<SearchMatch> list) {
            HttpMessage httpMessage = this.getMessage();
            int n = 0;
            String string = httpMessage.getRequestHeader().toString();
            int n2 = 0;
            while ((n2 = string.indexOf("\r\n", n2)) != -1) {
                n2 += 2;
                ++n;
            }
            int n3 = string.length();
            int n4 = n - n3;
            Matcher matcher = pattern.matcher(this.getText());
            while (matcher.find()) {
                int n5 = matcher.start();
                int n6 = matcher.end();
                if (n5 + n < n3) {
                    try {
                        n5 += this.getLineOfOffset(n5);
                    }
                    catch (BadLocationException badLocationException) {
                        log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                        return;
                    }
                    try {
                        n6 += this.getLineOfOffset(n6);
                    }
                    catch (BadLocationException badLocationException) {
                        log.error((Object)badLocationException.getMessage(), (Throwable)badLocationException);
                        return;
                    }
                    if (n6 > n3) {
                        n6 = n3;
                    }
                    list.add(new SearchMatch(SearchMatch.Location.REQUEST_HEAD, n5, n6));
                    continue;
                }
                list.add(new SearchMatch(SearchMatch.Location.REQUEST_BODY, n5 += n4, n6 += n4));
            }
        }

        @Override
        public void highlight(SearchMatch searchMatch) {
            int n;
            if (!SearchMatch.Location.REQUEST_HEAD.equals((Object)searchMatch.getLocation()) && !SearchMatch.Location.REQUEST_BODY.equals((Object)searchMatch.getLocation())) {
                return;
            }
            boolean bl = SearchMatch.Location.REQUEST_BODY.equals((Object)searchMatch.getLocation());
            int n2 = 0;
            String string = searchMatch.getMessage().getRequestHeader().toString();
            int n3 = 0;
            while ((n3 = string.indexOf("\r\n", n3)) != -1 && (bl || (n3 += 2) <= searchMatch.getStart())) {
                ++n2;
            }
            int n4 = searchMatch.getStart() - n2;
            int n5 = searchMatch.getEnd() - n2;
            if (bl) {
                n4 += string.length();
                n5 += string.length();
            }
            if (n4 > (n = this.getText().length()) || n5 > n) {
                return;
            }
            this.highlight(n4, n5);
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new RequestAllTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class RequestAllTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
        }
    }
}

