/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.KeyName;
import com.sun.org.apache.xml.internal.security.keys.content.KeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.MgmtData;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import java.io.PrintStream;
import java.security.PublicKey;

public class KeyUtils {
    private KeyUtils() {
    }

    public static void prinoutKeyInfo(KeyInfo keyInfo, PrintStream printStream) throws XMLSecurityException {
        SignatureElementProxy signatureElementProxy;
        int n;
        for (n = 0; n < keyInfo.lengthKeyName(); ++n) {
            signatureElementProxy = keyInfo.itemKeyName(n);
            printStream.println("KeyName(" + n + ")=\"" + ((KeyName)signatureElementProxy).getKeyName() + "\"");
        }
        for (n = 0; n < keyInfo.lengthKeyValue(); ++n) {
            signatureElementProxy = keyInfo.itemKeyValue(n);
            PublicKey publicKey = ((KeyValue)signatureElementProxy).getPublicKey();
            printStream.println("KeyValue Nr. " + n);
            printStream.println(publicKey);
        }
        for (n = 0; n < keyInfo.lengthMgmtData(); ++n) {
            signatureElementProxy = keyInfo.itemMgmtData(n);
            printStream.println("MgmtData(" + n + ")=\"" + ((MgmtData)signatureElementProxy).getMgmtData() + "\"");
        }
        for (n = 0; n < keyInfo.lengthX509Data(); ++n) {
            signatureElementProxy = keyInfo.itemX509Data(n);
            printStream.println("X509Data(" + n + ")=\"" + (((X509Data)signatureElementProxy).containsCertificate() ? "Certificate " : "") + (((X509Data)signatureElementProxy).containsIssuerSerial() ? "IssuerSerial " : "") + "\"");
        }
    }
}

