/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;

public abstract class TVMCI {
    protected TVMCI() {
        assert (this.getClass().getPackage().getName().equals("com.oracle.graal.truffle") || this.getClass().getPackage().getName().equals("com.oracle.truffle.api.impl"));
    }

    protected abstract void onLoopCount(Node var1, int var2);

    protected void onLoad(RootNode rootNode) {
        Accessor.InstrumentSupport support = Accessor.instrumentAccess();
        if (support != null) {
            support.onLoad(rootNode);
        }
    }

    protected void onFirstExecution(RootNode rootNode) {
        SourceSection section;
        Accessor.DebugSupport debugAccessor;
        Accessor.InstrumentSupport accessor = Accessor.instrumentAccess();
        if (accessor != null) {
            accessor.onFirstExecution(rootNode);
        }
        if ((debugAccessor = Accessor.debugAccess()) != null && (section = rootNode.getSourceSection()) != null) {
            debugAccessor.executionSourceSection(section);
        }
    }

    protected Class<? extends TruffleLanguage> findLanguageClass(RootNode root) {
        return Accessor.nodesAccess().findLanguage(root);
    }

    protected void markFrameMaterializeCalled(FrameDescriptor descriptor) {
        Accessor.framesAccess().markMaterializeCalled(descriptor);
    }

    protected boolean getFrameMaterializeCalled(FrameDescriptor descriptor) {
        return Accessor.framesAccess().getMaterializeCalled(descriptor);
    }
}

