/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SimpleQueryParser;
import org.elasticsearch.index.query.SimpleQueryStringFlag;

public class SimpleQueryStringBuilder
extends AbstractQueryBuilder<SimpleQueryStringBuilder> {
    public static final Locale DEFAULT_LOCALE = Locale.ROOT;
    public static final boolean DEFAULT_LOWERCASE_EXPANDED_TERMS = true;
    public static final boolean DEFAULT_LENIENT = false;
    public static final boolean DEFAULT_ANALYZE_WILDCARD = false;
    public static final Operator DEFAULT_OPERATOR = Operator.OR;
    public static final int DEFAULT_FLAGS = SimpleQueryStringFlag.ALL.value;
    public static final String NAME = "simple_query_string";
    private static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    private static final ParseField ANALYZE_WILDCARD_FIELD = new ParseField("analyze_wildcard", new String[0]);
    private static final ParseField LENIENT_FIELD = new ParseField("lenient", new String[0]);
    private static final ParseField LOWERCASE_EXPANDED_TERMS_FIELD = new ParseField("lowercase_expanded_terms", new String[0]);
    private static final ParseField LOCALE_FIELD = new ParseField("locale", new String[0]);
    private static final ParseField FLAGS_FIELD = new ParseField("flags", new String[0]);
    private static final ParseField DEFAULT_OPERATOR_FIELD = new ParseField("default_operator", new String[0]);
    private static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private final String queryText;
    private final Map<String, Float> fieldsAndWeights = new TreeMap<String, Float>();
    private String analyzer;
    private Operator defaultOperator = DEFAULT_OPERATOR;
    private String minimumShouldMatch;
    private int flags = DEFAULT_FLAGS;
    private SimpleQueryParser.Settings settings = new SimpleQueryParser.Settings();

    public SimpleQueryStringBuilder(String queryText) {
        if (queryText == null) {
            throw new IllegalArgumentException("query text missing");
        }
        this.queryText = queryText;
    }

    public SimpleQueryStringBuilder(StreamInput in) throws IOException {
        super(in);
        this.queryText = in.readString();
        int size = in.readInt();
        HashMap<String, Float> fields = new HashMap<String, Float>();
        for (int i = 0; i < size; ++i) {
            String field = in.readString();
            Float weight = Float.valueOf(in.readFloat());
            fields.put(field, weight);
        }
        this.fieldsAndWeights.putAll(fields);
        this.flags = in.readInt();
        this.analyzer = in.readOptionalString();
        this.defaultOperator = Operator.readFromStream(in);
        this.settings.lowercaseExpandedTerms(in.readBoolean());
        this.settings.lenient(in.readBoolean());
        this.settings.analyzeWildcard(in.readBoolean());
        this.settings.locale(Locale.forLanguageTag(in.readString()));
        this.minimumShouldMatch = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.queryText);
        out.writeInt(this.fieldsAndWeights.size());
        for (Map.Entry<String, Float> entry : this.fieldsAndWeights.entrySet()) {
            out.writeString(entry.getKey());
            out.writeFloat(entry.getValue().floatValue());
        }
        out.writeInt(this.flags);
        out.writeOptionalString(this.analyzer);
        this.defaultOperator.writeTo(out);
        out.writeBoolean(this.settings.lowercaseExpandedTerms());
        out.writeBoolean(this.settings.lenient());
        out.writeBoolean(this.settings.analyzeWildcard());
        out.writeString(this.settings.locale().toLanguageTag());
        out.writeOptionalString(this.minimumShouldMatch);
    }

    public String value() {
        return this.queryText;
    }

    public SimpleQueryStringBuilder field(String field) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("supplied field is null or empty");
        }
        this.fieldsAndWeights.put(field, Float.valueOf(1.0f));
        return this;
    }

    public SimpleQueryStringBuilder field(String field, float boost) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("supplied field is null or empty");
        }
        this.fieldsAndWeights.put(field, Float.valueOf(boost));
        return this;
    }

    public SimpleQueryStringBuilder fields(Map<String, Float> fields) {
        Objects.requireNonNull(fields, "fields cannot be null");
        this.fieldsAndWeights.putAll(fields);
        return this;
    }

    public Map<String, Float> fields() {
        return this.fieldsAndWeights;
    }

    public SimpleQueryStringBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public SimpleQueryStringBuilder defaultOperator(Operator defaultOperator) {
        this.defaultOperator = defaultOperator != null ? defaultOperator : DEFAULT_OPERATOR;
        return this;
    }

    public Operator defaultOperator() {
        return this.defaultOperator;
    }

    public SimpleQueryStringBuilder flags(SimpleQueryStringFlag ... flags) {
        if (flags != null && flags.length > 0) {
            int value = 0;
            for (SimpleQueryStringFlag flag : flags) {
                value |= flag.value;
            }
            this.flags = value;
        } else {
            this.flags = DEFAULT_FLAGS;
        }
        return this;
    }

    SimpleQueryStringBuilder flags(int flags) {
        this.flags = flags;
        return this;
    }

    int flags() {
        return this.flags;
    }

    public SimpleQueryStringBuilder lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        this.settings.lowercaseExpandedTerms(lowercaseExpandedTerms);
        return this;
    }

    public boolean lowercaseExpandedTerms() {
        return this.settings.lowercaseExpandedTerms();
    }

    public SimpleQueryStringBuilder locale(Locale locale) {
        this.settings.locale(locale);
        return this;
    }

    public Locale locale() {
        return this.settings.locale();
    }

    public SimpleQueryStringBuilder lenient(boolean lenient) {
        this.settings.lenient(lenient);
        return this;
    }

    public boolean lenient() {
        return this.settings.lenient();
    }

    public SimpleQueryStringBuilder analyzeWildcard(boolean analyzeWildcard) {
        this.settings.analyzeWildcard(analyzeWildcard);
        return this;
    }

    public boolean analyzeWildcard() {
        return this.settings.analyzeWildcard();
    }

    public SimpleQueryStringBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Object luceneAnalyzer;
        TreeMap<String, Float> resolvedFieldsAndWeights = new TreeMap<String, Float>();
        if (this.fieldsAndWeights.isEmpty()) {
            resolvedFieldsAndWeights.put(SimpleQueryStringBuilder.resolveIndexName(context.defaultField(), context), Float.valueOf(1.0f));
        } else {
            for (Map.Entry<String, Float> fieldEntry : this.fieldsAndWeights.entrySet()) {
                if (Regex.isSimpleMatchPattern(fieldEntry.getKey())) {
                    for (String fieldName : context.getMapperService().simpleMatchToIndexNames(fieldEntry.getKey())) {
                        resolvedFieldsAndWeights.put(fieldName, fieldEntry.getValue());
                    }
                    continue;
                }
                resolvedFieldsAndWeights.put(SimpleQueryStringBuilder.resolveIndexName(fieldEntry.getKey(), context), fieldEntry.getValue());
            }
        }
        if (this.analyzer == null) {
            luceneAnalyzer = context.getMapperService().searchAnalyzer();
        } else {
            luceneAnalyzer = context.getAnalysisService().analyzer(this.analyzer);
            if (luceneAnalyzer == null) {
                throw new QueryShardException(context, "[simple_query_string] analyzer [" + this.analyzer + "] not found", new Object[0]);
            }
        }
        SimpleQueryParser sqp = new SimpleQueryParser((Analyzer)luceneAnalyzer, (Map<String, Float>)resolvedFieldsAndWeights, this.flags, this.settings, context);
        sqp.setDefaultOperator(this.defaultOperator.toBooleanClauseOccur());
        Query query = sqp.parse(this.queryText);
        if (this.minimumShouldMatch != null && query instanceof BooleanQuery && !((BooleanQuery)query).isCoordDisabled()) {
            query = Queries.applyMinimumShouldMatch((BooleanQuery)query, this.minimumShouldMatch);
        }
        return query;
    }

    private static String resolveIndexName(String fieldName, QueryShardContext context) {
        MappedFieldType fieldType = context.fieldMapper(fieldName);
        if (fieldType != null) {
            return fieldType.name();
        }
        return fieldName;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.queryText);
        if (this.fieldsAndWeights.size() > 0) {
            builder.startArray(FIELDS_FIELD.getPreferredName());
            for (Map.Entry<String, Float> entry : this.fieldsAndWeights.entrySet()) {
                builder.value(entry.getKey() + "^" + entry.getValue());
            }
            builder.endArray();
        }
        if (this.analyzer != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        builder.field(FLAGS_FIELD.getPreferredName(), this.flags);
        builder.field(DEFAULT_OPERATOR_FIELD.getPreferredName(), this.defaultOperator.name().toLowerCase(Locale.ROOT));
        builder.field(LOWERCASE_EXPANDED_TERMS_FIELD.getPreferredName(), this.settings.lowercaseExpandedTerms());
        builder.field(LENIENT_FIELD.getPreferredName(), this.settings.lenient());
        builder.field(ANALYZE_WILDCARD_FIELD.getPreferredName(), this.settings.analyzeWildcard());
        builder.field(LOCALE_FIELD.getPreferredName(), this.settings.locale().toLanguageTag());
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<SimpleQueryStringBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String currentFieldName = null;
        String queryBody = null;
        float boost = 1.0f;
        String queryName = null;
        String minimumShouldMatch = null;
        HashMap<String, Float> fieldsAndWeights = new HashMap<String, Float>();
        Operator defaultOperator = null;
        String analyzerName = null;
        int flags = SimpleQueryStringFlag.ALL.value();
        boolean lenient = false;
        boolean lowercaseExpandedTerms = true;
        boolean analyzeWildcard = false;
        Locale locale = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (parseContext.getParseFieldMatcher().match(currentFieldName, FIELDS_FIELD)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String fField = null;
                        float fBoost = 1.0f;
                        char[] text = parser.textCharacters();
                        int end = parser.textOffset() + parser.textLength();
                        for (int i = parser.textOffset(); i < end; ++i) {
                            if (text[i] != '^') continue;
                            int relativeLocation = i - parser.textOffset();
                            fField = new String(text, parser.textOffset(), relativeLocation);
                            fBoost = Float.parseFloat(new String(text, i + 1, parser.textLength() - relativeLocation - 1));
                            break;
                        }
                        if (fField == null) {
                            fField = parser.text();
                        }
                        fieldsAndWeights.put(fField, Float.valueOf(fBoost));
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[simple_query_string] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (parseContext.getParseFieldMatcher().match(currentFieldName, QUERY_FIELD)) {
                    queryBody = parser.text();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.BOOST_FIELD)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, ANALYZER_FIELD)) {
                    analyzerName = parser.text();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, DEFAULT_OPERATOR_FIELD)) {
                    defaultOperator = Operator.fromString(parser.text());
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, FLAGS_FIELD)) {
                    if (parser.currentToken() != XContentParser.Token.VALUE_NUMBER) {
                        flags = SimpleQueryStringFlag.resolveFlags(parser.text());
                        continue;
                    }
                    flags = parser.intValue();
                    if (flags >= 0) continue;
                    flags = SimpleQueryStringFlag.ALL.value();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, LOCALE_FIELD)) {
                    String localeStr = parser.text();
                    locale = Locale.forLanguageTag(localeStr);
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, LOWERCASE_EXPANDED_TERMS_FIELD)) {
                    lowercaseExpandedTerms = parser.booleanValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, LENIENT_FIELD)) {
                    lenient = parser.booleanValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, ANALYZE_WILDCARD_FIELD)) {
                    analyzeWildcard = parser.booleanValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.NAME_FIELD)) {
                    queryName = parser.text();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, MINIMUM_SHOULD_MATCH_FIELD)) {
                    minimumShouldMatch = parser.textOrNull();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[simple_query_string] unsupported field [" + parser.currentName() + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[simple_query_string] unknown token [" + (Object)((Object)token) + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (queryBody == null) {
            throw new ParsingException(parser.getTokenLocation(), "[simple_query_string] query text missing", new Object[0]);
        }
        SimpleQueryStringBuilder qb = new SimpleQueryStringBuilder(queryBody);
        ((SimpleQueryStringBuilder)((SimpleQueryStringBuilder)qb.boost(boost)).fields(fieldsAndWeights).analyzer(analyzerName).queryName(queryName)).minimumShouldMatch(minimumShouldMatch);
        qb.flags(flags).defaultOperator(defaultOperator).locale(locale).lowercaseExpandedTerms(lowercaseExpandedTerms);
        qb.lenient(lenient).analyzeWildcard(analyzeWildcard).boost(boost);
        return Optional.of(qb);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldsAndWeights, this.analyzer, this.defaultOperator, this.queryText, this.minimumShouldMatch, this.settings, this.flags);
    }

    @Override
    protected boolean doEquals(SimpleQueryStringBuilder other) {
        return Objects.equals(this.fieldsAndWeights, other.fieldsAndWeights) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.defaultOperator, other.defaultOperator) && Objects.equals(this.queryText, other.queryText) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.settings, other.settings) && this.flags == other.flags;
    }
}

