/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.TermsLookup;

public class TermsQueryBuilder
extends AbstractQueryBuilder<TermsQueryBuilder> {
    public static final String NAME = "terms";
    public static final ParseField QUERY_NAME_FIELD = new ParseField("terms", "in");
    private final String fieldName;
    private final List<?> values;
    private final TermsLookup termsLookup;

    public TermsQueryBuilder(String fieldName, TermsLookup termsLookup) {
        this(fieldName, null, termsLookup);
    }

    TermsQueryBuilder(String fieldName, List<Object> values, TermsLookup termsLookup) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name cannot be null.");
        }
        if (values == null && termsLookup == null) {
            throw new IllegalArgumentException("No value or termsLookup specified for terms query");
        }
        if (values != null && termsLookup != null) {
            throw new IllegalArgumentException("Both values and termsLookup specified for terms query");
        }
        this.fieldName = fieldName;
        this.values = values;
        this.termsLookup = termsLookup;
    }

    public TermsQueryBuilder(String fieldName, String ... values) {
        this(fieldName, values != null ? Arrays.asList(values) : null);
    }

    public TermsQueryBuilder(String fieldName, int ... values) {
        this(fieldName, values != null ? (Iterable)Arrays.stream(values).mapToObj(s -> s).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, long ... values) {
        this(fieldName, values != null ? (Iterable)Arrays.stream(values).mapToObj(s -> s).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, float ... values) {
        this(fieldName, values != null ? (Iterable)IntStream.range(0, values.length).mapToObj(i -> Float.valueOf(values[i])).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, double ... values) {
        this(fieldName, values != null ? (Iterable)Arrays.stream(values).mapToObj(s -> s).collect(Collectors.toList()) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, Object ... values) {
        this(fieldName, values != null ? Arrays.asList(values) : (Iterable)null);
    }

    public TermsQueryBuilder(String fieldName, Iterable<?> values) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name cannot be null.");
        }
        if (values == null) {
            throw new IllegalArgumentException("No value specified for terms query");
        }
        this.fieldName = fieldName;
        this.values = TermsQueryBuilder.convertToBytesRefListIfStringList(values);
        this.termsLookup = null;
    }

    public TermsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.termsLookup = in.readOptionalWriteable(TermsLookup::new);
        this.values = (List)in.readGenericValue();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeOptionalWriteable(this.termsLookup);
        out.writeGenericValue(this.values);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public List<Object> values() {
        return TermsQueryBuilder.convertToStringListIfBytesRefList(this.values);
    }

    public TermsLookup termsLookup() {
        return this.termsLookup;
    }

    private static List<Object> convertToBytesRefListIfStringList(Iterable<?> objs) {
        if (objs == null) {
            return null;
        }
        ArrayList<Object> newObjs = new ArrayList<Object>();
        for (Object obj : objs) {
            newObjs.add(TermsQueryBuilder.convertToBytesRefIfString(obj));
        }
        return newObjs;
    }

    private static List<Object> convertToStringListIfBytesRefList(Iterable<?> objs) {
        if (objs == null) {
            return null;
        }
        ArrayList<Object> newObjs = new ArrayList<Object>();
        for (Object obj : objs) {
            newObjs.add(TermsQueryBuilder.convertToStringIfBytesRef(obj));
        }
        return newObjs;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.termsLookup != null) {
            builder.startObject(this.fieldName);
            this.termsLookup.toXContent(builder, params);
            builder.endObject();
        } else {
            builder.field(this.fieldName, TermsQueryBuilder.convertToStringListIfBytesRefList(this.values));
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<TermsQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        List<Object> values = null;
        TermsLookup termsLookup = null;
        String queryName = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_ARRAY) {
                if (fieldName != null) {
                    throw new ParsingException(parser.getTokenLocation(), "[terms] query does not support multiple fields", new Object[0]);
                }
                fieldName = currentFieldName;
                values = TermsQueryBuilder.parseValues(parser);
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (fieldName != null) {
                    throw new ParsingException(parser.getTokenLocation(), "[terms] query does not support more than one field. Already got: [" + fieldName + "] but also found [" + currentFieldName + "]", new Object[0]);
                }
                fieldName = currentFieldName;
                termsLookup = TermsLookup.parseTermsLookup(parser);
                continue;
            }
            if (token.isValue()) {
                if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.BOOST_FIELD)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.NAME_FIELD)) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[terms] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[terms] unknown token [" + (Object)((Object)token) + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (fieldName == null) {
            throw new ParsingException(parser.getTokenLocation(), "[terms] query requires a field name, followed by array of terms or a document lookup specification", new Object[0]);
        }
        return Optional.of(((TermsQueryBuilder)new TermsQueryBuilder(fieldName, values, termsLookup).boost(boost)).queryName(queryName));
    }

    private static List<Object> parseValues(XContentParser parser) throws IOException {
        ArrayList<Object> values = new ArrayList<Object>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            Object value = parser.objectBytes();
            if (value == null) {
                throw new ParsingException(parser.getTokenLocation(), "No value specified for terms query", new Object[0]);
            }
            values.add(value);
        }
        return values;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (this.termsLookup != null) {
            throw new UnsupportedOperationException("query must be rewritten first");
        }
        if (this.values == null || this.values.isEmpty()) {
            return Queries.newMatchNoDocsQuery("No terms supplied for \"" + this.getName() + "\" query.");
        }
        return TermsQueryBuilder.handleTermsQuery(this.values, this.fieldName, context);
    }

    private List<Object> fetch(TermsLookup termsLookup, Client client) {
        ArrayList<Object> terms = new ArrayList<Object>();
        GetRequest getRequest = new GetRequest(termsLookup.index(), termsLookup.type(), termsLookup.id()).preference("_local").routing(termsLookup.routing());
        GetResponse getResponse = client.get(getRequest).actionGet();
        if (!getResponse.isSourceEmpty()) {
            List<Object> extractedValues = XContentMapValues.extractRawValues(termsLookup.path(), getResponse.getSourceAsMap());
            terms.addAll(extractedValues);
        }
        return terms;
    }

    private static Query handleTermsQuery(List<?> terms, String fieldName, QueryShardContext context) {
        Query query;
        MappedFieldType fieldType = context.fieldMapper(fieldName);
        String indexFieldName = fieldType != null ? fieldType.name() : fieldName;
        if (context.isFilter()) {
            if (fieldType != null) {
                query = fieldType.termsQuery(terms, context);
            } else {
                BytesRef[] filterValues = new BytesRef[terms.size()];
                for (int i = 0; i < filterValues.length; ++i) {
                    filterValues[i] = BytesRefs.toBytesRef(terms.get(i));
                }
                query = new TermsQuery(indexFieldName, filterValues);
            }
        } else {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            for (Object term : terms) {
                if (fieldType != null) {
                    bq.add(fieldType.termQuery(term, context), BooleanClause.Occur.SHOULD);
                    continue;
                }
                bq.add((Query)new TermQuery(new Term(indexFieldName, BytesRefs.toBytesRef(term))), BooleanClause.Occur.SHOULD);
            }
            query = bq.build();
        }
        return query;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.values, this.termsLookup);
    }

    @Override
    protected boolean doEquals(TermsQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.values, other.values) && Objects.equals(this.termsLookup, other.termsLookup);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (this.termsLookup != null) {
            TermsLookup termsLookup = new TermsLookup(this.termsLookup);
            if (termsLookup.index() == null) {
                if (queryRewriteContext.getIndexSettings() != null) {
                    termsLookup.index(queryRewriteContext.getIndexSettings().getIndex().getName());
                } else {
                    return this;
                }
            }
            List<Object> values = this.fetch(termsLookup, queryRewriteContext.getClient());
            return new TermsQueryBuilder(this.fieldName, values);
        }
        return this;
    }
}

