/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Constant;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Executable;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.SimpleChecksAdapter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SFunction;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

public final class SSource
extends AStatement {
    private final CompilerSettings settings;
    private final String name;
    private final String source;
    private final Printer debugStream;
    private final MainMethodReserved reserved;
    private final List<SFunction> functions;
    private final Globals globals;
    private final List<AStatement> statements;
    private Locals mainMethod;
    private byte[] bytes;

    public SSource(CompilerSettings settings, String name, String source, Printer debugStream, MainMethodReserved reserved, Location location, List<SFunction> functions, Globals globals, List<AStatement> statements) {
        super(location);
        this.settings = Objects.requireNonNull(settings);
        this.name = Objects.requireNonNull(name);
        this.source = Objects.requireNonNull(source);
        this.debugStream = debugStream;
        this.reserved = Objects.requireNonNull(reserved);
        functions.addAll(globals.getSyntheticMethods().values());
        globals.getSyntheticMethods().clear();
        this.functions = Collections.unmodifiableList(functions);
        this.statements = Collections.unmodifiableList(statements);
        this.globals = globals;
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw new IllegalStateException("Illegal tree structure.");
    }

    public void analyze() {
        HashMap<Definition.MethodKey, Definition.Method> methods = new HashMap<Definition.MethodKey, Definition.Method>();
        for (SFunction function : this.functions) {
            function.generateSignature();
            Definition.MethodKey key = new Definition.MethodKey(function.name, function.parameters.size());
            if (methods.put(key, function.method) == null) continue;
            throw this.createError(new IllegalArgumentException("Duplicate functions with name [" + function.name + "]."));
        }
        this.analyze(Locals.newProgramScope(methods.values()));
    }

    @Override
    void analyze(Locals program) {
        for (SFunction function : this.functions) {
            Locals functionLocals = Locals.newFunctionScope(program, function.rtnType, function.parameters, function.reserved.getMaxLoopCounter());
            function.analyze(functionLocals);
        }
        if (this.statements == null || this.statements.isEmpty()) {
            throw this.createError(new IllegalArgumentException("Cannot generate an empty script."));
        }
        this.mainMethod = Locals.newMainMethodScope(program, this.reserved.usesScore(), this.reserved.usesCtx(), this.reserved.getMaxLoopCounter());
        AStatement last = this.statements.get(this.statements.size() - 1);
        for (AStatement statement : this.statements) {
            if (this.allEscape) {
                throw this.createError(new IllegalArgumentException("Unreachable statement."));
            }
            statement.lastSource = statement == last;
            statement.analyze(this.mainMethod);
            this.methodEscape = statement.methodEscape;
            this.allEscape = statement.allEscape;
        }
    }

    public void write() {
        ClassWriter writer;
        String[] stringArray;
        int classFrames = 3;
        int classAccess = 49;
        String classBase = WriterConstants.BASE_CLASS_TYPE.getInternalName();
        String className = WriterConstants.CLASS_TYPE.getInternalName();
        if (this.reserved.usesScore()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = WriterConstants.NEEDS_SCORE_TYPE.getInternalName();
        } else {
            stringArray = null;
        }
        String[] classInterfaces = stringArray;
        Object visitor = writer = new ClassWriter(classFrames);
        if (this.settings.isPicky()) {
            visitor = new SimpleChecksAdapter((ClassVisitor)visitor);
        }
        if (this.debugStream != null) {
            visitor = new TraceClassVisitor((ClassVisitor)visitor, this.debugStream, null);
        }
        visitor.visit(52, classAccess, className, null, classBase, classInterfaces);
        visitor.visitSource(Location.computeSourceName(this.name, this.source), null);
        MethodWriter constructor = new MethodWriter(1, WriterConstants.CONSTRUCTOR, (ClassVisitor)visitor, this.globals.getStatements(), this.settings);
        constructor.visitCode();
        constructor.loadThis();
        constructor.loadArgs();
        constructor.invokeConstructor(Type.getType(Executable.class), WriterConstants.CONSTRUCTOR);
        constructor.returnValue();
        constructor.endMethod();
        MethodWriter execute = new MethodWriter(1, WriterConstants.EXECUTE, (ClassVisitor)visitor, this.globals.getStatements(), this.settings);
        execute.visitCode();
        this.write(execute, this.globals);
        execute.endMethod();
        for (SFunction sFunction : this.functions) {
            sFunction.write((ClassVisitor)visitor, this.settings, this.globals);
        }
        while (!this.globals.getSyntheticMethods().isEmpty()) {
            ArrayList<SFunction> current = new ArrayList<SFunction>(this.globals.getSyntheticMethods().values());
            this.globals.getSyntheticMethods().clear();
            for (SFunction function : current) {
                function.write((ClassVisitor)visitor, this.settings, this.globals);
            }
        }
        if (!this.globals.getConstantInitializers().isEmpty()) {
            Collection<Constant> inits = this.globals.getConstantInitializers().values();
            for (Constant constant : inits) {
                visitor.visitField(26, constant.name, constant.type.getDescriptor(), null, null).visitEnd();
            }
            MethodWriter methodWriter = new MethodWriter(8, WriterConstants.CLINIT, (ClassVisitor)visitor, this.globals.getStatements(), this.settings);
            methodWriter.visitCode();
            for (Constant constant : inits) {
                constant.initializer.accept(methodWriter);
                methodWriter.putStatic(WriterConstants.CLASS_TYPE, constant.name, constant.type);
            }
            methodWriter.returnValue();
            methodWriter.endMethod();
        }
        visitor.visitEnd();
        this.bytes = writer.toByteArray();
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        if (this.reserved.usesScore()) {
            Locals.Variable scorer = this.mainMethod.getVariable(null, "#scorer");
            Locals.Variable score = this.mainMethod.getVariable(null, "_score");
            writer.visitVarInsn(25, scorer.getSlot());
            writer.invokeVirtual(WriterConstants.SCORER_TYPE, WriterConstants.SCORER_SCORE);
            writer.visitInsn(141);
            writer.visitVarInsn(57, score.getSlot());
        }
        if (this.reserved.usesCtx()) {
            Locals.Variable input = this.mainMethod.getVariable(null, "params");
            Locals.Variable ctx = this.mainMethod.getVariable(null, "ctx");
            writer.visitVarInsn(25, input.getSlot());
            writer.push("ctx");
            writer.invokeInterface(WriterConstants.MAP_TYPE, WriterConstants.MAP_GET);
            writer.visitVarInsn(58, ctx.getSlot());
        }
        if (this.reserved.getMaxLoopCounter() > 0) {
            Locals.Variable loop = this.mainMethod.getVariable(null, "#loop");
            writer.push(this.reserved.getMaxLoopCounter());
            writer.visitVarInsn(54, loop.getSlot());
        }
        for (AStatement statement : this.statements) {
            statement.write(writer, globals);
        }
        if (!this.methodEscape) {
            writer.visitInsn(1);
            writer.returnValue();
        }
    }

    public BitSet getStatements() {
        return this.globals.getStatements();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public static final class MainMethodReserved
    implements Reserved {
        private boolean score = false;
        private boolean ctx = false;
        private int maxLoopCounter = 0;

        @Override
        public void markReserved(String name) {
            if ("_score".equals(name)) {
                this.score = true;
            } else if ("ctx".equals(name)) {
                this.ctx = true;
            }
        }

        @Override
        public boolean isReserved(String name) {
            return Locals.MAIN_KEYWORDS.contains(name);
        }

        public boolean usesScore() {
            return this.score;
        }

        public boolean usesCtx() {
            return this.ctx;
        }

        @Override
        public void setMaxLoopCounter(int max) {
            this.maxLoopCounter = max;
        }

        @Override
        public int getMaxLoopCounter() {
            return this.maxLoopCounter;
        }
    }

    public static interface Reserved {
        public void markReserved(String var1);

        public boolean isReserved(String var1);

        public void setMaxLoopCounter(int var1);

        public int getMaxLoopCounter();
    }
}

