/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.net.SocketPermission;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.RuntimeUtil;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.Util;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

final class DGCImpl
implements DGC {
    static final Log dgcLog = Log.getLog("sun.rmi.dgc", "dgc", LogStream.parseLevel(AccessController.doPrivileged(new GetPropertyAction("sun.rmi.dgc.logLevel"))));
    private static final long leaseValue = AccessController.doPrivileged(new GetLongAction("java.rmi.dgc.leaseValue", 600000L));
    private static final long leaseCheckInterval = AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.checkInterval", leaseValue / 2L));
    private static final ScheduledExecutorService scheduler = AccessController.doPrivileged(new RuntimeUtil.GetInstanceAction()).getScheduler();
    private static DGCImpl dgc;
    private Map<VMID, LeaseInfo> leaseTable = new HashMap<VMID, LeaseInfo>();
    private Future<?> checker = null;

    static DGCImpl getDGCImpl() {
        return dgc;
    }

    private DGCImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lease dirty(ObjID[] ids, long sequenceNum, Lease lease) {
        Object clientHost;
        VMID vmid = lease.getVMID();
        long duration = leaseValue;
        if (dgcLog.isLoggable(Log.VERBOSE)) {
            dgcLog.log(Log.VERBOSE, "vmid = " + vmid);
        }
        if (vmid == null) {
            vmid = new VMID();
            if (dgcLog.isLoggable(Log.BRIEF)) {
                try {
                    clientHost = RemoteServer.getClientHost();
                }
                catch (ServerNotActiveException e) {
                    clientHost = "<unknown host>";
                }
                dgcLog.log(Log.BRIEF, " assigning vmid " + vmid + " to client " + (String)clientHost);
            }
        }
        lease = new Lease(vmid, duration);
        clientHost = this.leaseTable;
        synchronized (clientHost) {
            LeaseInfo info = this.leaseTable.get(vmid);
            if (info == null) {
                this.leaseTable.put(vmid, new LeaseInfo(vmid, duration));
                if (this.checker == null) {
                    this.checker = scheduler.scheduleWithFixedDelay(new Runnable(){

                        @Override
                        public void run() {
                            DGCImpl.this.checkLeases();
                        }
                    }, leaseCheckInterval, leaseCheckInterval, TimeUnit.MILLISECONDS);
                }
            } else {
                info.renew(duration);
            }
        }
        for (ObjID id : ids) {
            if (dgcLog.isLoggable(Log.VERBOSE)) {
                dgcLog.log(Log.VERBOSE, "id = " + id + ", vmid = " + vmid + ", duration = " + duration);
            }
            ObjectTable.referenced(id, sequenceNum, vmid);
        }
        return lease;
    }

    @Override
    public void clean(ObjID[] ids, long sequenceNum, VMID vmid, boolean strong) {
        for (ObjID id : ids) {
            if (dgcLog.isLoggable(Log.VERBOSE)) {
                dgcLog.log(Log.VERBOSE, "id = " + id + ", vmid = " + vmid + ", strong = " + strong);
            }
            ObjectTable.unreferenced(id, sequenceNum, vmid, strong);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTarget(VMID vmid, Target target) {
        Map<VMID, LeaseInfo> map = this.leaseTable;
        synchronized (map) {
            LeaseInfo info = this.leaseTable.get(vmid);
            if (info == null) {
                target.vmidDead(vmid);
            } else {
                info.notifySet.add(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterTarget(VMID vmid, Target target) {
        Map<VMID, LeaseInfo> map = this.leaseTable;
        synchronized (map) {
            LeaseInfo info = this.leaseTable.get(vmid);
            if (info != null) {
                info.notifySet.remove(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLeases() {
        long time = System.currentTimeMillis();
        ArrayList<LeaseInfo> toUnregister = new ArrayList<LeaseInfo>();
        Map<VMID, LeaseInfo> map = this.leaseTable;
        synchronized (map) {
            Iterator<LeaseInfo> iter = this.leaseTable.values().iterator();
            while (iter.hasNext()) {
                LeaseInfo info = iter.next();
                if (!info.expired(time)) continue;
                toUnregister.add(info);
                iter.remove();
            }
            if (this.leaseTable.isEmpty()) {
                this.checker.cancel(false);
                this.checker = null;
            }
        }
        for (LeaseInfo info : toUnregister) {
            for (Target target : info.notifySet) {
                target.vmidDead(info.vmid);
            }
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                ClassLoader savedCcl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                    try {
                        dgc = new DGCImpl();
                        final ObjID dgcID = new ObjID(2);
                        LiveRef ref = new LiveRef(dgcID, 0);
                        final UnicastServerRef disp = new UnicastServerRef(ref);
                        final Remote stub = Util.createProxy(DGCImpl.class, new UnicastRef(ref), true);
                        disp.setSkeleton(dgc);
                        Permissions perms = new Permissions();
                        perms.add(new SocketPermission("*", "accept,resolve"));
                        ProtectionDomain[] pd = new ProtectionDomain[]{new ProtectionDomain(null, perms)};
                        AccessControlContext acceptAcc = new AccessControlContext(pd);
                        Target target = AccessController.doPrivileged(new PrivilegedAction<Target>(){

                            @Override
                            public Target run() {
                                return new Target(dgc, disp, stub, dgcID, true);
                            }
                        }, acceptAcc);
                        ObjectTable.putTarget(target);
                    }
                    catch (RemoteException e) {
                        throw new Error("exception initializing server-side DGC", e);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(savedCcl);
                }
                return null;
            }
        });
    }

    private static class LeaseInfo {
        VMID vmid;
        long expiration;
        Set<Target> notifySet = new HashSet<Target>();

        LeaseInfo(VMID vmid, long lease) {
            this.vmid = vmid;
            this.expiration = System.currentTimeMillis() + lease;
        }

        synchronized void renew(long lease) {
            long newExpiration = System.currentTimeMillis() + lease;
            if (newExpiration > this.expiration) {
                this.expiration = newExpiration;
            }
        }

        boolean expired(long time) {
            if (this.expiration < time) {
                if (dgcLog.isLoggable(Log.BRIEF)) {
                    dgcLog.log(Log.BRIEF, this.vmid.toString());
                }
                return true;
            }
            return false;
        }
    }
}

