/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.CryptoAllPermission;
import javax.crypto.CryptoPermission;
import javax.crypto.CryptoPermissions;
import javax.crypto.ExemptionMechanism;
import javax.crypto.JceSecurity;

final class JceSecurityManager
extends SecurityManager {
    private static final CryptoPermissions defaultPolicy;
    private static final CryptoPermissions exemptPolicy;
    private static final CryptoAllPermission allPerm;
    private static final Vector TrustedCallersCache;
    private static final ConcurrentMap<URL, CryptoPermissions> exemptCache;
    private static final CryptoPermissions CACHE_NULL_MARK;
    static final JceSecurityManager INSTANCE;

    private JceSecurityManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CryptoPermission getCryptoPermission(String alg) {
        Class<?> cls;
        int i;
        CryptoPermission defaultPerm = this.getDefaultPermission(alg = alg.toUpperCase(Locale.ENGLISH));
        if (defaultPerm == CryptoAllPermission.INSTANCE) {
            return defaultPerm;
        }
        Class<?>[] context = this.getClassContext();
        URL callerCodeBase = null;
        for (i = 0; i < context.length && (callerCodeBase = JceSecurity.getCodeBase(cls = context[i])) == null; ++i) {
            if (cls.getName().startsWith("javax.crypto.")) continue;
            return defaultPerm;
        }
        if (i == context.length) {
            return defaultPerm;
        }
        CryptoPermissions appPerms = (CryptoPermissions)exemptCache.get(callerCodeBase);
        if (appPerms == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                appPerms = (CryptoPermissions)exemptCache.get(callerCodeBase);
                if (appPerms == null) {
                    appPerms = JceSecurityManager.getAppPermissions(callerCodeBase);
                    exemptCache.putIfAbsent(callerCodeBase, appPerms == null ? CACHE_NULL_MARK : appPerms);
                }
            }
        }
        if (appPerms == null || appPerms == CACHE_NULL_MARK) {
            return defaultPerm;
        }
        if (appPerms.implies(allPerm)) {
            return allPerm;
        }
        PermissionCollection appPc = appPerms.getPermissionCollection(alg);
        if (appPc == null) {
            return defaultPerm;
        }
        Enumeration<Permission> enum_ = appPc.elements();
        while (enum_.hasMoreElements()) {
            CryptoPermission cp = (CryptoPermission)enum_.nextElement();
            if (cp.getExemptionMechanism() != null) continue;
            return cp;
        }
        PermissionCollection exemptPc = exemptPolicy.getPermissionCollection(alg);
        if (exemptPc == null) {
            return defaultPerm;
        }
        enum_ = exemptPc.elements();
        while (enum_.hasMoreElements()) {
            CryptoPermission cp = (CryptoPermission)enum_.nextElement();
            try {
                CryptoPermission newCp;
                ExemptionMechanism.getInstance(cp.getExemptionMechanism());
                if (cp.getAlgorithm().equals("*") && appPerms.implies(newCp = cp.getCheckParam() ? new CryptoPermission(alg, cp.getMaxKeySize(), cp.getAlgorithmParameterSpec(), cp.getExemptionMechanism()) : new CryptoPermission(alg, cp.getMaxKeySize(), cp.getExemptionMechanism()))) {
                    return newCp;
                }
                if (!appPerms.implies(cp)) continue;
                return cp;
            }
            catch (Exception e) {
            }
        }
        return defaultPerm;
    }

    private static CryptoPermissions getAppPermissions(URL callerCodeBase) {
        try {
            return JceSecurity.verifyExemptJar(callerCodeBase);
        }
        catch (Exception e) {
            return null;
        }
    }

    private CryptoPermission getDefaultPermission(String alg) {
        Enumeration<Permission> enum_ = defaultPolicy.getPermissionCollection(alg).elements();
        return (CryptoPermission)enum_.nextElement();
    }

    boolean isCallerTrusted() {
        int i;
        Class<?>[] context = this.getClassContext();
        URL callerCodeBase = null;
        for (i = 0; i < context.length && (callerCodeBase = JceSecurity.getCodeBase(context[i])) == null; ++i) {
        }
        if (i == context.length) {
            return true;
        }
        if (TrustedCallersCache.contains(context[i])) {
            return true;
        }
        try {
            JceSecurity.verifyProviderJar(callerCodeBase);
        }
        catch (Exception e2) {
            return false;
        }
        TrustedCallersCache.addElement(context[i]);
        return true;
    }

    static {
        TrustedCallersCache = new Vector(2);
        exemptCache = new ConcurrentHashMap<URL, CryptoPermissions>();
        CACHE_NULL_MARK = new CryptoPermissions();
        defaultPolicy = JceSecurity.getDefaultPolicy();
        exemptPolicy = JceSecurity.getExemptPolicy();
        allPerm = CryptoAllPermission.INSTANCE;
        INSTANCE = (JceSecurityManager)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new JceSecurityManager();
            }
        });
    }
}

