/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.Map;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.index.TransportIndexAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportShardBulkAction
extends TransportWriteAction<BulkShardRequest, BulkShardResponse> {
    private static final String OP_TYPE_UPDATE = "update";
    private static final String OP_TYPE_DELETE = "delete";
    public static final String ACTION_NAME = "indices:data/write/bulk[s]";
    private final UpdateHelper updateHelper;
    private final boolean allowIdGeneration;
    private final MappingUpdatedAction mappingUpdatedAction;

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, UpdateHelper updateHelper, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, BulkShardRequest::new, "bulk");
        this.updateHelper = updateHelper;
        this.allowIdGeneration = settings.getAsBoolean("action.allow_id_generation", true);
        this.mappingUpdatedAction = mappingUpdatedAction;
    }

    @Override
    protected TransportRequestOptions transportOptions() {
        return BulkAction.INSTANCE.transportOptions(this.settings);
    }

    @Override
    protected BulkShardResponse newResponseInstance() {
        return new BulkShardResponse();
    }

    @Override
    protected boolean resolveIndex() {
        return false;
    }

    @Override
    protected TransportWriteAction.WriteResult<BulkShardResponse> onPrimaryShard(BulkShardRequest request, IndexShard indexShard) throws Exception {
        ShardId shardId = request.shardId();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexMetaData metaData = indexService.getIndexSettings().getIndexMetaData();
        long[] preVersions = new long[request.items().length];
        VersionType[] preVersionTypes = new VersionType[request.items().length];
        Translog.Location location = null;
        for (int requestIndex = 0; requestIndex < request.items().length; ++requestIndex) {
            BulkItemRequest item = request.items()[requestIndex];
            location = this.handleItem(metaData, request, indexShard, preVersions, preVersionTypes, location, requestIndex, item);
        }
        BulkItemResponse[] responses = new BulkItemResponse[request.items().length];
        BulkItemRequest[] items = request.items();
        for (int i = 0; i < items.length; ++i) {
            responses[i] = items[i].getPrimaryResponse();
        }
        BulkShardResponse response = new BulkShardResponse(request.shardId(), responses);
        return new TransportWriteAction.WriteResult<BulkShardResponse>(response, location);
    }

    private Translog.Location handleItem(IndexMetaData metaData, BulkShardRequest request, IndexShard indexShard, long[] preVersions, VersionType[] preVersionTypes, Translog.Location location, int requestIndex, BulkItemRequest item) {
        if (item.request() instanceof IndexRequest) {
            location = this.index(metaData, request, indexShard, preVersions, preVersionTypes, location, requestIndex, item);
        } else if (item.request() instanceof DeleteRequest) {
            location = this.delete(request, indexShard, preVersions, preVersionTypes, location, requestIndex, item);
        } else if (item.request() instanceof UpdateRequest) {
            Tuple<Translog.Location, BulkItemRequest> tuple = this.update(metaData, request, indexShard, preVersions, preVersionTypes, location, requestIndex, item);
            location = tuple.v1();
            item = tuple.v2();
        } else {
            throw new IllegalStateException("Unexpected index operation: " + item.request());
        }
        assert (item.getPrimaryResponse() != null);
        assert (preVersionTypes[requestIndex] != null);
        return location;
    }

    private Translog.Location index(IndexMetaData metaData, BulkShardRequest request, IndexShard indexShard, long[] preVersions, VersionType[] preVersionTypes, Translog.Location location, int requestIndex, BulkItemRequest item) {
        IndexRequest indexRequest = (IndexRequest)item.request();
        preVersions[requestIndex] = indexRequest.version();
        preVersionTypes[requestIndex] = indexRequest.versionType();
        try {
            TransportWriteAction.WriteResult<IndexResponse> result = this.shardIndexOperation(request, indexRequest, metaData, indexShard, true);
            location = this.locationToSync(location, result.getLocation());
            IndexResponse indexResponse = result.getResponse();
            this.setResponse(item, new BulkItemResponse(item.id(), indexRequest.opType().lowercase(), indexResponse));
        }
        catch (Exception e) {
            if (this.retryPrimaryException(e)) {
                for (int j = 0; j < requestIndex; ++j) {
                    this.applyVersion(request.items()[j], preVersions[j], preVersionTypes[j]);
                }
                throw (ElasticsearchException)e;
            }
            this.logFailure(e, "index", request.shardId(), indexRequest);
            if (item.getPrimaryResponse() != null && ReplicationOperation.isConflictException(e)) {
                this.setResponse(item, item.getPrimaryResponse());
            }
            this.setResponse(item, new BulkItemResponse(item.id(), indexRequest.opType().lowercase(), new BulkItemResponse.Failure(request.index(), indexRequest.type(), indexRequest.id(), e)));
        }
        return location;
    }

    private <ReplicationRequestT extends ReplicationRequest<ReplicationRequestT>> void logFailure(Throwable t, String operation, ShardId shardId, ReplicationRequest<ReplicationRequestT> request) {
        if (ExceptionsHelper.status(t) == RestStatus.CONFLICT) {
            this.logger.trace(() -> new ParameterizedMessage("{} failed to execute bulk item ({}) {}", new Object[]{shardId, operation, request}), t);
        } else {
            this.logger.debug(() -> new ParameterizedMessage("{} failed to execute bulk item ({}) {}", new Object[]{shardId, operation, request}), t);
        }
    }

    private Translog.Location delete(BulkShardRequest request, IndexShard indexShard, long[] preVersions, VersionType[] preVersionTypes, Translog.Location location, int requestIndex, BulkItemRequest item) {
        DeleteRequest deleteRequest = (DeleteRequest)item.request();
        preVersions[requestIndex] = deleteRequest.version();
        preVersionTypes[requestIndex] = deleteRequest.versionType();
        try {
            TransportWriteAction.WriteResult<DeleteResponse> writeResult = TransportDeleteAction.executeDeleteRequestOnPrimary(deleteRequest, indexShard);
            DeleteResponse deleteResponse = writeResult.getResponse();
            location = this.locationToSync(location, writeResult.getLocation());
            this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_DELETE, deleteResponse));
        }
        catch (Exception e) {
            if (this.retryPrimaryException(e)) {
                for (int j = 0; j < requestIndex; ++j) {
                    this.applyVersion(request.items()[j], preVersions[j], preVersionTypes[j]);
                }
                throw (ElasticsearchException)e;
            }
            this.logFailure(e, OP_TYPE_DELETE, request.shardId(), deleteRequest);
            if (item.getPrimaryResponse() != null && ReplicationOperation.isConflictException(e)) {
                this.setResponse(item, item.getPrimaryResponse());
            }
            this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_DELETE, new BulkItemResponse.Failure(request.index(), deleteRequest.type(), deleteRequest.id(), e)));
        }
        return location;
    }

    private Tuple<Translog.Location, BulkItemRequest> update(IndexMetaData metaData, BulkShardRequest request, IndexShard indexShard, long[] preVersions, VersionType[] preVersionTypes, Translog.Location location, int requestIndex, BulkItemRequest item) {
        UpdateRequest updateRequest = (UpdateRequest)item.request();
        preVersions[requestIndex] = updateRequest.version();
        preVersionTypes[requestIndex] = updateRequest.versionType();
        block11: for (int updateAttemptsCount = 0; updateAttemptsCount <= updateRequest.retryOnConflict(); ++updateAttemptsCount) {
            UpdateResult updateResult;
            try {
                updateResult = this.shardUpdateOperation(metaData, request, updateRequest, indexShard);
            }
            catch (Exception t) {
                updateResult = new UpdateResult(null, null, false, t, null);
            }
            if (updateResult.success()) {
                if (updateResult.writeResult != null) {
                    location = this.locationToSync(location, updateResult.writeResult.getLocation());
                }
                switch (updateResult.result.getResponseResult()) {
                    case CREATED: 
                    case UPDATED: {
                        TransportWriteAction.WriteResult result = updateResult.writeResult;
                        IndexRequest indexRequest = (IndexRequest)updateResult.request();
                        BytesReference indexSourceAsBytes = indexRequest.source();
                        IndexResponse indexResponse = (IndexResponse)result.getResponse();
                        UpdateResponse updateResponse = new UpdateResponse(indexResponse.getShardInfo(), indexResponse.getShardId(), indexResponse.getType(), indexResponse.getId(), indexResponse.getVersion(), indexResponse.getResult());
                        if (updateRequest.fetchSource() != null && updateRequest.fetchSource().fetchSource() || updateRequest.fields() != null && updateRequest.fields().length > 0) {
                            Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(indexSourceAsBytes, true);
                            updateResponse.setGetResult(this.updateHelper.extractGetResult(updateRequest, request.index(), indexResponse.getVersion(), sourceAndContent.v2(), sourceAndContent.v1(), indexSourceAsBytes));
                        }
                        BulkItemRequest bulkItemRequest = new BulkItemRequest(request.items()[requestIndex].id(), indexRequest);
                        request.items()[requestIndex] = bulkItemRequest;
                        item = bulkItemRequest;
                        this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, updateResponse));
                        break block11;
                    }
                    case DELETED: {
                        TransportWriteAction.WriteResult writeResult = updateResult.writeResult;
                        DeleteResponse response = (DeleteResponse)writeResult.getResponse();
                        DeleteRequest deleteRequest = (DeleteRequest)updateResult.request();
                        UpdateResponse updateResponse = new UpdateResponse(response.getShardInfo(), response.getShardId(), response.getType(), response.getId(), response.getVersion(), response.getResult());
                        updateResponse.setGetResult(this.updateHelper.extractGetResult(updateRequest, request.index(), response.getVersion(), updateResult.result.updatedSourceAsMap(), updateResult.result.updateSourceContentType(), null));
                        BulkItemRequest bulkItemRequest = new BulkItemRequest(request.items()[requestIndex].id(), deleteRequest);
                        request.items()[requestIndex] = bulkItemRequest;
                        item = bulkItemRequest;
                        this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, updateResponse));
                        break block11;
                    }
                    case NOOP: {
                        this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, updateResult.noopResult));
                        item.setIgnoreOnReplica();
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException("Illegal operation " + updateResult.result.getResponseResult());
                    }
                }
            }
            if (!updateResult.failure()) continue;
            Throwable e = updateResult.error;
            if (updateResult.retry) {
                if (updateAttemptsCount < updateRequest.retryOnConflict()) continue;
                this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, new BulkItemResponse.Failure(request.index(), updateRequest.type(), updateRequest.id(), e)));
                continue;
            }
            if (this.retryPrimaryException(e)) {
                for (int j = 0; j < requestIndex; ++j) {
                    this.applyVersion(request.items()[j], preVersions[j], preVersionTypes[j]);
                }
                throw (ElasticsearchException)e;
            }
            if (item.getPrimaryResponse() != null && ReplicationOperation.isConflictException(e)) {
                this.setResponse(item, item.getPrimaryResponse());
                break;
            }
            if (updateResult.result == null) {
                this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, new BulkItemResponse.Failure(request.index(), updateRequest.type(), updateRequest.id(), e)));
                break;
            }
            switch (updateResult.result.getResponseResult()) {
                case CREATED: 
                case UPDATED: {
                    IndexRequest indexRequest = (IndexRequest)updateResult.request();
                    this.logFailure(e, "index", request.shardId(), indexRequest);
                    this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_UPDATE, new BulkItemResponse.Failure(request.index(), indexRequest.type(), indexRequest.id(), e)));
                    break block11;
                }
                case DELETED: {
                    DeleteRequest deleteRequest = (DeleteRequest)updateResult.request();
                    this.logFailure(e, OP_TYPE_DELETE, request.shardId(), deleteRequest);
                    this.setResponse(item, new BulkItemResponse(item.id(), OP_TYPE_DELETE, new BulkItemResponse.Failure(request.index(), deleteRequest.type(), deleteRequest.id(), e)));
                    break block11;
                }
                default: {
                    throw new IllegalStateException("Illegal operation " + updateResult.result.getResponseResult());
                }
            }
        }
        return Tuple.tuple(location, item);
    }

    private void setResponse(BulkItemRequest request, BulkItemResponse response) {
        request.setPrimaryResponse(response);
        if (response.isFailed()) {
            request.setIgnoreOnReplica();
        } else {
            ((ReplicationResponse)response.getResponse()).setShardInfo(new ReplicationResponse.ShardInfo());
        }
    }

    private TransportWriteAction.WriteResult<IndexResponse> shardIndexOperation(BulkShardRequest request, IndexRequest indexRequest, IndexMetaData metaData, IndexShard indexShard, boolean processed) throws Exception {
        MappingMetaData mappingMd = metaData.mappingOrDefault(indexRequest.type());
        if (!processed) {
            indexRequest.process(mappingMd, this.allowIdGeneration, request.index());
        }
        return TransportIndexAction.executeIndexRequestOnPrimary(indexRequest, indexShard, this.mappingUpdatedAction);
    }

    private UpdateResult shardUpdateOperation(IndexMetaData metaData, BulkShardRequest bulkShardRequest, UpdateRequest updateRequest, IndexShard indexShard) {
        UpdateHelper.Result translate = this.updateHelper.prepare(updateRequest, indexShard);
        switch (translate.getResponseResult()) {
            case CREATED: 
            case UPDATED: {
                IndexRequest indexRequest = (IndexRequest)translate.action();
                try {
                    TransportWriteAction.WriteResult<IndexResponse> result = this.shardIndexOperation(bulkShardRequest, indexRequest, metaData, indexShard, false);
                    return new UpdateResult(translate, indexRequest, result);
                }
                catch (Exception e) {
                    Throwable cause = ExceptionsHelper.unwrapCause(e);
                    boolean retry = false;
                    if (cause instanceof VersionConflictEngineException) {
                        retry = true;
                    }
                    return new UpdateResult(translate, indexRequest, retry, cause, null);
                }
            }
            case DELETED: {
                DeleteRequest deleteRequest = (DeleteRequest)translate.action();
                try {
                    TransportWriteAction.WriteResult<DeleteResponse> result = TransportDeleteAction.executeDeleteRequestOnPrimary(deleteRequest, indexShard);
                    return new UpdateResult(translate, deleteRequest, result);
                }
                catch (Exception e) {
                    Throwable cause = ExceptionsHelper.unwrapCause(e);
                    boolean retry = false;
                    if (cause instanceof VersionConflictEngineException) {
                        retry = true;
                    }
                    return new UpdateResult(translate, deleteRequest, retry, cause, null);
                }
            }
            case NOOP: {
                UpdateResponse updateResponse = (UpdateResponse)translate.action();
                indexShard.noopUpdate(updateRequest.type());
                return new UpdateResult(translate, updateResponse);
            }
        }
        throw new IllegalStateException("Illegal update operation " + translate.getResponseResult());
    }

    @Override
    protected Translog.Location onReplicaShard(BulkShardRequest request, IndexShard indexShard) {
        Translog.Location location = null;
        for (int i = 0; i < request.items().length; ++i) {
            BulkItemRequest item = request.items()[i];
            if (item == null || item.isIgnoreOnReplica()) continue;
            if (item.request() instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)item.request();
                try {
                    Engine.Index operation = TransportIndexAction.executeIndexRequestOnReplica(indexRequest, indexShard);
                    location = this.locationToSync(location, operation.getTranslogLocation());
                    continue;
                }
                catch (Exception e) {
                    if (ReplicationOperation.ignoreReplicaException(e)) continue;
                    throw e;
                }
            }
            if (item.request() instanceof DeleteRequest) {
                DeleteRequest deleteRequest = (DeleteRequest)item.request();
                try {
                    Engine.Delete delete = TransportDeleteAction.executeDeleteRequestOnReplica(deleteRequest, indexShard);
                    indexShard.delete(delete);
                    location = this.locationToSync(location, delete.getTranslogLocation());
                    continue;
                }
                catch (Exception e) {
                    if (ReplicationOperation.ignoreReplicaException(e)) continue;
                    throw e;
                }
            }
            throw new IllegalStateException("Unexpected index operation: " + item.request());
        }
        return location;
    }

    private void applyVersion(BulkItemRequest item, long version, VersionType versionType) {
        if (item.request() instanceof IndexRequest) {
            ((IndexRequest)item.request()).version(version).versionType(versionType);
        } else if (item.request() instanceof DeleteRequest) {
            ((DeleteRequest)item.request()).version(version).versionType();
        } else if (item.request() instanceof UpdateRequest) {
            ((UpdateRequest)item.request()).version(version).versionType();
        }
    }

    private Translog.Location locationToSync(Translog.Location current, Translog.Location next) {
        assert (next != null) : "next operation can't be null";
        assert (current == null || current.compareTo(next) < 0) : "translog locations are not increasing";
        return next;
    }

    static class UpdateResult {
        final UpdateHelper.Result result;
        final ActionRequest actionRequest;
        final boolean retry;
        final Throwable error;
        final TransportWriteAction.WriteResult writeResult;
        final UpdateResponse noopResult;

        UpdateResult(UpdateHelper.Result result, ActionRequest actionRequest, boolean retry, Throwable error, TransportWriteAction.WriteResult writeResult) {
            this.result = result;
            this.actionRequest = actionRequest;
            this.retry = retry;
            this.error = error;
            this.writeResult = writeResult;
            this.noopResult = null;
        }

        UpdateResult(UpdateHelper.Result result, ActionRequest actionRequest, TransportWriteAction.WriteResult writeResult) {
            this.result = result;
            this.actionRequest = actionRequest;
            this.writeResult = writeResult;
            this.retry = false;
            this.error = null;
            this.noopResult = null;
        }

        public UpdateResult(UpdateHelper.Result result, UpdateResponse updateResponse) {
            this.result = result;
            this.noopResult = updateResponse;
            this.actionRequest = null;
            this.writeResult = null;
            this.retry = false;
            this.error = null;
        }

        boolean failure() {
            return this.error != null;
        }

        boolean success() {
            return this.noopResult != null || this.writeResult != null;
        }

        <T extends ActionRequest> T request() {
            return (T)this.actionRequest;
        }
    }
}

