/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.PriorityComparator;

public class BalancedShardsAllocator
extends AbstractComponent
implements ShardsAllocator {
    public static final Setting<Float> INDEX_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.index", 0.55f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> SHARD_BALANCE_FACTOR_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.shard", 0.45f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Float> THRESHOLD_SETTING = Setting.floatSetting("cluster.routing.allocation.balance.threshold", 1.0f, 0.0f, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile WeightFunction weightFunction;
    private volatile float threshold;

    public BalancedShardsAllocator(Settings settings) {
        this(settings, new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
    }

    @Inject
    public BalancedShardsAllocator(Settings settings, ClusterSettings clusterSettings) {
        super(settings);
        this.setWeightFunction(INDEX_BALANCE_FACTOR_SETTING.get(settings).floatValue(), SHARD_BALANCE_FACTOR_SETTING.get(settings).floatValue());
        this.setThreshold(THRESHOLD_SETTING.get(settings).floatValue());
        clusterSettings.addSettingsUpdateConsumer(INDEX_BALANCE_FACTOR_SETTING, SHARD_BALANCE_FACTOR_SETTING, this::setWeightFunction);
        clusterSettings.addSettingsUpdateConsumer(THRESHOLD_SETTING, this::setThreshold);
    }

    private void setWeightFunction(float indexBalance, float shardBalanceFactor) {
        this.weightFunction = new WeightFunction(indexBalance, shardBalanceFactor);
    }

    private void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    @Override
    public Map<DiscoveryNode, Float> weighShard(RoutingAllocation allocation, ShardRouting shard) {
        Balancer balancer = new Balancer(this.logger, allocation, this.weightFunction, this.threshold);
        return balancer.weighShard(shard);
    }

    @Override
    public void allocate(RoutingAllocation allocation) {
        if (allocation.routingNodes().size() == 0) {
            return;
        }
        Balancer balancer = new Balancer(this.logger, allocation, this.weightFunction, this.threshold);
        balancer.allocateUnassigned();
        balancer.moveShards();
        balancer.balance();
    }

    public float getThreshold() {
        return this.threshold;
    }

    public float getIndexBalance() {
        return this.weightFunction.indexBalance;
    }

    public float getShardBalance() {
        return this.weightFunction.shardBalance;
    }

    static final class NodeSorter
    extends IntroSorter {
        final ModelNode[] modelNodes;
        final float[] weights;
        private final WeightFunction function;
        private String index;
        private final Balancer balancer;
        private float pivotWeight;

        public NodeSorter(ModelNode[] modelNodes, WeightFunction function, Balancer balancer) {
            this.function = function;
            this.balancer = balancer;
            this.modelNodes = modelNodes;
            this.weights = new float[modelNodes.length];
        }

        public void reset(String index, int from, int to) {
            this.index = index;
            for (int i = from; i < to; ++i) {
                this.weights[i] = this.weight(this.modelNodes[i]);
            }
            this.sort(from, to);
        }

        public void reset(String index) {
            this.reset(index, 0, this.modelNodes.length);
        }

        public float weight(ModelNode node) {
            return this.function.weight(this.balancer, node, this.index);
        }

        protected void swap(int i, int j) {
            ModelNode tmpNode = this.modelNodes[i];
            this.modelNodes[i] = this.modelNodes[j];
            this.modelNodes[j] = tmpNode;
            float tmpWeight = this.weights[i];
            this.weights[i] = this.weights[j];
            this.weights[j] = tmpWeight;
        }

        protected int compare(int i, int j) {
            return Float.compare(this.weights[i], this.weights[j]);
        }

        protected void setPivot(int i) {
            this.pivotWeight = this.weights[i];
        }

        protected int comparePivot(int j) {
            return Float.compare(this.pivotWeight, this.weights[j]);
        }

        public float delta() {
            return this.weights[this.weights.length - 1] - this.weights[0];
        }
    }

    static final class ModelIndex
    implements Iterable<ShardRouting> {
        private final String id;
        private final Set<ShardRouting> shards = new HashSet<ShardRouting>(4);
        private int highestPrimary = -1;

        public ModelIndex(String id) {
            this.id = id;
        }

        public int highestPrimary() {
            if (this.highestPrimary == -1) {
                int maxId = -1;
                for (ShardRouting shard : this.shards) {
                    if (!shard.primary()) continue;
                    maxId = Math.max(maxId, shard.id());
                }
                this.highestPrimary = maxId;
                return this.highestPrimary;
            }
            return this.highestPrimary;
        }

        public String getIndexId() {
            return this.id;
        }

        public int numShards() {
            return this.shards.size();
        }

        @Override
        public Iterator<ShardRouting> iterator() {
            return this.shards.iterator();
        }

        public void removeShard(ShardRouting shard) {
            this.highestPrimary = -1;
            assert (this.shards.contains(shard)) : "Shard not allocated on current node: " + shard;
            this.shards.remove(shard);
        }

        public void addShard(ShardRouting shard) {
            this.highestPrimary = -1;
            assert (!this.shards.contains(shard)) : "Shard already allocated on current node: " + shard;
            this.shards.add(shard);
        }

        public boolean containsShard(ShardRouting shard) {
            return this.shards.contains(shard);
        }
    }

    static class ModelNode
    implements Iterable<ModelIndex> {
        private final Map<String, ModelIndex> indices = new HashMap<String, ModelIndex>();
        private int numShards = 0;
        private final RoutingNode routingNode;

        public ModelNode(RoutingNode routingNode) {
            this.routingNode = routingNode;
        }

        public ModelIndex getIndex(String indexId) {
            return this.indices.get(indexId);
        }

        public String getNodeId() {
            return this.routingNode.nodeId();
        }

        public RoutingNode getRoutingNode() {
            return this.routingNode;
        }

        public int numShards() {
            return this.numShards;
        }

        public int numShards(String idx) {
            ModelIndex index = this.indices.get(idx);
            return index == null ? 0 : index.numShards();
        }

        public int highestPrimary(String index) {
            ModelIndex idx = this.indices.get(index);
            if (idx != null) {
                return idx.highestPrimary();
            }
            return -1;
        }

        public void addShard(ShardRouting shard) {
            ModelIndex index = this.indices.get(shard.getIndexName());
            if (index == null) {
                index = new ModelIndex(shard.getIndexName());
                this.indices.put(index.getIndexId(), index);
            }
            index.addShard(shard);
            ++this.numShards;
        }

        public void removeShard(ShardRouting shard) {
            ModelIndex index = this.indices.get(shard.getIndexName());
            if (index != null) {
                index.removeShard(shard);
                if (index.numShards() == 0) {
                    this.indices.remove(shard.getIndexName());
                }
            }
            --this.numShards;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node(").append(this.routingNode.nodeId()).append(")");
            return sb.toString();
        }

        @Override
        public Iterator<ModelIndex> iterator() {
            return this.indices.values().iterator();
        }

        public boolean containsShard(ShardRouting shard) {
            ModelIndex index = this.getIndex(shard.getIndexName());
            return index == null ? false : index.containsShard(shard);
        }
    }

    public static class Balancer {
        private final Logger logger;
        private final Map<String, ModelNode> nodes = new HashMap<String, ModelNode>();
        private final RoutingAllocation allocation;
        private final RoutingNodes routingNodes;
        private final WeightFunction weight;
        private final float threshold;
        private final MetaData metaData;
        private final float avgShardsPerNode;

        public Balancer(Logger logger, RoutingAllocation allocation, WeightFunction weight, float threshold) {
            this.logger = logger;
            this.allocation = allocation;
            this.weight = weight;
            this.threshold = threshold;
            this.routingNodes = allocation.routingNodes();
            this.metaData = allocation.metaData();
            this.avgShardsPerNode = (float)this.metaData.getTotalNumberOfShards() / (float)this.routingNodes.size();
            this.buildModelFromAssigned();
        }

        private ModelNode[] nodesArray() {
            return this.nodes.values().toArray(new ModelNode[this.nodes.size()]);
        }

        public float avgShardsPerNode(String index) {
            return (float)this.metaData.index(index).getTotalNumberOfShards() / (float)this.nodes.size();
        }

        public float avgShardsPerNode() {
            return this.avgShardsPerNode;
        }

        private NodeSorter newNodeSorter() {
            return new NodeSorter(this.nodesArray(), this.weight, this);
        }

        private static float absDelta(float lower, float higher) {
            assert (higher >= lower) : higher + " lt " + lower + " but was expected to be gte";
            return Math.abs(higher - lower);
        }

        private static boolean lessThan(float delta, float threshold) {
            return delta <= threshold + 0.001f;
        }

        private void balance() {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Start balancing cluster");
            }
            if (this.allocation.hasPendingAsyncFetch()) {
                this.logger.debug("skipping rebalance due to in-flight shard/store fetches");
                return;
            }
            if (this.allocation.deciders().canRebalance(this.allocation).type() != Decision.Type.YES) {
                this.logger.trace("skipping rebalance as it is disabled");
                return;
            }
            if (this.nodes.size() < 2) {
                this.logger.trace("skipping rebalance as single node only");
                return;
            }
            this.balanceByWeights();
        }

        public Map<DiscoveryNode, Float> weighShard(ShardRouting shard) {
            int i;
            NodeSorter sorter = this.newNodeSorter();
            ModelNode[] modelNodes = sorter.modelNodes;
            float[] weights = sorter.weights;
            this.buildWeightOrderedIndices(sorter);
            HashMap<DiscoveryNode, Float> nodes = new HashMap<DiscoveryNode, Float>(modelNodes.length);
            float currentNodeWeight = 0.0f;
            for (i = 0; i < modelNodes.length; ++i) {
                if (!modelNodes[i].getNodeId().equals(shard.currentNodeId())) continue;
                currentNodeWeight = weights[i];
                break;
            }
            for (i = 0; i < modelNodes.length; ++i) {
                float delta = currentNodeWeight - weights[i];
                nodes.put(modelNodes[i].getRoutingNode().node(), Float.valueOf(delta));
            }
            return nodes;
        }

        private void balanceByWeights() {
            NodeSorter sorter = this.newNodeSorter();
            AllocationDeciders deciders = this.allocation.deciders();
            ModelNode[] modelNodes = sorter.modelNodes;
            float[] weights = sorter.weights;
            block0: for (String index : this.buildWeightOrderedIndices(sorter)) {
                IndexMetaData indexMetaData = this.metaData.index(index);
                int relevantNodes = 0;
                for (int i = 0; i < modelNodes.length; ++i) {
                    ModelNode modelNode = modelNodes[i];
                    if (modelNode.getIndex(index) == null && deciders.canAllocate(indexMetaData, modelNode.getRoutingNode(), this.allocation).type() == Decision.Type.NO) continue;
                    modelNodes[i] = modelNodes[relevantNodes];
                    modelNodes[relevantNodes] = modelNode;
                    ++relevantNodes;
                }
                if (relevantNodes < 2) continue;
                sorter.reset(index, 0, relevantNodes);
                int lowIdx = 0;
                int highIdx = relevantNodes - 1;
                while (true) {
                    ModelNode minNode = modelNodes[lowIdx];
                    ModelNode maxNode = modelNodes[highIdx];
                    if (maxNode.numShards(index) > 0) {
                        float delta = Balancer.absDelta(weights[lowIdx], weights[highIdx]);
                        if (Balancer.lessThan(delta, this.threshold)) {
                            if (lowIdx <= 0 || highIdx - 1 <= 0 || !(Balancer.absDelta(weights[0], weights[highIdx - 1]) > this.threshold)) {
                                if (!this.logger.isTraceEnabled()) continue block0;
                                this.logger.trace("Stop balancing index [{}]  min_node [{}] weight: [{}]  max_node [{}] weight: [{}]  delta: [{}]", (Object)index, (Object)maxNode.getNodeId(), (Object)Float.valueOf(weights[highIdx]), (Object)minNode.getNodeId(), (Object)Float.valueOf(weights[lowIdx]), (Object)Float.valueOf(delta));
                                continue block0;
                            }
                        } else {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Balancing from node [{}] weight: [{}] to node [{}] weight: [{}]  delta: [{}]", (Object)maxNode.getNodeId(), (Object)Float.valueOf(weights[highIdx]), (Object)minNode.getNodeId(), (Object)Float.valueOf(weights[lowIdx]), (Object)Float.valueOf(delta));
                            }
                            if (this.tryRelocateShard(minNode, maxNode, index, delta)) {
                                weights[lowIdx] = sorter.weight(modelNodes[lowIdx]);
                                weights[highIdx] = sorter.weight(modelNodes[highIdx]);
                                sorter.sort(0, relevantNodes);
                                lowIdx = 0;
                                highIdx = relevantNodes - 1;
                                continue;
                            }
                        }
                    }
                    if (lowIdx < highIdx - 1) {
                        ++lowIdx;
                        continue;
                    }
                    if (lowIdx <= 0) continue block0;
                    lowIdx = 0;
                    --highIdx;
                }
            }
        }

        private String[] buildWeightOrderedIndices(NodeSorter sorter) {
            final String[] indices = (String[])this.allocation.routingTable().indicesRouting().keys().toArray(String.class);
            final float[] deltas = new float[indices.length];
            for (int i = 0; i < deltas.length; ++i) {
                sorter.reset(indices[i]);
                deltas[i] = sorter.delta();
            }
            new IntroSorter(){
                float pivotWeight;

                protected void swap(int i, int j) {
                    String tmpIdx = indices[i];
                    indices[i] = indices[j];
                    indices[j] = tmpIdx;
                    float tmpDelta = deltas[i];
                    deltas[i] = deltas[j];
                    deltas[j] = tmpDelta;
                }

                protected int compare(int i, int j) {
                    return Float.compare(deltas[j], deltas[i]);
                }

                protected void setPivot(int i) {
                    this.pivotWeight = deltas[i];
                }

                protected int comparePivot(int j) {
                    return Float.compare(deltas[j], this.pivotWeight);
                }
            }.sort(0, deltas.length);
            return indices;
        }

        public void moveShards() {
            NodeSorter sorter = this.newNodeSorter();
            Iterator<ShardRouting> it = this.allocation.routingNodes().nodeInterleavedShardIterator();
            while (it.hasNext()) {
                ShardRouting shardRouting = it.next();
                if (!shardRouting.started()) continue;
                ModelNode sourceNode = this.nodes.get(shardRouting.currentNodeId());
                assert (sourceNode != null && sourceNode.containsShard(shardRouting));
                RoutingNode routingNode = sourceNode.getRoutingNode();
                Decision decision = this.allocation.deciders().canRemain(shardRouting, routingNode, this.allocation);
                if (decision.type() != Decision.Type.NO) continue;
                this.moveShard(sorter, shardRouting, sourceNode, routingNode);
            }
        }

        private void moveShard(NodeSorter sorter, ShardRouting shardRouting, ModelNode sourceNode, RoutingNode routingNode) {
            this.logger.debug("[{}][{}] allocated on [{}], but can no longer be allocated on it, moving...", (Object)shardRouting.index(), (Object)shardRouting.id(), (Object)routingNode.node());
            sorter.reset(shardRouting.getIndexName());
            for (ModelNode currentNode : sorter.modelNodes) {
                if (currentNode == sourceNode) continue;
                RoutingNode target = currentNode.getRoutingNode();
                Decision allocationDecision = this.allocation.deciders().canAllocate(shardRouting, target, this.allocation);
                if (allocationDecision.type() != Decision.Type.YES) continue;
                sourceNode.removeShard(shardRouting);
                Tuple<ShardRouting, ShardRouting> relocatingShards = this.routingNodes.relocateShard(shardRouting, target.nodeId(), this.allocation.clusterInfo().getShardSize(shardRouting, -1L), this.allocation.changes());
                currentNode.addShard(relocatingShards.v2());
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Moved shard [{}] to node [{}]", (Object)shardRouting, (Object)routingNode.node());
                }
                return;
            }
            this.logger.debug("[{}][{}] can't move", (Object)shardRouting.index(), (Object)shardRouting.id());
        }

        private void buildModelFromAssigned() {
            for (RoutingNode rn : this.routingNodes) {
                ModelNode node = new ModelNode(rn);
                this.nodes.put(rn.nodeId(), node);
                for (ShardRouting shard : rn) {
                    assert (rn.nodeId().equals(shard.currentNodeId()));
                    if (shard.state() == ShardRoutingState.RELOCATING) continue;
                    node.addShard(shard);
                    if (!this.logger.isTraceEnabled()) continue;
                    this.logger.trace("Assigned shard [{}] to node [{}]", (Object)shard, (Object)node.getNodeId());
                }
            }
        }

        private void allocateUnassigned() {
            RoutingNodes.UnassignedShards unassigned = this.routingNodes.unassigned();
            assert (!this.nodes.isEmpty());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Start allocating unassigned shards");
            }
            if (unassigned.isEmpty()) {
                return;
            }
            AllocationDeciders deciders = this.allocation.deciders();
            PriorityComparator secondaryComparator = PriorityComparator.getAllocationComparator(this.allocation);
            Comparator comparator = (o1, o2) -> {
                if (o1.primary() ^ o2.primary()) {
                    return o1.primary() ? -1 : (o2.primary() ? 1 : 0);
                }
                int indexCmp = o1.getIndexName().compareTo(o2.getIndexName());
                if (indexCmp == 0) {
                    return o1.getId() - o2.getId();
                }
                int secondary = secondaryComparator.compare((ShardRouting)o1, (ShardRouting)o2);
                return secondary == 0 ? indexCmp : secondary;
            };
            Object[] primary = unassigned.drain();
            Object[] secondary = new ShardRouting[primary.length];
            int secondaryLength = 0;
            int primaryLength = primary.length;
            ArrayUtil.timSort((Object[])primary, (Comparator)comparator);
            Set throttledNodes = Collections.newSetFromMap(new IdentityHashMap());
            do {
                for (int i = 0; i < primaryLength; ++i) {
                    Object shard = primary[i];
                    if (!((ShardRouting)shard).primary()) {
                        Decision decision = deciders.canAllocate((ShardRouting)shard, this.allocation);
                        if (decision.type() == Decision.Type.NO) {
                            UnassignedInfo.AllocationStatus allocationStatus = UnassignedInfo.AllocationStatus.fromDecision(decision);
                            unassigned.ignoreShard((ShardRouting)shard, allocationStatus, this.allocation.changes());
                            while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                                unassigned.ignoreShard((ShardRouting)primary[++i], allocationStatus, this.allocation.changes());
                            }
                            continue;
                        }
                        while (i < primaryLength - 1 && comparator.compare(primary[i], primary[i + 1]) == 0) {
                            secondary[secondaryLength++] = primary[++i];
                        }
                    }
                    assert (!((ShardRouting)shard).assignedToNode()) : shard;
                    float minWeight = Float.POSITIVE_INFINITY;
                    ModelNode minNode = null;
                    Decision decision = null;
                    if (throttledNodes.size() < this.nodes.size()) {
                        for (ModelNode node : this.nodes.values()) {
                            Decision currentDecision;
                            float currentWeight;
                            if (throttledNodes.contains(node) || node.containsShard((ShardRouting)shard) || !((currentWeight = this.weight.weightShardAdded(this, node, ((ShardRouting)shard).getIndexName())) <= minWeight) || (currentDecision = deciders.canAllocate((ShardRouting)shard, node.getRoutingNode(), this.allocation)).type() != Decision.Type.YES && currentDecision.type() != Decision.Type.THROTTLE) continue;
                            if (currentWeight == minWeight) {
                                if (currentDecision.type() == decision.type()) {
                                    int repId = ((ShardRouting)shard).id();
                                    int nodeHigh = node.highestPrimary(((ShardRouting)shard).index().getName());
                                    int minNodeHigh = minNode.highestPrimary(((ShardRouting)shard).getIndexName());
                                    if (!((nodeHigh > repId && minNodeHigh > repId || nodeHigh < repId && minNodeHigh < repId) && nodeHigh < minNodeHigh) && (nodeHigh <= minNodeHigh || nodeHigh <= repId || minNodeHigh >= repId)) continue;
                                } else if (currentDecision.type() != Decision.Type.YES) continue;
                            }
                            minNode = node;
                            minWeight = currentWeight;
                            decision = currentDecision;
                        }
                    }
                    assert (decision == null == (minNode == null));
                    if (minNode != null) {
                        long shardSize = DiskThresholdDecider.getExpectedShardSize((ShardRouting)shard, this.allocation, -1L);
                        if (decision.type() == Decision.Type.YES) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Assigned shard [{}] to [{}]", shard, (Object)minNode.getNodeId());
                            }
                            shard = this.routingNodes.initializeShard((ShardRouting)shard, minNode.getNodeId(), null, shardSize, this.allocation.changes());
                            minNode.addShard((ShardRouting)shard);
                            continue;
                        }
                        minNode.addShard(((ShardRouting)shard).initialize(minNode.getNodeId(), null, shardSize));
                        RoutingNode node = minNode.getRoutingNode();
                        Decision.Type nodeLevelDecision = deciders.canAllocate(node, this.allocation).type();
                        if (nodeLevelDecision != Decision.Type.YES) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Can not allocate on node [{}] remove from round decision [{}]", (Object)node, (Object)decision.type());
                            }
                            assert (nodeLevelDecision == Decision.Type.NO);
                            throttledNodes.add(minNode);
                        }
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("No eligible node found to assign shard [{}] decision [{}]", shard, (Object)decision.type());
                        }
                    } else if (this.logger.isTraceEnabled()) {
                        this.logger.trace("No Node found to assign shard [{}]", shard);
                    }
                    assert (decision == null || decision.type() == Decision.Type.THROTTLE);
                    UnassignedInfo.AllocationStatus allocationStatus = decision == null ? UnassignedInfo.AllocationStatus.DECIDERS_NO : UnassignedInfo.AllocationStatus.fromDecision(decision);
                    unassigned.ignoreShard((ShardRouting)shard, allocationStatus, this.allocation.changes());
                    if (((ShardRouting)shard).primary()) continue;
                    while (secondaryLength > 0 && comparator.compare(shard, secondary[secondaryLength - 1]) == 0) {
                        unassigned.ignoreShard((ShardRouting)secondary[--secondaryLength], allocationStatus, this.allocation.changes());
                    }
                }
                primaryLength = secondaryLength;
                Object[] tmp = primary;
                primary = secondary;
                secondary = tmp;
                secondaryLength = 0;
            } while (primaryLength > 0);
        }

        private boolean tryRelocateShard(ModelNode minNode, ModelNode maxNode, String idx, float minCost) {
            ModelIndex index = maxNode.getIndex(idx);
            Decision decision = null;
            if (index != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Try relocating shard for index index [{}] from node [{}] to node [{}]", (Object)idx, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                }
                ShardRouting candidate = null;
                AllocationDeciders deciders = this.allocation.deciders();
                for (ShardRouting shard : index) {
                    float delta;
                    if (!shard.started()) continue;
                    Decision allocationDecision = deciders.canAllocate(shard, minNode.getRoutingNode(), this.allocation);
                    Decision rebalanceDecision = deciders.canRebalance(shard, this.allocation);
                    if (allocationDecision.type() != Decision.Type.YES && allocationDecision.type() != Decision.Type.THROTTLE || rebalanceDecision.type() != Decision.Type.YES && rebalanceDecision.type() != Decision.Type.THROTTLE || !maxNode.containsShard(shard) || !((delta = this.weight.weightShardAdded(this, minNode, idx) - this.weight.weightShardRemoved(this, maxNode, idx)) < minCost) && (candidate == null || delta != minCost || candidate.id() <= shard.id())) continue;
                    minCost = delta;
                    candidate = shard;
                    decision = new Decision.Multi().add(allocationDecision).add(rebalanceDecision);
                }
                if (candidate != null) {
                    maxNode.removeShard(candidate);
                    long shardSize = this.allocation.clusterInfo().getShardSize(candidate, -1L);
                    if (decision.type() == Decision.Type.YES) {
                        this.logger.debug("Relocate shard [{}] from node [{}] to node [{}]", (Object)candidate, (Object)maxNode.getNodeId(), (Object)minNode.getNodeId());
                        minNode.addShard(this.routingNodes.relocateShard(candidate, minNode.getNodeId(), shardSize, this.allocation.changes()).v1());
                        return true;
                    }
                    assert (decision.type() == Decision.Type.THROTTLE);
                    minNode.addShard(candidate.relocate(minNode.getNodeId(), shardSize));
                }
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Couldn't find shard to relocate from node [{}] to node [{}] allocation decision [{}]", (Object)maxNode.getNodeId(), (Object)minNode.getNodeId(), (Object)(decision == null ? "NO" : decision.type().name()));
            }
            return false;
        }
    }

    public static class WeightFunction {
        private final float indexBalance;
        private final float shardBalance;
        private final float theta0;
        private final float theta1;

        public WeightFunction(float indexBalance, float shardBalance) {
            float sum = indexBalance + shardBalance;
            if (sum <= 0.0f) {
                throw new IllegalArgumentException("Balance factors must sum to a value > 0 but was: " + sum);
            }
            this.theta0 = shardBalance / sum;
            this.theta1 = indexBalance / sum;
            this.indexBalance = indexBalance;
            this.shardBalance = shardBalance;
        }

        public float weight(Balancer balancer, ModelNode node, String index) {
            return this.weight(balancer, node, index, 0);
        }

        public float weightShardAdded(Balancer balancer, ModelNode node, String index) {
            return this.weight(balancer, node, index, 1);
        }

        public float weightShardRemoved(Balancer balancer, ModelNode node, String index) {
            return this.weight(balancer, node, index, -1);
        }

        private float weight(Balancer balancer, ModelNode node, String index, int numAdditionalShards) {
            float weightShard = (float)(node.numShards() + numAdditionalShards) - balancer.avgShardsPerNode();
            float weightIndex = (float)(node.numShards(index) + numAdditionalShards) - balancer.avgShardsPerNode(index);
            return this.theta0 * weightShard + this.theta1 * weightIndex;
        }
    }
}

