/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.transport.TransportAddress;

public final class InetSocketTransportAddress
implements TransportAddress {
    public static final short TYPE_ID = 1;
    private final InetSocketAddress address;

    public InetSocketTransportAddress(InetAddress address, int port) {
        this(new InetSocketAddress(address, port));
    }

    public InetSocketTransportAddress(InetSocketAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("InetSocketAddress must not be null");
        }
        if (address.getAddress() == null) {
            throw new IllegalArgumentException("Address must be resolved but wasn't - InetSocketAddress#getAddress() returned null");
        }
        this.address = address;
    }

    public InetSocketTransportAddress(StreamInput in) throws IOException {
        byte len = in.readByte();
        byte[] a = new byte[len];
        in.readFully(a);
        InetAddress inetAddress = InetAddress.getByAddress(a);
        int port = in.readInt();
        this.address = new InetSocketAddress(inetAddress, port);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        byte[] bytes = this.address().getAddress().getAddress();
        out.writeByte((byte)bytes.length);
        out.write(bytes, 0, bytes.length);
        out.writeInt(this.address.getPort());
    }

    @Override
    public short uniqueAddressTypeId() {
        return 1;
    }

    @Override
    public boolean sameHost(TransportAddress other) {
        return other instanceof InetSocketTransportAddress && this.address.getAddress().equals(((InetSocketTransportAddress)other).address.getAddress());
    }

    @Override
    public boolean isLoopbackOrLinkLocalAddress() {
        return this.address.getAddress().isLinkLocalAddress() || this.address.getAddress().isLoopbackAddress();
    }

    @Override
    public String getHost() {
        return this.getAddress();
    }

    @Override
    public String getAddress() {
        return NetworkAddress.format(this.address.getAddress());
    }

    @Override
    public int getPort() {
        return this.address.getPort();
    }

    public InetSocketAddress address() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InetSocketTransportAddress address1 = (InetSocketTransportAddress)o;
        return this.address.equals(address1.address);
    }

    public int hashCode() {
        return this.address != null ? this.address.hashCode() : 0;
    }

    @Override
    public String toString() {
        return NetworkAddress.format(this.address);
    }
}

