/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Collection;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;

public class KeywordMarkerTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet keywordLookup;

    public KeywordMarkerTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        boolean ignoreCase = settings.getAsBoolean("ignore_case", false);
        CharArraySet rules = Analysis.getWordSet(env, settings, "keywords");
        if (rules == null) {
            throw new IllegalArgumentException("keyword filter requires either `keywords` or `keywords_path` to be configured");
        }
        this.keywordLookup = new CharArraySet((Collection)rules, ignoreCase);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new SetKeywordMarkerFilter(tokenStream, this.keywordLookup);
    }
}

