/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LegacyNumberFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class TypeParsers {
    public static final String DOC_VALUES = "doc_values";
    public static final String INDEX_OPTIONS_DOCS = "docs";
    public static final String INDEX_OPTIONS_FREQS = "freqs";
    public static final String INDEX_OPTIONS_POSITIONS = "positions";
    public static final String INDEX_OPTIONS_OFFSETS = "offsets";
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(TypeParsers.class));
    private static final Set<String> BOOLEAN_STRINGS = new HashSet<String>(Arrays.asList("true", "false"));

    public static boolean nodeBooleanValue(String name, Object node, Mapper.TypeParser.ParserContext parserContext) {
        if (parserContext.parseFieldMatcher().isStrict()) {
            return XContentMapValues.nodeBooleanValue(node);
        }
        if (!BOOLEAN_STRINGS.contains(node.toString())) {
            DEPRECATION_LOGGER.deprecated("Expected a boolean for property [{}] but got [{}]", name, node);
        }
        return XContentMapValues.lenientNodeBooleanValue(node);
    }

    @Deprecated
    public static void parseNumberField(LegacyNumberFieldMapper.Builder builder, String name, Map<String, Object> numberNode, Mapper.TypeParser.ParserContext parserContext) {
        TypeParsers.parseField(builder, name, numberNode, parserContext);
        Iterator<Map.Entry<String, Object>> iterator = numberNode.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String propName = entry.getKey();
            Object propNode = entry.getValue();
            if (propName.equals("precision_step")) {
                builder.precisionStep(XContentMapValues.nodeIntegerValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("ignore_malformed")) {
                builder.ignoreMalformed(TypeParsers.nodeBooleanValue("ignore_malformed", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("coerce")) {
                builder.coerce(TypeParsers.nodeBooleanValue("coerce", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("similarity")) {
                SimilarityProvider similarityProvider = TypeParsers.resolveSimilarity(parserContext, name, propNode.toString());
                builder.similarity(similarityProvider);
                iterator.remove();
                continue;
            }
            if (!TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) continue;
            iterator.remove();
        }
    }

    private static void parseAnalyzersAndTermVectors(FieldMapper.Builder builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        NamedAnalyzer indexAnalyzer = null;
        NamedAnalyzer searchAnalyzer = null;
        NamedAnalyzer searchQuoteAnalyzer = null;
        Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
        while (iterator.hasNext()) {
            NamedAnalyzer analyzer;
            Map.Entry<String, Object> entry = iterator.next();
            String propName = entry.getKey();
            Object propNode = entry.getValue();
            if (propName.equals("term_vector")) {
                TypeParsers.parseTermVector(name, propNode.toString(), builder);
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vectors")) {
                builder.storeTermVectors(TypeParsers.nodeBooleanValue("store_term_vectors", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vector_offsets")) {
                builder.storeTermVectorOffsets(TypeParsers.nodeBooleanValue("store_term_vector_offsets", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vector_positions")) {
                builder.storeTermVectorPositions(TypeParsers.nodeBooleanValue("store_term_vector_positions", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("store_term_vector_payloads")) {
                builder.storeTermVectorPayloads(TypeParsers.nodeBooleanValue("store_term_vector_payloads", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                indexAnalyzer = analyzer;
                iterator.remove();
                continue;
            }
            if (propName.equals("search_analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                searchAnalyzer = analyzer;
                iterator.remove();
                continue;
            }
            if (!propName.equals("search_quote_analyzer")) continue;
            analyzer = parserContext.analysisService().analyzer(propNode.toString());
            if (analyzer == null) {
                throw new MapperParsingException("analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
            }
            searchQuoteAnalyzer = analyzer;
            iterator.remove();
        }
        if (indexAnalyzer == null && searchAnalyzer != null) {
            throw new MapperParsingException("analyzer on field [" + name + "] must be set when search_analyzer is set");
        }
        if (searchAnalyzer == null && searchQuoteAnalyzer != null) {
            throw new MapperParsingException("analyzer and search_analyzer on field [" + name + "] must be set when search_quote_analyzer is set");
        }
        if (searchAnalyzer == null) {
            searchAnalyzer = indexAnalyzer;
        }
        if (searchQuoteAnalyzer == null) {
            searchQuoteAnalyzer = searchAnalyzer;
        }
        if (indexAnalyzer != null) {
            builder.indexAnalyzer(indexAnalyzer);
        }
        if (searchAnalyzer != null) {
            builder.searchAnalyzer(searchAnalyzer);
        }
        if (searchQuoteAnalyzer != null) {
            builder.searchQuoteAnalyzer(searchQuoteAnalyzer);
        }
    }

    public static boolean parseNorms(FieldMapper.Builder builder, String propName, Object propNode, Mapper.TypeParser.ParserContext parserContext) {
        if (propName.equals("norms")) {
            if (propNode instanceof Map) {
                Map<String, Object> properties = XContentMapValues.nodeMapValue(propNode, "norms");
                Iterator<Map.Entry<String, Object>> propsIterator = properties.entrySet().iterator();
                while (propsIterator.hasNext()) {
                    Map.Entry<String, Object> entry2 = propsIterator.next();
                    String propName2 = entry2.getKey();
                    Object propNode2 = entry2.getValue();
                    if (propName2.equals("enabled")) {
                        builder.omitNorms(!XContentMapValues.lenientNodeBooleanValue(propNode2));
                        propsIterator.remove();
                        continue;
                    }
                    if (!propName2.equals("loading")) continue;
                    propsIterator.remove();
                }
                DocumentMapperParser.checkNoRemainingFields(propName, properties, parserContext.indexVersionCreated());
                DEPRECATION_LOGGER.deprecated("The [norms{enabled:true/false}] way of specifying norms is deprecated, please use [norms:true/false] instead", new Object[0]);
            } else {
                builder.omitNorms(!TypeParsers.nodeBooleanValue("norms", propNode, parserContext));
            }
            return true;
        }
        if (propName.equals("omit_norms")) {
            builder.omitNorms(TypeParsers.nodeBooleanValue("norms", propNode, parserContext));
            DEPRECATION_LOGGER.deprecated("[omit_norms] is deprecated, please use [norms] instead with the opposite boolean value", new Object[0]);
            return true;
        }
        return false;
    }

    public static void parseTextField(FieldMapper.Builder builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        TypeParsers.parseField(builder, name, fieldNode, parserContext);
        TypeParsers.parseAnalyzersAndTermVectors(builder, name, fieldNode, parserContext);
        Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
        while (iterator.hasNext()) {
            Object propNode;
            Map.Entry<String, Object> entry = iterator.next();
            String propName = entry.getKey();
            if (!TypeParsers.parseNorms(builder, propName, propNode = entry.getValue(), parserContext)) continue;
            iterator.remove();
        }
    }

    public static void parseField(FieldMapper.Builder builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        Version indexVersionCreated = parserContext.indexVersionCreated();
        Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String propName = entry.getKey();
            Object propNode = entry.getValue();
            if (!propName.equals("null_value") && propNode == null) {
                throw new MapperParsingException("[" + propName + "] must not have a [null] value");
            }
            if (propName.equals("store")) {
                builder.store(TypeParsers.parseStore(name, propNode.toString(), parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("index")) {
                builder.index(TypeParsers.parseIndex(name, propNode.toString(), parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals(DOC_VALUES)) {
                builder.docValues(TypeParsers.nodeBooleanValue(DOC_VALUES, propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("boost")) {
                builder.boost(XContentMapValues.nodeFloatValue(propNode));
                iterator.remove();
                continue;
            }
            if (parserContext.indexVersionCreated().before(Version.V_5_0_0_alpha1) && TypeParsers.parseNorms(builder, propName, propNode, parserContext)) {
                iterator.remove();
                continue;
            }
            if (propName.equals("index_options")) {
                builder.indexOptions(TypeParsers.nodeIndexOptionValue(propNode));
                iterator.remove();
                continue;
            }
            if (propName.equals("include_in_all")) {
                builder.includeInAll(TypeParsers.nodeBooleanValue("include_in_all", propNode, parserContext));
                iterator.remove();
                continue;
            }
            if (propName.equals("similarity")) {
                SimilarityProvider similarityProvider = TypeParsers.resolveSimilarity(parserContext, name, propNode.toString());
                builder.similarity(similarityProvider);
                iterator.remove();
                continue;
            }
            if (propName.equals("fielddata") && propNode instanceof Map && parserContext.indexVersionCreated().before(Version.V_5_0_0_alpha1)) {
                iterator.remove();
                continue;
            }
            if (TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) {
                iterator.remove();
                continue;
            }
            if (!propName.equals("copy_to")) continue;
            if (parserContext.isWithinMultiField()) {
                if (indexVersionCreated.after(Version.V_2_1_0) || indexVersionCreated.after(Version.V_2_0_1) && indexVersionCreated.before(Version.V_2_1_0)) {
                    throw new MapperParsingException("copy_to in multi fields is not allowed. Found the copy_to in field [" + name + "] which is within a multi field.");
                }
                ESLoggerFactory.getLogger("mapping [" + parserContext.type() + "]").warn("Found a copy_to in field [{}] which is within a multi field. This feature has been removed and the copy_to will be removed from the mapping.", (Object)name);
            } else {
                TypeParsers.parseCopyFields(propNode, builder);
            }
            iterator.remove();
        }
        if (indexVersionCreated.before(Version.V_2_2_0)) {
            TypeParsers.parseAnalyzersAndTermVectors(builder, name, fieldNode, parserContext);
        }
    }

    public static boolean parseMultiField(FieldMapper.Builder builder, String name, Mapper.TypeParser.ParserContext parserContext, String propName, Object propNode) {
        parserContext = parserContext.createMultiFieldContext(parserContext);
        if (propName.equals("fields")) {
            Map multiFieldsPropNodes;
            if (propNode instanceof List && ((List)propNode).isEmpty()) {
                multiFieldsPropNodes = Collections.emptyMap();
            } else if (propNode instanceof Map) {
                multiFieldsPropNodes = (Map)propNode;
            } else {
                throw new MapperParsingException("expected map for property [fields] on field [" + propNode + "] or [" + propName + "] but got a " + propNode.getClass());
            }
            for (Map.Entry multiFieldEntry : multiFieldsPropNodes.entrySet()) {
                String multiFieldName = (String)multiFieldEntry.getKey();
                if (multiFieldName.contains(".")) {
                    throw new MapperParsingException("Field name [" + multiFieldName + "] which is a multi field of [" + name + "] cannot contain '.'");
                }
                if (!(multiFieldEntry.getValue() instanceof Map)) {
                    throw new MapperParsingException("illegal field [" + multiFieldName + "], only fields can be specified inside fields");
                }
                Map multiFieldNodes = (Map)multiFieldEntry.getValue();
                Object typeNode = multiFieldNodes.get("type");
                if (typeNode == null) {
                    throw new MapperParsingException("no type specified for property [" + multiFieldName + "]");
                }
                String type = typeNode.toString();
                if (type.equals("object") || type.equals("nested")) {
                    throw new MapperParsingException("Type [" + type + "] cannot be used in multi field");
                }
                Mapper.TypeParser typeParser = parserContext.typeParser(type);
                if (typeParser == null) {
                    throw new MapperParsingException("no handler for type [" + type + "] declared on field [" + multiFieldName + "]");
                }
                builder.addMultiField(typeParser.parse(multiFieldName, multiFieldNodes, parserContext));
                multiFieldNodes.remove("type");
                DocumentMapperParser.checkNoRemainingFields(propName, multiFieldNodes, parserContext.indexVersionCreated());
            }
            return true;
        }
        return false;
    }

    private static IndexOptions nodeIndexOptionValue(Object propNode) {
        String value = propNode.toString();
        if (INDEX_OPTIONS_OFFSETS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
        }
        if (INDEX_OPTIONS_POSITIONS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        }
        if (INDEX_OPTIONS_FREQS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS_AND_FREQS;
        }
        if (INDEX_OPTIONS_DOCS.equalsIgnoreCase(value)) {
            return IndexOptions.DOCS;
        }
        throw new ElasticsearchParseException("failed to parse index option [{}]", value);
    }

    public static FormatDateTimeFormatter parseDateTimeFormatter(Object node) {
        return Joda.forPattern(node.toString());
    }

    public static void parseTermVector(String fieldName, String termVector, FieldMapper.Builder builder) throws MapperParsingException {
        if ("no".equals(termVector)) {
            builder.storeTermVectors(false);
        } else if ("yes".equals(termVector)) {
            builder.storeTermVectors(true);
        } else if ("with_offsets".equals(termVector)) {
            builder.storeTermVectorOffsets(true);
        } else if ("with_positions".equals(termVector)) {
            builder.storeTermVectorPositions(true);
        } else if ("with_positions_offsets".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorOffsets(true);
        } else if ("with_positions_payloads".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorPayloads(true);
        } else if ("with_positions_offsets_payloads".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorOffsets(true);
            builder.storeTermVectorPayloads(true);
        } else {
            throw new MapperParsingException("wrong value for termVector [" + termVector + "] for field [" + fieldName + "]");
        }
    }

    public static boolean parseIndex(String fieldName, String index, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
        switch (index) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
            case "not_analyzed": 
            case "analyzed": 
            case "no": {
                if (!parserContext.parseFieldMatcher().isStrict()) {
                    DEPRECATION_LOGGER.deprecated("Expected a boolean for property [index] but got [{}]", index);
                    return !"no".equals(index);
                }
                throw new IllegalArgumentException("Can't parse [index] value [" + index + "] for field [" + fieldName + "], expected [true] or [false]");
            }
        }
        throw new IllegalArgumentException("Can't parse [index] value [" + index + "] for field [" + fieldName + "], expected [true] or [false]");
    }

    public static boolean parseStore(String fieldName, String store, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
        if (parserContext.parseFieldMatcher().isStrict()) {
            return XContentMapValues.nodeBooleanValue(store);
        }
        if (!BOOLEAN_STRINGS.contains(store)) {
            DEPRECATION_LOGGER.deprecated("Expected a boolean for property [store] but got [{}]", store);
        }
        if ("no".equals(store)) {
            return false;
        }
        if ("yes".equals(store)) {
            return true;
        }
        return XContentMapValues.lenientNodeBooleanValue(store);
    }

    public static void parseCopyFields(Object propNode, FieldMapper.Builder builder) {
        FieldMapper.CopyTo.Builder copyToBuilder = new FieldMapper.CopyTo.Builder();
        if (XContentMapValues.isArray(propNode)) {
            for (Object node : (List)propNode) {
                copyToBuilder.add(XContentMapValues.nodeStringValue(node, null));
            }
        } else {
            copyToBuilder.add(XContentMapValues.nodeStringValue(propNode, null));
        }
        builder.copyTo(copyToBuilder.build());
    }

    private static SimilarityProvider resolveSimilarity(Mapper.TypeParser.ParserContext parserContext, String name, String value) {
        SimilarityProvider similarityProvider;
        if (parserContext.indexVersionCreated().before(Version.V_5_0_0_alpha1) && "default".equals(value)) {
            value = "classic";
        }
        if ((similarityProvider = parserContext.getSimilarity(value)) == null) {
            throw new MapperParsingException("Unknown Similarity type [" + value + "] for field [" + name + "]");
        }
        return similarityProvider;
    }
}

