/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.HasChildQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;

public class NestedQueryBuilder
extends AbstractQueryBuilder<NestedQueryBuilder> {
    public static final String NAME = "nested";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField SCORE_MODE_FIELD = new ParseField("score_mode", new String[0]);
    private static final ParseField PATH_FIELD = new ParseField("path", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField INNER_HITS_FIELD = new ParseField("inner_hits", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String path;
    private final ScoreMode scoreMode;
    private final QueryBuilder query;
    private InnerHitBuilder innerHitBuilder;
    private boolean ignoreUnmapped = false;

    public NestedQueryBuilder(String path, QueryBuilder query, ScoreMode scoreMode) {
        this(path, query, scoreMode, null);
    }

    private NestedQueryBuilder(String path, QueryBuilder query, ScoreMode scoreMode, InnerHitBuilder innerHitBuilder) {
        this.path = NestedQueryBuilder.requireValue(path, "[nested] requires 'path' field");
        this.query = NestedQueryBuilder.requireValue(query, "[nested] requires 'query' field");
        this.scoreMode = NestedQueryBuilder.requireValue(scoreMode, "[nested] requires 'score_mode' field");
        this.innerHitBuilder = innerHitBuilder;
    }

    public NestedQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.path = in.readString();
        this.scoreMode = ScoreMode.values()[in.readVInt()];
        this.query = in.readNamedWriteable(QueryBuilder.class);
        this.innerHitBuilder = in.readOptionalWriteable(InnerHitBuilder::new);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.path);
        out.writeVInt(this.scoreMode.ordinal());
        out.writeNamedWriteable(this.query);
        out.writeOptionalWriteable(this.innerHitBuilder);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public QueryBuilder query() {
        return this.query;
    }

    public InnerHitBuilder innerHit() {
        return this.innerHitBuilder;
    }

    public NestedQueryBuilder innerHit(InnerHitBuilder innerHit) {
        this.innerHitBuilder = new InnerHitBuilder(innerHit, this.path, this.query);
        return this;
    }

    public ScoreMode scoreMode() {
        return this.scoreMode;
    }

    public NestedQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName());
        this.query.toXContent(builder, params);
        builder.field(PATH_FIELD.getPreferredName(), this.path);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        if (this.scoreMode != null) {
            builder.field(SCORE_MODE_FIELD.getPreferredName(), HasChildQueryBuilder.scoreModeAsString(this.scoreMode));
        }
        this.printBoostAndQueryName(builder);
        if (this.innerHitBuilder != null) {
            builder.field(INNER_HITS_FIELD.getPreferredName(), this.innerHitBuilder, params);
        }
        builder.endObject();
    }

    public static Optional<NestedQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        ScoreMode scoreMode = ScoreMode.Avg;
        String queryName = null;
        Optional<Object> query = Optional.empty();
        String path = null;
        String currentFieldName = null;
        InnerHitBuilder innerHitBuilder = null;
        boolean ignoreUnmapped = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (parseContext.getParseFieldMatcher().match(currentFieldName, QUERY_FIELD)) {
                    query = parseContext.parseInnerQueryBuilder();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, INNER_HITS_FIELD)) {
                    innerHitBuilder = InnerHitBuilder.fromXContent(parseContext);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[nested] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (parseContext.getParseFieldMatcher().match(currentFieldName, PATH_FIELD)) {
                path = parser.text();
                continue;
            }
            if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.BOOST_FIELD)) {
                boost = parser.floatValue();
                continue;
            }
            if (parseContext.getParseFieldMatcher().match(currentFieldName, IGNORE_UNMAPPED_FIELD)) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (parseContext.getParseFieldMatcher().match(currentFieldName, SCORE_MODE_FIELD)) {
                scoreMode = HasChildQueryBuilder.parseScoreMode(parser.text());
                continue;
            }
            if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.NAME_FIELD)) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[nested] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (!query.isPresent()) {
            return Optional.empty();
        }
        NestedQueryBuilder queryBuilder = (NestedQueryBuilder)((NestedQueryBuilder)new NestedQueryBuilder(path, (QueryBuilder)query.get(), scoreMode).ignoreUnmapped(ignoreUnmapped).queryName(queryName)).boost(boost);
        if (innerHitBuilder != null) {
            queryBuilder.innerHit(innerHitBuilder);
        }
        return Optional.of(queryBuilder);
    }

    @Override
    public final String getWriteableName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(NestedQueryBuilder that) {
        return Objects.equals(this.query, that.query) && Objects.equals(this.path, that.path) && Objects.equals(this.scoreMode, that.scoreMode) && Objects.equals(this.innerHitBuilder, that.innerHitBuilder) && Objects.equals(this.ignoreUnmapped, that.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.query, this.path, this.scoreMode, this.innerHitBuilder, this.ignoreUnmapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query innerQuery;
        ObjectMapper nestedObjectMapper = context.getObjectMapper(this.path);
        if (nestedObjectMapper == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new IllegalStateException("[nested] failed to find nested object under path [" + this.path + "]");
        }
        if (!nestedObjectMapper.nested().isNested()) {
            throw new IllegalStateException("[nested] nested object under path [" + this.path + "] is not of nested type");
        }
        ObjectMapper objectMapper = context.nestedScope().getObjectMapper();
        BitSetProducer parentFilter = objectMapper == null ? context.bitsetFilter(Queries.newNonNestedFilter()) : context.bitsetFilter(objectMapper.nestedTypeFilter());
        Query childFilter = nestedObjectMapper.nestedTypeFilter();
        try {
            context.nestedScope().nextLevel(nestedObjectMapper);
            innerQuery = this.query.toQuery(context);
        }
        finally {
            context.nestedScope().previousLevel();
        }
        return new ToParentBlockJoinQuery((Query)Queries.filtered(innerQuery, childFilter), parentFilter, this.scoreMode);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder rewrittenQuery = this.query.rewrite(queryRewriteContext);
        if (rewrittenQuery != this.query) {
            InnerHitBuilder rewrittenInnerHit = InnerHitBuilder.rewrite(this.innerHitBuilder, rewrittenQuery);
            return new NestedQueryBuilder(this.path, rewrittenQuery, this.scoreMode, rewrittenInnerHit);
        }
        return this;
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitBuilder> innerHits) {
        if (this.innerHitBuilder != null) {
            this.innerHitBuilder.inlineInnerHits(innerHits);
        }
    }
}

