/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.util.List;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.monitor.Probes;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.os.OsStats;

public class OsProbe {
    private static final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method getFreePhysicalMemorySize = OsProbe.getMethod("getFreePhysicalMemorySize");
    private static final Method getTotalPhysicalMemorySize = OsProbe.getMethod("getTotalPhysicalMemorySize");
    private static final Method getFreeSwapSpaceSize = OsProbe.getMethod("getFreeSwapSpaceSize");
    private static final Method getTotalSwapSpaceSize = OsProbe.getMethod("getTotalSwapSpaceSize");
    private static final Method getSystemLoadAverage = OsProbe.getMethod("getSystemLoadAverage");
    private static final Method getSystemCpuLoad = OsProbe.getMethod("getSystemCpuLoad");

    public long getFreePhysicalMemorySize() {
        if (getFreePhysicalMemorySize == null) {
            return -1L;
        }
        try {
            return (Long)getFreePhysicalMemorySize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public long getTotalPhysicalMemorySize() {
        if (getTotalPhysicalMemorySize == null) {
            return -1L;
        }
        try {
            return (Long)getTotalPhysicalMemorySize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public long getFreeSwapSpaceSize() {
        if (getFreeSwapSpaceSize == null) {
            return -1L;
        }
        try {
            return (Long)getFreeSwapSpaceSize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public long getTotalSwapSpaceSize() {
        if (getTotalSwapSpaceSize == null) {
            return -1L;
        }
        try {
            return (Long)getTotalSwapSpaceSize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public double[] getSystemLoadAverage() {
        String procLoadAvg;
        double[] loadAverage;
        if ((Constants.LINUX || Constants.FREE_BSD) && (loadAverage = OsProbe.readProcLoadavg(procLoadAvg = Constants.LINUX ? "/proc/loadavg" : "/compat/linux/proc/loadavg")) != null) {
            return loadAverage;
        }
        if (Constants.WINDOWS) {
            return null;
        }
        if (getSystemLoadAverage == null) {
            return null;
        }
        try {
            double oneMinuteLoadAverage = (Double)getSystemLoadAverage.invoke((Object)osMxBean, new Object[0]);
            return new double[]{oneMinuteLoadAverage >= 0.0 ? oneMinuteLoadAverage : -1.0, -1.0, -1.0};
        }
        catch (Exception e) {
            return null;
        }
    }

    @SuppressForbidden(reason="access /proc")
    private static double[] readProcLoadavg(String procLoadavg) {
        try {
            List<String> lines = Files.readAllLines(PathUtils.get(procLoadavg, new String[0]));
            if (!lines.isEmpty()) {
                String[] fields = lines.get(0).split("\\s+");
                return new double[]{Double.parseDouble(fields[0]), Double.parseDouble(fields[1]), Double.parseDouble(fields[2])};
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public short getSystemCpuPercent() {
        return Probes.getLoadAndScaleToPercent(getSystemCpuLoad, osMxBean);
    }

    public static OsProbe getInstance() {
        return OsProbeHolder.INSTANCE;
    }

    private OsProbe() {
    }

    public OsInfo osInfo(long refreshInterval, int allocatedProcessors) {
        return new OsInfo(refreshInterval, Runtime.getRuntime().availableProcessors(), allocatedProcessors, Constants.OS_NAME, Constants.OS_ARCH, Constants.OS_VERSION);
    }

    public OsStats osStats() {
        OsStats.Cpu cpu = new OsStats.Cpu(this.getSystemCpuPercent(), this.getSystemLoadAverage());
        OsStats.Mem mem = new OsStats.Mem(this.getTotalPhysicalMemorySize(), this.getFreePhysicalMemorySize());
        OsStats.Swap swap = new OsStats.Swap(this.getTotalSwapSpaceSize(), this.getFreeSwapSpaceSize());
        return new OsStats(System.currentTimeMillis(), cpu, mem, swap);
    }

    private static Method getMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.OperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class OsProbeHolder {
        private static final OsProbe INSTANCE = new OsProbe();

        private OsProbeHolder() {
        }
    }
}

