/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.util.List;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class ExecutorBuilder<U extends ExecutorSettings> {
    private final String name;

    public ExecutorBuilder(String name) {
        this.name = name;
    }

    protected String name() {
        return this.name;
    }

    protected static String settingsKey(String prefix, String key) {
        return String.join((CharSequence)".", prefix, key);
    }

    public abstract List<Setting<?>> getRegisteredSettings();

    abstract U getSettings(Settings var1);

    abstract ThreadPool.ExecutorHolder build(U var1, ThreadContext var2);

    abstract String formatInfo(ThreadPool.Info var1);

    static abstract class ExecutorSettings {
        protected final String nodeName;

        public ExecutorSettings(String nodeName) {
            this.nodeName = nodeName;
        }
    }
}

