/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.builder.impl;

import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.Component;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.CustomLevelComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ScriptComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ScriptFileComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.builder.impl.DefaultAppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultAppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultCustomLevelComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultFilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultLayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultRootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultScriptComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.DefaultScriptFileComponentBuilder;

public class DefaultConfigurationBuilder<T extends BuiltConfiguration>
implements ConfigurationBuilder<T> {
    private final Component root = new Component();
    private Component loggers;
    private Component appenders;
    private Component filters;
    private Component properties;
    private Component customLevels;
    private Component scripts;
    private final Class<T> clazz;
    private ConfigurationSource source;
    private int monitorInterval = 0;
    private Level level = null;
    private String verbosity = null;
    private String packages = null;
    private String shutdownFlag = null;
    private String advertiser = null;
    private String name = null;

    public DefaultConfigurationBuilder() {
        this(BuiltConfiguration.class);
        this.root.addAttribute("name", "Built");
    }

    public DefaultConfigurationBuilder(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("A Configuration class must be provided");
        }
        this.clazz = clazz;
        List<Component> components = this.root.getComponents();
        this.properties = new Component("Properties");
        components.add(this.properties);
        this.scripts = new Component("Scripts");
        components.add(this.scripts);
        this.customLevels = new Component("CustomLevels");
        components.add(this.customLevels);
        this.filters = new Component("Filters");
        components.add(this.filters);
        this.appenders = new Component("Appenders");
        components.add(this.appenders);
        this.loggers = new Component("Loggers");
        components.add(this.loggers);
    }

    protected ConfigurationBuilder<T> add(Component parent, ComponentBuilder<?> builder) {
        parent.getComponents().add((Component)builder.build());
        return this;
    }

    @Override
    public ConfigurationBuilder<T> add(AppenderComponentBuilder builder) {
        return this.add(this.appenders, builder);
    }

    @Override
    public ConfigurationBuilder<T> add(CustomLevelComponentBuilder builder) {
        return this.add(this.customLevels, builder);
    }

    @Override
    public ConfigurationBuilder<T> add(FilterComponentBuilder builder) {
        return this.add(this.filters, builder);
    }

    @Override
    public ConfigurationBuilder<T> add(ScriptComponentBuilder builder) {
        return this.add(this.scripts, builder);
    }

    @Override
    public ConfigurationBuilder<T> add(ScriptFileComponentBuilder builder) {
        return this.add(this.scripts, builder);
    }

    @Override
    public ConfigurationBuilder<T> add(LoggerComponentBuilder builder) {
        return this.add(this.loggers, builder);
    }

    @Override
    public ConfigurationBuilder<T> add(RootLoggerComponentBuilder builder) {
        for (Component c : this.loggers.getComponents()) {
            if (!c.getPluginType().equals("root")) continue;
            throw new ConfigurationException("Root Logger was previously defined");
        }
        return this.add(this.loggers, builder);
    }

    @Override
    public ConfigurationBuilder<T> addProperty(String key, String value) {
        this.properties.addComponent((Component)this.newComponent(key, "Property", value).build());
        return this;
    }

    @Override
    public T build() {
        return (T)this.build(true);
    }

    @Override
    public T build(boolean initialize) {
        BuiltConfiguration configuration;
        try {
            if (this.source == null) {
                this.source = ConfigurationSource.NULL_SOURCE;
            }
            Constructor<T> constructor = this.clazz.getConstructor(ConfigurationSource.class, Component.class);
            configuration = (BuiltConfiguration)constructor.newInstance(this.source, this.root);
            configuration.setMonitorInterval(this.monitorInterval);
            configuration.getRootNode().getAttributes().putAll(this.root.getAttributes());
            if (this.name != null) {
                configuration.setName(this.name);
            }
            if (this.level != null) {
                configuration.getStatusConfiguration().withStatus(this.level);
            }
            if (this.verbosity != null) {
                configuration.getStatusConfiguration().withVerbosity(this.verbosity);
            }
            if (this.packages != null) {
                configuration.setPluginPackages(this.packages);
            }
            if (this.shutdownFlag != null) {
                configuration.setShutdownHook(this.shutdownFlag);
            }
            if (this.advertiser != null) {
                configuration.createAdvertiser(this.advertiser, this.source);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid Configuration class specified", ex);
        }
        configuration.getStatusConfiguration().initialize();
        if (initialize) {
            configuration.initialize();
        }
        return (T)configuration;
    }

    @Override
    public ScriptComponentBuilder newScript(String name, String language, String text) {
        return new DefaultScriptComponentBuilder(this, name, language, text);
    }

    @Override
    public ScriptFileComponentBuilder newScriptFile(String path) {
        return new DefaultScriptFileComponentBuilder(this, path, path);
    }

    @Override
    public ScriptFileComponentBuilder newScriptFile(String name, String path) {
        return new DefaultScriptFileComponentBuilder(this, name, path);
    }

    @Override
    public AppenderComponentBuilder newAppender(String name, String type) {
        return new DefaultAppenderComponentBuilder(this, name, type);
    }

    @Override
    public AppenderRefComponentBuilder newAppenderRef(String ref) {
        return new DefaultAppenderRefComponentBuilder(this, ref);
    }

    @Override
    public LoggerComponentBuilder newAsyncLogger(String name, Level level) {
        return new DefaultLoggerComponentBuilder(this, name, level.toString(), "AsyncLogger", false);
    }

    @Override
    public LoggerComponentBuilder newAsyncLogger(String name, Level level, boolean includeLocation) {
        return new DefaultLoggerComponentBuilder(this, name, level.toString(), "AsyncLogger", includeLocation);
    }

    @Override
    public LoggerComponentBuilder newAsyncLogger(String name, String level) {
        return new DefaultLoggerComponentBuilder(this, name, level, "AsyncLogger", false);
    }

    @Override
    public LoggerComponentBuilder newAsyncLogger(String name, String level, boolean includeLocation) {
        return new DefaultLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, name, level, "AsyncLogger");
    }

    @Override
    public RootLoggerComponentBuilder newAsyncRootLogger(Level level) {
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, level.toString(), "AsyncRoot", false);
    }

    @Override
    public RootLoggerComponentBuilder newAsyncRootLogger(Level level, boolean includeLocation) {
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, level.toString(), "AsyncRoot", includeLocation);
    }

    @Override
    public RootLoggerComponentBuilder newAsyncRootLogger(String level) {
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, level, "AsyncRoot", false);
    }

    @Override
    public RootLoggerComponentBuilder newAsyncRootLogger(String level, boolean includeLocation) {
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, level, "AsyncRoot", includeLocation);
    }

    @Override
    public <B extends ComponentBuilder<B>> ComponentBuilder<B> newComponent(String type) {
        return new DefaultComponentBuilder(this, type);
    }

    @Override
    public <B extends ComponentBuilder<B>> ComponentBuilder<B> newComponent(String name, String type) {
        return new DefaultComponentBuilder(this, name, type);
    }

    @Override
    public <B extends ComponentBuilder<B>> ComponentBuilder<B> newComponent(String name, String type, String value) {
        return new DefaultComponentBuilder(this, name, type, value);
    }

    @Override
    public CustomLevelComponentBuilder newCustomLevel(String name, int level) {
        return new DefaultCustomLevelComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, name, level);
    }

    @Override
    public FilterComponentBuilder newFilter(String type, Filter.Result onMatch, Filter.Result onMisMatch) {
        return new DefaultFilterComponentBuilder(this, type, onMatch.name(), onMisMatch.name());
    }

    @Override
    public FilterComponentBuilder newFilter(String type, String onMatch, String onMisMatch) {
        return new DefaultFilterComponentBuilder(this, type, onMatch, onMisMatch);
    }

    @Override
    public LayoutComponentBuilder newLayout(String type) {
        return new DefaultLayoutComponentBuilder(this, type);
    }

    @Override
    public LoggerComponentBuilder newLogger(String name, Level level) {
        return new DefaultLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, name, level.toString(), true);
    }

    @Override
    public LoggerComponentBuilder newLogger(String name, Level level, boolean includeLocation) {
        return new DefaultLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, name, level.toString(), includeLocation);
    }

    @Override
    public LoggerComponentBuilder newLogger(String name, String level) {
        return new DefaultLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, name, level, true);
    }

    @Override
    public LoggerComponentBuilder newLogger(String name, String level, boolean includeLocation) {
        return new DefaultLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, name, level, includeLocation);
    }

    @Override
    public RootLoggerComponentBuilder newRootLogger(Level level) {
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, level.toString(), true);
    }

    @Override
    public RootLoggerComponentBuilder newRootLogger(Level level, boolean includeLocation) {
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, level.toString(), includeLocation);
    }

    @Override
    public RootLoggerComponentBuilder newRootLogger(String level) {
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, level, true);
    }

    @Override
    public RootLoggerComponentBuilder newRootLogger(String level, boolean includeLocation) {
        return new DefaultRootLoggerComponentBuilder((DefaultConfigurationBuilder<? extends Configuration>)this, level, includeLocation);
    }

    @Override
    public ConfigurationBuilder<T> setAdvertiser(String advertiser) {
        this.advertiser = advertiser;
        return this;
    }

    @Override
    public ConfigurationBuilder<T> setConfigurationName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ConfigurationBuilder<T> setConfigurationSource(ConfigurationSource configurationSource) {
        this.source = configurationSource;
        return this;
    }

    @Override
    public ConfigurationBuilder<T> setMonitorInterval(String intervalSeconds) {
        this.monitorInterval = Integer.parseInt(intervalSeconds);
        return this;
    }

    @Override
    public ConfigurationBuilder<T> setPackages(String packages) {
        this.packages = packages;
        return this;
    }

    @Override
    public ConfigurationBuilder<T> setShutdownHook(String flag) {
        this.shutdownFlag = flag;
        return this;
    }

    @Override
    public ConfigurationBuilder<T> setStatusLevel(Level level) {
        this.level = level;
        return this;
    }

    @Override
    public ConfigurationBuilder<T> setVerbosity(String verbosity) {
        this.verbosity = verbosity;
        return this;
    }

    @Override
    public ConfigurationBuilder<T> addRootProperty(String key, String value) {
        this.root.getAttributes().put(key, value);
        return this;
    }
}

