/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.LongValues;

public abstract class DocValuesConsumer
implements Closeable {
    protected DocValuesConsumer() {
    }

    public abstract void addNumericField(FieldInfo var1, Iterable<Number> var2) throws IOException;

    public abstract void addBinaryField(FieldInfo var1, Iterable<BytesRef> var2) throws IOException;

    public abstract void addSortedField(FieldInfo var1, Iterable<BytesRef> var2, Iterable<Number> var3) throws IOException;

    public abstract void addSortedNumericField(FieldInfo var1, Iterable<Number> var2, Iterable<Number> var3) throws IOException;

    public abstract void addSortedSetField(FieldInfo var1, Iterable<BytesRef> var2, Iterable<Number> var3, Iterable<Number> var4) throws IOException;

    public void merge(MergeState mergeState) throws IOException {
        for (DocValuesProducer docValuesProducer : mergeState.docValuesProducers) {
            if (docValuesProducer == null) continue;
            docValuesProducer.checkIntegrity();
        }
        for (FieldInfo mergeFieldInfo : mergeState.mergeFieldInfos) {
            FieldInfo fieldInfo;
            DocValuesProducer docValuesProducer;
            FieldInfo fieldInfo2;
            DocValuesProducer docValuesProducer2;
            Bits bits;
            Object values;
            int i;
            ArrayList<NumericDocValues> toMerge;
            DocValuesType type = mergeFieldInfo.getDocValuesType();
            if (type == DocValuesType.NONE) continue;
            if (type == DocValuesType.NUMERIC) {
                toMerge = new ArrayList<NumericDocValues>();
                ArrayList<Bits> docsWithField = new ArrayList<Bits>();
                for (i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    values = null;
                    bits = null;
                    docValuesProducer2 = mergeState.docValuesProducers[i];
                    if (docValuesProducer2 != null && (fieldInfo2 = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo2.getDocValuesType() == DocValuesType.NUMERIC) {
                        values = docValuesProducer2.getNumeric(fieldInfo2);
                        bits = docValuesProducer2.getDocsWithField(fieldInfo2);
                    }
                    if (values == null) {
                        values = DocValues.emptyNumeric();
                        bits = new Bits.MatchNoBits(mergeState.maxDocs[i]);
                    }
                    toMerge.add((NumericDocValues)values);
                    docsWithField.add(bits);
                }
                this.mergeNumericField(mergeFieldInfo, mergeState, toMerge, docsWithField);
                continue;
            }
            if (type == DocValuesType.BINARY) {
                toMerge = new ArrayList();
                ArrayList<Bits> docsWithField = new ArrayList<Bits>();
                for (i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    values = null;
                    bits = null;
                    docValuesProducer2 = mergeState.docValuesProducers[i];
                    if (docValuesProducer2 != null && (fieldInfo2 = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo2.getDocValuesType() == DocValuesType.BINARY) {
                        values = docValuesProducer2.getBinary(fieldInfo2);
                        bits = docValuesProducer2.getDocsWithField(fieldInfo2);
                    }
                    if (values == null) {
                        values = DocValues.emptyBinary();
                        bits = new Bits.MatchNoBits(mergeState.maxDocs[i]);
                    }
                    toMerge.add((NumericDocValues)values);
                    docsWithField.add(bits);
                }
                this.mergeBinaryField(mergeFieldInfo, mergeState, toMerge, docsWithField);
                continue;
            }
            if (type == DocValuesType.SORTED) {
                toMerge = new ArrayList();
                for (int i2 = 0; i2 < mergeState.docValuesProducers.length; ++i2) {
                    SortedDocValues values2 = null;
                    docValuesProducer = mergeState.docValuesProducers[i2];
                    if (docValuesProducer != null && (fieldInfo = mergeState.fieldInfos[i2].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo.getDocValuesType() == DocValuesType.SORTED) {
                        values2 = docValuesProducer.getSorted(fieldInfo);
                    }
                    if (values2 == null) {
                        values2 = DocValues.emptySorted();
                    }
                    toMerge.add((NumericDocValues)((Object)values2));
                }
                this.mergeSortedField(mergeFieldInfo, mergeState, toMerge);
                continue;
            }
            if (type == DocValuesType.SORTED_SET) {
                toMerge = new ArrayList();
                for (int i3 = 0; i3 < mergeState.docValuesProducers.length; ++i3) {
                    SortedSetDocValues values3 = null;
                    docValuesProducer = mergeState.docValuesProducers[i3];
                    if (docValuesProducer != null && (fieldInfo = mergeState.fieldInfos[i3].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo.getDocValuesType() == DocValuesType.SORTED_SET) {
                        values3 = docValuesProducer.getSortedSet(fieldInfo);
                    }
                    if (values3 == null) {
                        values3 = DocValues.emptySortedSet();
                    }
                    toMerge.add((NumericDocValues)((Object)values3));
                }
                this.mergeSortedSetField(mergeFieldInfo, mergeState, toMerge);
                continue;
            }
            if (type == DocValuesType.SORTED_NUMERIC) {
                toMerge = new ArrayList();
                for (int i4 = 0; i4 < mergeState.docValuesProducers.length; ++i4) {
                    SortedNumericDocValues values4 = null;
                    docValuesProducer = mergeState.docValuesProducers[i4];
                    if (docValuesProducer != null && (fieldInfo = mergeState.fieldInfos[i4].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo.getDocValuesType() == DocValuesType.SORTED_NUMERIC) {
                        values4 = docValuesProducer.getSortedNumeric(fieldInfo);
                    }
                    if (values4 == null) {
                        values4 = DocValues.emptySortedNumeric(mergeState.maxDocs[i4]);
                    }
                    toMerge.add((NumericDocValues)((Object)values4));
                }
                this.mergeSortedNumericField(mergeFieldInfo, mergeState, toMerge);
                continue;
            }
            throw new AssertionError((Object)("type=" + (Object)((Object)type)));
        }
    }

    public void mergeNumericField(FieldInfo fieldInfo, final MergeState mergeState, final List<NumericDocValues> toMerge, final List<Bits> docsWithField) throws IOException {
        this.addNumericField(fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                ArrayList<NumericDocValuesSub> subs = new ArrayList<NumericDocValuesSub>();
                assert (mergeState.docMaps.length == toMerge.size());
                for (int i = 0; i < toMerge.size(); ++i) {
                    subs.add(new NumericDocValuesSub(mergeState.docMaps[i], (NumericDocValues)toMerge.get(i), (Bits)docsWithField.get(i), mergeState.maxDocs[i]));
                }
                final DocIDMerger docIDMerger = new DocIDMerger(subs, mergeState.segmentInfo.getIndexSort() != null);
                return new Iterator<Number>(){
                    long nextValue;
                    boolean nextHasValue;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextHasValue ? Long.valueOf(this.nextValue) : null;
                    }

                    private boolean setNext() {
                        NumericDocValuesSub sub = (NumericDocValuesSub)docIDMerger.next();
                        if (sub == null) {
                            return false;
                        }
                        this.nextIsSet = true;
                        this.nextValue = sub.values.get(sub.docID);
                        this.nextHasValue = this.nextValue != 0L || sub.docsWithField.get(sub.docID);
                        return true;
                    }
                };
            }
        });
    }

    public void mergeBinaryField(FieldInfo fieldInfo, final MergeState mergeState, final List<BinaryDocValues> toMerge, final List<Bits> docsWithField) throws IOException {
        this.addBinaryField(fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                ArrayList<BinaryDocValuesSub> subs = new ArrayList<BinaryDocValuesSub>();
                assert (mergeState.docMaps.length == toMerge.size());
                for (int i = 0; i < toMerge.size(); ++i) {
                    subs.add(new BinaryDocValuesSub(mergeState.docMaps[i], (BinaryDocValues)toMerge.get(i), (Bits)docsWithField.get(i), mergeState.maxDocs[i]));
                }
                final DocIDMerger docIDMerger = new DocIDMerger(subs, mergeState.segmentInfo.getIndexSort() != null);
                return new Iterator<BytesRef>(){
                    BytesRef nextValue;
                    BytesRef nextPointer;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public BytesRef next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextPointer;
                    }

                    private boolean setNext() {
                        BinaryDocValuesSub sub = (BinaryDocValuesSub)docIDMerger.next();
                        if (sub == null) {
                            return false;
                        }
                        this.nextIsSet = true;
                        this.nextPointer = sub.docsWithField.get(sub.docID) ? (this.nextValue = sub.values.get(sub.docID)) : null;
                        return true;
                    }
                };
            }
        });
    }

    public void mergeSortedNumericField(FieldInfo fieldInfo, final MergeState mergeState, final List<SortedNumericDocValues> toMerge) throws IOException {
        this.addSortedNumericField(fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                ArrayList<SortedNumericDocValuesSub> subs = new ArrayList<SortedNumericDocValuesSub>();
                assert (mergeState.docMaps.length == toMerge.size());
                for (int i = 0; i < toMerge.size(); ++i) {
                    subs.add(new SortedNumericDocValuesSub(mergeState.docMaps[i], (SortedNumericDocValues)toMerge.get(i), mergeState.maxDocs[i]));
                }
                final DocIDMerger docIDMerger = new DocIDMerger(subs, mergeState.segmentInfo.getIndexSort() != null);
                return new Iterator<Number>(){
                    int nextValue;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        SortedNumericDocValuesSub sub = (SortedNumericDocValuesSub)docIDMerger.next();
                        if (sub == null) {
                            return false;
                        }
                        this.nextIsSet = true;
                        this.nextValue = sub.values.count();
                        return true;
                    }
                };
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                ArrayList<SortedNumericDocValuesSub> subs = new ArrayList<SortedNumericDocValuesSub>();
                assert (mergeState.docMaps.length == toMerge.size());
                for (int i = 0; i < toMerge.size(); ++i) {
                    subs.add(new SortedNumericDocValuesSub(mergeState.docMaps[i], (SortedNumericDocValues)toMerge.get(i), mergeState.maxDocs[i]));
                }
                final DocIDMerger docIDMerger = new DocIDMerger(subs, mergeState.segmentInfo.getIndexSort() != null);
                return new Iterator<Number>(){
                    long nextValue;
                    boolean nextIsSet;
                    int valueUpto;
                    int valueLength;
                    SortedNumericDocValuesSub current;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        while (true) {
                            if (this.valueUpto < this.valueLength) {
                                this.nextValue = this.current.values.valueAt(this.valueUpto);
                                ++this.valueUpto;
                                this.nextIsSet = true;
                                return true;
                            }
                            this.current = (SortedNumericDocValuesSub)docIDMerger.next();
                            if (this.current == null) {
                                return false;
                            }
                            this.valueUpto = 0;
                            this.valueLength = this.current.values.count();
                        }
                    }
                };
            }
        });
    }

    public void mergeSortedField(FieldInfo fieldInfo, final MergeState mergeState, final List<SortedDocValues> toMerge) throws IOException {
        int numReaders = toMerge.size();
        final SortedDocValues[] dvs = toMerge.toArray(new SortedDocValues[numReaders]);
        TermsEnum[] liveTerms = new TermsEnum[dvs.length];
        long[] weights = new long[liveTerms.length];
        for (int sub = 0; sub < numReaders; ++sub) {
            SortedDocValues dv = dvs[sub];
            Bits liveDocs = mergeState.liveDocs[sub];
            int maxDoc = mergeState.maxDocs[sub];
            if (liveDocs == null) {
                liveTerms[sub] = dv.termsEnum();
                weights[sub] = dv.getValueCount();
                continue;
            }
            LongBitSet bitset = new LongBitSet(dv.getValueCount());
            for (int i = 0; i < maxDoc; ++i) {
                int ord;
                if (!liveDocs.get(i) || (ord = dv.getOrd(i)) < 0) continue;
                bitset.set(ord);
            }
            liveTerms[sub] = new BitsFilteredTermsEnum(dv.termsEnum(), bitset);
            weights[sub] = bitset.cardinality();
        }
        final MultiDocValues.OrdinalMap map = MultiDocValues.OrdinalMap.build(this, liveTerms, weights, 0.0f);
        this.addSortedField(fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    int currentOrd;

                    @Override
                    public boolean hasNext() {
                        return (long)this.currentOrd < map.getValueCount();
                    }

                    @Override
                    public BytesRef next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int segmentNumber = map.getFirstSegmentNumber(this.currentOrd);
                        int segmentOrd = (int)map.getFirstSegmentOrd(this.currentOrd);
                        BytesRef term = dvs[segmentNumber].lookupOrd(segmentOrd);
                        ++this.currentOrd;
                        return term;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                ArrayList<SortedDocValuesSub> subs = new ArrayList<SortedDocValuesSub>();
                assert (mergeState.docMaps.length == toMerge.size());
                for (int i = 0; i < toMerge.size(); ++i) {
                    subs.add(new SortedDocValuesSub(mergeState.docMaps[i], (SortedDocValues)toMerge.get(i), mergeState.maxDocs[i], map.getGlobalOrds(i)));
                }
                final DocIDMerger docIDMerger = new DocIDMerger(subs, mergeState.segmentInfo.getIndexSort() != null);
                return new Iterator<Number>(){
                    int nextValue;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        SortedDocValuesSub sub = (SortedDocValuesSub)docIDMerger.next();
                        if (sub == null) {
                            return false;
                        }
                        this.nextIsSet = true;
                        int segOrd = sub.values.getOrd(sub.docID);
                        this.nextValue = segOrd == -1 ? -1 : (int)sub.map.get(segOrd);
                        return true;
                    }
                };
            }
        });
    }

    public void mergeSortedSetField(FieldInfo fieldInfo, final MergeState mergeState, final List<SortedSetDocValues> toMerge) throws IOException {
        TermsEnum[] liveTerms = new TermsEnum[toMerge.size()];
        long[] weights = new long[liveTerms.length];
        for (int sub = 0; sub < liveTerms.length; ++sub) {
            SortedSetDocValues dv = toMerge.get(sub);
            Bits liveDocs = mergeState.liveDocs[sub];
            int maxDoc = mergeState.maxDocs[sub];
            if (liveDocs == null) {
                liveTerms[sub] = dv.termsEnum();
                weights[sub] = dv.getValueCount();
                continue;
            }
            LongBitSet bitset = new LongBitSet(dv.getValueCount());
            for (int i = 0; i < maxDoc; ++i) {
                long ord;
                if (!liveDocs.get(i)) continue;
                dv.setDocument(i);
                while ((ord = dv.nextOrd()) != -1L) {
                    bitset.set(ord);
                }
            }
            liveTerms[sub] = new BitsFilteredTermsEnum(dv.termsEnum(), bitset);
            weights[sub] = bitset.cardinality();
        }
        final MultiDocValues.OrdinalMap map = MultiDocValues.OrdinalMap.build(this, liveTerms, weights, 0.0f);
        this.addSortedSetField(fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    long currentOrd;

                    @Override
                    public boolean hasNext() {
                        return this.currentOrd < map.getValueCount();
                    }

                    @Override
                    public BytesRef next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int segmentNumber = map.getFirstSegmentNumber(this.currentOrd);
                        long segmentOrd = map.getFirstSegmentOrd(this.currentOrd);
                        BytesRef term = ((SortedSetDocValues)toMerge.get(segmentNumber)).lookupOrd(segmentOrd);
                        ++this.currentOrd;
                        return term;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                ArrayList<SortedSetDocValuesSub> subs = new ArrayList<SortedSetDocValuesSub>();
                assert (mergeState.docMaps.length == toMerge.size());
                for (int i = 0; i < toMerge.size(); ++i) {
                    subs.add(new SortedSetDocValuesSub(mergeState.docMaps[i], (SortedSetDocValues)toMerge.get(i), mergeState.maxDocs[i], map.getGlobalOrds(i)));
                }
                final DocIDMerger docIDMerger = new DocIDMerger(subs, mergeState.segmentInfo.getIndexSort() != null);
                return new Iterator<Number>(){
                    int nextValue;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        SortedSetDocValuesSub sub = (SortedSetDocValuesSub)docIDMerger.next();
                        if (sub == null) {
                            return false;
                        }
                        sub.values.setDocument(sub.docID);
                        this.nextValue = 0;
                        while (sub.values.nextOrd() != -1L) {
                            ++this.nextValue;
                        }
                        this.nextIsSet = true;
                        return true;
                    }
                };
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                ArrayList<SortedSetDocValuesSub> subs = new ArrayList<SortedSetDocValuesSub>();
                assert (mergeState.docMaps.length == toMerge.size());
                for (int i = 0; i < toMerge.size(); ++i) {
                    subs.add(new SortedSetDocValuesSub(mergeState.docMaps[i], (SortedSetDocValues)toMerge.get(i), mergeState.maxDocs[i], map.getGlobalOrds(i)));
                }
                final DocIDMerger docIDMerger = new DocIDMerger(subs, mergeState.segmentInfo.getIndexSort() != null);
                return new Iterator<Number>(){
                    long nextValue;
                    boolean nextIsSet;
                    long[] ords = new long[8];
                    int ordUpto;
                    int ordLength;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        block0: while (true) {
                            if (this.ordUpto < this.ordLength) {
                                this.nextValue = this.ords[this.ordUpto];
                                ++this.ordUpto;
                                this.nextIsSet = true;
                                return true;
                            }
                            SortedSetDocValuesSub sub = (SortedSetDocValuesSub)docIDMerger.next();
                            if (sub == null) {
                                return false;
                            }
                            sub.values.setDocument(sub.docID);
                            this.ordLength = 0;
                            this.ordUpto = 0;
                            while (true) {
                                long ord;
                                if ((ord = sub.values.nextOrd()) == -1L) continue block0;
                                if (this.ordLength == this.ords.length) {
                                    this.ords = ArrayUtil.grow(this.ords, this.ordLength + 1);
                                }
                                this.ords[this.ordLength] = sub.map.get(ord);
                                ++this.ordLength;
                            }
                            break;
                        }
                    }
                };
            }
        });
    }

    public static boolean isSingleValued(Iterable<Number> docToValueCount) {
        for (Number count : docToValueCount) {
            if (count.longValue() <= 1L) continue;
            return false;
        }
        return true;
    }

    public static Iterable<Number> singletonView(final Iterable<Number> docToValueCount, final Iterable<Number> values, final Number missingValue) {
        assert (DocValuesConsumer.isSingleValued(docToValueCount));
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                final Iterator countIterator = docToValueCount.iterator();
                final Iterator valuesIterator = values.iterator();
                return new Iterator<Number>(){

                    @Override
                    public boolean hasNext() {
                        return countIterator.hasNext();
                    }

                    @Override
                    public Number next() {
                        int count = ((Number)countIterator.next()).intValue();
                        if (count == 0) {
                            return missingValue;
                        }
                        return (Number)valuesIterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static class BitsFilteredTermsEnum
    extends FilteredTermsEnum {
        final LongBitSet liveTerms;

        BitsFilteredTermsEnum(TermsEnum in, LongBitSet liveTerms) {
            super(in, false);
            assert (liveTerms != null);
            this.liveTerms = liveTerms;
        }

        @Override
        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
            if (this.liveTerms.get(this.ord())) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            return FilteredTermsEnum.AcceptStatus.NO;
        }
    }

    private static class SortedSetDocValuesSub
    extends DocIDMerger.Sub {
        private final SortedSetDocValues values;
        int docID = -1;
        private final int maxDoc;
        private final LongValues map;

        public SortedSetDocValuesSub(MergeState.DocMap docMap, SortedSetDocValues values, int maxDoc, LongValues map) {
            super(docMap);
            this.values = values;
            this.maxDoc = maxDoc;
            this.map = map;
        }

        @Override
        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                return Integer.MAX_VALUE;
            }
            return this.docID;
        }

        public String toString() {
            return "SortedSetDocValuesSub(docID=" + this.docID + " mappedDocID=" + this.mappedDocID + " values=" + this.values + ")";
        }
    }

    private static class SortedDocValuesSub
    extends DocIDMerger.Sub {
        private final SortedDocValues values;
        private int docID = -1;
        private final int maxDoc;
        private final LongValues map;

        public SortedDocValuesSub(MergeState.DocMap docMap, SortedDocValues values, int maxDoc, LongValues map) {
            super(docMap);
            this.values = values;
            this.maxDoc = maxDoc;
            this.map = map;
        }

        @Override
        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                return Integer.MAX_VALUE;
            }
            return this.docID;
        }
    }

    private static class SortedNumericDocValuesSub
    extends DocIDMerger.Sub {
        private final SortedNumericDocValues values;
        private int docID = -1;
        private final int maxDoc;

        public SortedNumericDocValuesSub(MergeState.DocMap docMap, SortedNumericDocValues values, int maxDoc) {
            super(docMap);
            this.values = values;
            this.maxDoc = maxDoc;
        }

        @Override
        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                return Integer.MAX_VALUE;
            }
            this.values.setDocument(this.docID);
            return this.docID;
        }
    }

    private static class BinaryDocValuesSub
    extends DocIDMerger.Sub {
        private final BinaryDocValues values;
        private final Bits docsWithField;
        private int docID = -1;
        private final int maxDoc;

        public BinaryDocValuesSub(MergeState.DocMap docMap, BinaryDocValues values, Bits docsWithField, int maxDoc) {
            super(docMap);
            this.values = values;
            this.docsWithField = docsWithField;
            this.maxDoc = maxDoc;
        }

        @Override
        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                return Integer.MAX_VALUE;
            }
            return this.docID;
        }
    }

    private static class NumericDocValuesSub
    extends DocIDMerger.Sub {
        private final NumericDocValues values;
        private final Bits docsWithField;
        private int docID = -1;
        private final int maxDoc;

        public NumericDocValuesSub(MergeState.DocMap docMap, NumericDocValues values, Bits docsWithField, int maxDoc) {
            super(docMap);
            this.values = values;
            this.docsWithField = docsWithField;
            this.maxDoc = maxDoc;
        }

        @Override
        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                return Integer.MAX_VALUE;
            }
            return this.docID;
        }
    }
}

