// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom_Line_HeaderFile
#define _Geom_Line_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Geom_Line.hxx>

#include <gp_Ax1.hxx>
#include <Geom_Curve.hxx>
#include <Standard_Real.hxx>
#include <Standard_Boolean.hxx>
#include <GeomAbs_Shape.hxx>
#include <Standard_Integer.hxx>
#include <Handle_Geom_Geometry.hxx>
class Standard_RangeError;
class gp_Ax1;
class gp_Lin;
class gp_Pnt;
class gp_Dir;
class gp_Vec;
class gp_Trsf;
class Geom_Geometry;


//! Describes an infinite line.
//! A line is defined and positioned in space with an axis
//! (gp_Ax1 object) which gives it an origin and a unit vector.
//! The Geom_Line line is parameterized:
//! P (U) = O + U*Dir, where:
//! - P is the point of parameter U,
//! - O is the origin and Dir the unit vector of its positioning axis.
//! The parameter range is ] -infinite, +infinite [.
//! The orientation of the line is given by the unit vector
//! of its positioning axis.
class Geom_Line : public Geom_Curve
{

public:

  

  //! Creates a line located in 3D space with the axis placement A1.
  //! The Location of A1 is the origin of the line.
  Standard_EXPORT Geom_Line(const gp_Ax1& A1);
  

  //! Creates a line from a non transient line from package gp.
  Standard_EXPORT Geom_Line(const gp_Lin& L);
  

  //! Constructs a line passing through point P and parallel to vector V
  //! (P and V are, respectively, the origin and the unit
  //! vector of the positioning axis of the line).
  Standard_EXPORT Geom_Line(const gp_Pnt& P, const gp_Dir& V);
  

  //! Set <me> so that <me> has the same geometric properties as L.
  Standard_EXPORT   void SetLin (const gp_Lin& L) ;
  
  //! changes the direction of the line.
  Standard_EXPORT   void SetDirection (const gp_Dir& V) ;
  

  //! changes the "Location" point (origin) of the line.
  Standard_EXPORT   void SetLocation (const gp_Pnt& P) ;
  

  //! changes the "Location" and a the "Direction" of <me>.
  Standard_EXPORT   void SetPosition (const gp_Ax1& A1) ;
  

  //! Returns non transient line from gp with the same geometric
  //! properties as <me>
  Standard_EXPORT   gp_Lin Lin()  const;
  
  //! Returns the positioning axis of this line; this is also its local coordinate system.
  Standard_EXPORT  const  gp_Ax1& Position()  const;
  
  //! Changes the orientation of this line. As a result, the
  //! unit vector of the positioning axis of this line is reversed.
  Standard_EXPORT   void Reverse() ;
  
  //! Computes the parameter on the reversed line for the
  //! point of parameter U on this line.
  //! For a line, the returned value is -U.
  Standard_EXPORT   Standard_Real ReversedParameter (const Standard_Real U)  const;
  
  //! Returns the value of the first parameter of this
  //! line. This is Standard_Real::RealFirst().
  Standard_EXPORT   Standard_Real FirstParameter()  const;
  
  //! Returns the value of the last parameter of this
  //! line. This is  Standard_Real::RealLast().
  Standard_EXPORT   Standard_Real LastParameter()  const;
  
  //! returns False
  Standard_EXPORT   Standard_Boolean IsClosed()  const;
  
  //! returns False
  Standard_EXPORT   Standard_Boolean IsPeriodic()  const;
  
  //! Returns GeomAbs_CN, which is the global continuity of any line.
  Standard_EXPORT   GeomAbs_Shape Continuity()  const;
  
  //! returns True.
  //! Raised if N < 0.
  Standard_EXPORT   Standard_Boolean IsCN (const Standard_Integer N)  const;
  
  //! Returns in P the point of parameter U.
  //! P (U) = O + U * Dir where O is the "Location" point of the
  //! line and Dir the direction of the line.
  Standard_EXPORT   void D0 (const Standard_Real U, gp_Pnt& P)  const;
  

  //! Returns the point P of parameter u and the first derivative V1.
  Standard_EXPORT   void D1 (const Standard_Real U, gp_Pnt& P, gp_Vec& V1)  const;
  

  //! Returns the point P of parameter U, the first and second
  //! derivatives V1 and V2. V2 is a vector with null magnitude
  //! for a line.
  Standard_EXPORT   void D2 (const Standard_Real U, gp_Pnt& P, gp_Vec& V1, gp_Vec& V2)  const;
  

  //! V2 and V3 are vectors with null magnitude for a line.
  Standard_EXPORT   void D3 (const Standard_Real U, gp_Pnt& P, gp_Vec& V1, gp_Vec& V2, gp_Vec& V3)  const;
  

  //! The returned vector gives the value of the derivative for the
  //! order of derivation N.
  //! Raised if N < 1.
  Standard_EXPORT   gp_Vec DN (const Standard_Real U, const Standard_Integer N)  const;
  
  //! Applies the transformation T to this line.
  Standard_EXPORT   void Transform (const gp_Trsf& T) ;
  
  //! Returns the  parameter on the  transformed  curve for
  //! the transform of the point of parameter U on <me>.
  //!
  //! me->Transformed(T)->Value(me->TransformedParameter(U,T))
  //!
  //! is the same point as
  //!
  //! me->Value(U).Transformed(T)
  //!
  //! This methods returns <U> * T.ScaleFactor()
  Standard_EXPORT virtual   Standard_Real TransformedParameter (const Standard_Real U, const gp_Trsf& T)  const;
  
  //! Returns a  coefficient to compute the parameter on
  //! the transformed  curve  for  the transform  of the
  //! point on <me>.
  //!
  //! Transformed(T)->Value(U * ParametricTransformation(T))
  //!
  //! is the same point as
  //!
  //! Value(U).Transformed(T)
  //!
  //! This methods returns T.ScaleFactor()
  Standard_EXPORT virtual   Standard_Real ParametricTransformation (const gp_Trsf& T)  const;
  
  //! Creates a new object which is a copy of this line.
  Standard_EXPORT   Handle(Geom_Geometry) Copy()  const;




  DEFINE_STANDARD_RTTI(Geom_Line)

protected:




private: 


  gp_Ax1 pos;


};







#endif // _Geom_Line_HeaderFile
